@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.alicloud.gpdb.DbInstancePlanArgs.builder
import com.pulumi.alicloud.gpdb.kotlin.inputs.DbInstancePlanPlanConfigArgs
import com.pulumi.alicloud.gpdb.kotlin.inputs.DbInstancePlanPlanConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a AnalyticDB for PostgreSQL (GPDB) DB Instance Plan resource.
 * For information about AnalyticDB for PostgreSQL (GPDB) DB Instance Plan and how to use it, see [What is DB Instance Plan](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createdbinstanceplan).
 * > **NOTE:** Available since v1.189.0.
 * ## Import
 * GPDB DB Instance Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/dbInstancePlan:DbInstancePlan example <db_instance_id>:<plan_id>
 * ```
 * @property dbInstanceId The ID of the GPDB instance.
 * @property dbInstancePlanName The name of the Plan.
 * @property planConfigs The execution information of the plan. See `plan_config` below.
 * @property planDesc The description of the Plan.
 * @property planEndDate The end time of the Plan.
 * @property planScheduleType The execution mode of the plan. Valid values: `Postpone`, `Regular`.
 * @property planStartDate The start time of the Plan.
 * @property planType The type of the Plan. Valid values: `PauseResume`, `Resize`.
 * @property status The Status of the Plan. Valid values: `active`, `cancel`.
 */
public data class DbInstancePlanArgs(
    public val dbInstanceId: Output<String>? = null,
    public val dbInstancePlanName: Output<String>? = null,
    public val planConfigs: Output<List<DbInstancePlanPlanConfigArgs>>? = null,
    public val planDesc: Output<String>? = null,
    public val planEndDate: Output<String>? = null,
    public val planScheduleType: Output<String>? = null,
    public val planStartDate: Output<String>? = null,
    public val planType: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.DbInstancePlanArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.DbInstancePlanArgs =
        com.pulumi.alicloud.gpdb.DbInstancePlanArgs.builder()
            .dbInstanceId(dbInstanceId?.applyValue({ args0 -> args0 }))
            .dbInstancePlanName(dbInstancePlanName?.applyValue({ args0 -> args0 }))
            .planConfigs(
                planConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .planDesc(planDesc?.applyValue({ args0 -> args0 }))
            .planEndDate(planEndDate?.applyValue({ args0 -> args0 }))
            .planScheduleType(planScheduleType?.applyValue({ args0 -> args0 }))
            .planStartDate(planStartDate?.applyValue({ args0 -> args0 }))
            .planType(planType?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstancePlanArgs].
 */
@PulumiTagMarker
public class DbInstancePlanArgsBuilder internal constructor() {
    private var dbInstanceId: Output<String>? = null

    private var dbInstancePlanName: Output<String>? = null

    private var planConfigs: Output<List<DbInstancePlanPlanConfigArgs>>? = null

    private var planDesc: Output<String>? = null

    private var planEndDate: Output<String>? = null

    private var planScheduleType: Output<String>? = null

    private var planStartDate: Output<String>? = null

    private var planType: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The ID of the GPDB instance.
     */
    @JvmName("dcsoaaphjcthscgh")
    public suspend fun dbInstanceId(`value`: Output<String>) {
        this.dbInstanceId = value
    }

    /**
     * @param value The name of the Plan.
     */
    @JvmName("txeqejbeuhfsgrpy")
    public suspend fun dbInstancePlanName(`value`: Output<String>) {
        this.dbInstancePlanName = value
    }

    /**
     * @param value The execution information of the plan. See `plan_config` below.
     */
    @JvmName("bkuxffprgkhjfuye")
    public suspend fun planConfigs(`value`: Output<List<DbInstancePlanPlanConfigArgs>>) {
        this.planConfigs = value
    }

    @JvmName("ghneqkcwwtnmsmbr")
    public suspend fun planConfigs(vararg values: Output<DbInstancePlanPlanConfigArgs>) {
        this.planConfigs = Output.all(values.asList())
    }

    /**
     * @param values The execution information of the plan. See `plan_config` below.
     */
    @JvmName("klejiqwsftjmfnkb")
    public suspend fun planConfigs(values: List<Output<DbInstancePlanPlanConfigArgs>>) {
        this.planConfigs = Output.all(values)
    }

    /**
     * @param value The description of the Plan.
     */
    @JvmName("hfeayxmeyvaelrrq")
    public suspend fun planDesc(`value`: Output<String>) {
        this.planDesc = value
    }

    /**
     * @param value The end time of the Plan.
     */
    @JvmName("nmsnwamaglpbnjbd")
    public suspend fun planEndDate(`value`: Output<String>) {
        this.planEndDate = value
    }

    /**
     * @param value The execution mode of the plan. Valid values: `Postpone`, `Regular`.
     */
    @JvmName("aeivbnplwuxyowmw")
    public suspend fun planScheduleType(`value`: Output<String>) {
        this.planScheduleType = value
    }

    /**
     * @param value The start time of the Plan.
     */
    @JvmName("ypctqfqbbikfcnka")
    public suspend fun planStartDate(`value`: Output<String>) {
        this.planStartDate = value
    }

    /**
     * @param value The type of the Plan. Valid values: `PauseResume`, `Resize`.
     */
    @JvmName("aqdfdhqkprxsygsq")
    public suspend fun planType(`value`: Output<String>) {
        this.planType = value
    }

    /**
     * @param value The Status of the Plan. Valid values: `active`, `cancel`.
     */
    @JvmName("boocnaamacfycglw")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of the GPDB instance.
     */
    @JvmName("fenqspagnogkntbv")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceId = mapped
    }

    /**
     * @param value The name of the Plan.
     */
    @JvmName("dbdombrdjjtnrpfc")
    public suspend fun dbInstancePlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstancePlanName = mapped
    }

    /**
     * @param value The execution information of the plan. See `plan_config` below.
     */
    @JvmName("kjpwhtlhpcrodhwg")
    public suspend fun planConfigs(`value`: List<DbInstancePlanPlanConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planConfigs = mapped
    }

    /**
     * @param argument The execution information of the plan. See `plan_config` below.
     */
    @JvmName("grtidfwsajtdnhmh")
    public suspend fun planConfigs(argument: List<suspend DbInstancePlanPlanConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DbInstancePlanPlanConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.planConfigs = mapped
    }

    /**
     * @param argument The execution information of the plan. See `plan_config` below.
     */
    @JvmName("ajxdeunmefcnlhqp")
    public suspend fun planConfigs(vararg argument: suspend DbInstancePlanPlanConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DbInstancePlanPlanConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.planConfigs = mapped
    }

    /**
     * @param argument The execution information of the plan. See `plan_config` below.
     */
    @JvmName("fsdbnkqkrsqfhcxi")
    public suspend fun planConfigs(argument: suspend DbInstancePlanPlanConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DbInstancePlanPlanConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.planConfigs = mapped
    }

    /**
     * @param values The execution information of the plan. See `plan_config` below.
     */
    @JvmName("pgidfmkhxgesirna")
    public suspend fun planConfigs(vararg values: DbInstancePlanPlanConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.planConfigs = mapped
    }

    /**
     * @param value The description of the Plan.
     */
    @JvmName("einiciobissdvfvy")
    public suspend fun planDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planDesc = mapped
    }

    /**
     * @param value The end time of the Plan.
     */
    @JvmName("pwayerwbgbwcagia")
    public suspend fun planEndDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planEndDate = mapped
    }

    /**
     * @param value The execution mode of the plan. Valid values: `Postpone`, `Regular`.
     */
    @JvmName("itwacbrsqntwahen")
    public suspend fun planScheduleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planScheduleType = mapped
    }

    /**
     * @param value The start time of the Plan.
     */
    @JvmName("xopkvisbxguvergn")
    public suspend fun planStartDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planStartDate = mapped
    }

    /**
     * @param value The type of the Plan. Valid values: `PauseResume`, `Resize`.
     */
    @JvmName("xstqyrsipfkydnmt")
    public suspend fun planType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planType = mapped
    }

    /**
     * @param value The Status of the Plan. Valid values: `active`, `cancel`.
     */
    @JvmName("ryomypiusimnqufw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DbInstancePlanArgs = DbInstancePlanArgs(
        dbInstanceId = dbInstanceId,
        dbInstancePlanName = dbInstancePlanName,
        planConfigs = planConfigs,
        planDesc = planDesc,
        planEndDate = planEndDate,
        planScheduleType = planScheduleType,
        planStartDate = planStartDate,
        planType = planType,
        status = status,
    )
}
