@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ElasticInstance].
 */
@PulumiTagMarker
public class ElasticInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ElasticInstanceArgs = ElasticInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ElasticInstanceArgsBuilder.() -> Unit) {
        val builder = ElasticInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ElasticInstance {
        val builtJavaResource = com.pulumi.alicloud.gpdb.ElasticInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ElasticInstance(builtJavaResource)
    }
}

/**
 * Provides a AnalyticDB for PostgreSQL instance resource which storage type is flexible. Compared to the reserved storage ADB PG instance, you can scale up each disk and smoothly scale out nodes online.
 * For more detail product introduction, see [here](https://www.alibabacloud.com/help/doc-detail/141368.htm).
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.147.0`. Please use new resource alicloud_gpdb_instance.
 * > **NOTE:**  Available in 1.127.0+
 * ## Example Usage
 * ### Create a AnalyticDB for PostgreSQL instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "Gpdb",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     name: "vpc-123456",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     vswitchName: "vpc-123456",
 * });
 * const adbPgInstance = new alicloud.gpdb.ElasticInstance("adb_pg_instance", {
 *     engine: "gpdb",
 *     engineVersion: "6.0",
 *     segStorageType: "cloud_essd",
 *     segNodeNum: 4,
 *     storageSize: 50,
 *     instanceSpec: "2C16G",
 *     dbInstanceDescription: "Created by terraform",
 *     instanceNetworkType: "VPC",
 *     paymentType: "PayAsYouGo",
 *     vswitchId: defaultSwitch.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_resource_creation="Gpdb")
 * default_network = alicloud.vpc.Network("default",
 *     name="vpc-123456",
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     zone_id=default.zones[0].id,
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     vswitch_name="vpc-123456")
 * adb_pg_instance = alicloud.gpdb.ElasticInstance("adb_pg_instance",
 *     engine="gpdb",
 *     engine_version="6.0",
 *     seg_storage_type="cloud_essd",
 *     seg_node_num=4,
 *     storage_size=50,
 *     instance_spec="2C16G",
 *     db_instance_description="Created by terraform",
 *     instance_network_type="VPC",
 *     payment_type="PayAsYouGo",
 *     vswitch_id=default_switch.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Gpdb",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         Name = "vpc-123456",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         VswitchName = "vpc-123456",
 *     });
 *     var adbPgInstance = new AliCloud.Gpdb.ElasticInstance("adb_pg_instance", new()
 *     {
 *         Engine = "gpdb",
 *         EngineVersion = "6.0",
 *         SegStorageType = "cloud_essd",
 *         SegNodeNum = 4,
 *         StorageSize = 50,
 *         InstanceSpec = "2C16G",
 *         DbInstanceDescription = "Created by terraform",
 *         InstanceNetworkType = "VPC",
 *         PaymentType = "PayAsYouGo",
 *         VswitchId = defaultSwitch.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Gpdb"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			Name:      pulumi.String("vpc-123456"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			VswitchName: pulumi.String("vpc-123456"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gpdb.NewElasticInstance(ctx, "adb_pg_instance", &gpdb.ElasticInstanceArgs{
 * 			Engine:                pulumi.String("gpdb"),
 * 			EngineVersion:         pulumi.String("6.0"),
 * 			SegStorageType:        pulumi.String("cloud_essd"),
 * 			SegNodeNum:            pulumi.Int(4),
 * 			StorageSize:           pulumi.Int(50),
 * 			InstanceSpec:          pulumi.String("2C16G"),
 * 			DbInstanceDescription: pulumi.String("Created by terraform"),
 * 			InstanceNetworkType:   pulumi.String("VPC"),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			VswitchId:             defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.gpdb.ElasticInstance;
 * import com.pulumi.alicloud.gpdb.ElasticInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Gpdb")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .name("vpc-123456")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .zoneId(default_.zones()[0].id())
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .vswitchName("vpc-123456")
 *             .build());
 *         var adbPgInstance = new ElasticInstance("adbPgInstance", ElasticInstanceArgs.builder()
 *             .engine("gpdb")
 *             .engineVersion("6.0")
 *             .segStorageType("cloud_essd")
 *             .segNodeNum(4)
 *             .storageSize(50)
 *             .instanceSpec("2C16G")
 *             .dbInstanceDescription("Created by terraform")
 *             .instanceNetworkType("VPC")
 *             .paymentType("PayAsYouGo")
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       name: vpc-123456
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       zoneId: ${default.zones[0].id}
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       vswitchName: vpc-123456
 *   adbPgInstance:
 *     type: alicloud:gpdb:ElasticInstance
 *     name: adb_pg_instance
 *     properties:
 *       engine: gpdb
 *       engineVersion: '6.0'
 *       segStorageType: cloud_essd
 *       segNodeNum: 4
 *       storageSize: 50
 *       instanceSpec: 2C16G
 *       dbInstanceDescription: Created by terraform
 *       instanceNetworkType: VPC
 *       paymentType: PayAsYouGo
 *       vswitchId: ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Gpdb
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * AnalyticDB for PostgreSQL can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/elasticInstance:ElasticInstance adb_pg_instance gp-bpxxxxxxxxxxxxxx
 * ```
 */
public class ElasticInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.gpdb.ElasticInstance,
) : KotlinCustomResource(javaResource, ElasticInstanceMapper) {
    /**
     * ADB PG instance connection string.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
     */
    public val dbInstanceCategory: Output<String>
        get() = javaResource.dbInstanceCategory().applyValue({ args0 -> args0 })

    /**
     * The description of ADB PG instance. It is a string of 2 to 256 characters.
     */
    public val dbInstanceDescription: Output<String>?
        get() = javaResource.dbInstanceDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
     */
    public val encryptionKey: Output<String>?
        get() = javaResource.encryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
     */
    public val encryptionType: Output<String>?
        get() = javaResource.encryptionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Database engine: `gpdb`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Database version. Valid value is `6.0`.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The network type of ADB PG instance. Only `VPC` supported now.
     */
    public val instanceNetworkType: Output<String>?
        get() = javaResource.instanceNetworkType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The specification of segment nodes.
     * * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
     * * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
     */
    public val instanceSpec: Output<String>
        get() = javaResource.instanceSpec().applyValue({ args0 -> args0 })

    /**
     * The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.
     * **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
     */
    public val paymentDuration: Output<Int>?
        get() = javaResource.paymentDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.
     * **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
     */
    public val paymentDurationUnit: Output<String>?
        get() = javaResource.paymentDurationUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
     */
    public val paymentType: Output<String>?
        get() = javaResource.paymentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Available in 1.196.0+) The connection port of the instance.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    public val securityIpLists: Output<List<String>>
        get() = javaResource.securityIpLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
     */
    public val segNodeNum: Output<Int>
        get() = javaResource.segNodeNum().applyValue({ args0 -> args0 })

    /**
     * The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
     */
    public val segStorageType: Output<String>
        get() = javaResource.segStorageType().applyValue({ args0 -> args0 })

    /**
     * Instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
     */
    public val storageSize: Output<Int>
        get() = javaResource.storageSize().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The virtual switch ID to launch ADB PG instances in one VPC.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ElasticInstanceMapper : ResourceMapper<ElasticInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.gpdb.ElasticInstance::class == javaResource::class

    override fun map(javaResource: Resource): ElasticInstance = ElasticInstance(
        javaResource as
            com.pulumi.alicloud.gpdb.ElasticInstance,
    )
}

/**
 * @see [ElasticInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ElasticInstance].
 */
public suspend fun elasticInstance(
    name: String,
    block: suspend ElasticInstanceResourceBuilder.() -> Unit,
): ElasticInstance {
    val builder = ElasticInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ElasticInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun elasticInstance(name: String): ElasticInstance {
    val builder = ElasticInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
