@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.alicloud.gpdb.ElasticInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AnalyticDB for PostgreSQL instance resource which storage type is flexible. Compared to the reserved storage ADB PG instance, you can scale up each disk and smoothly scale out nodes online.
 * For more detail product introduction, see [here](https://www.alibabacloud.com/help/doc-detail/141368.htm).
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.147.0`. Please use new resource alicloud_gpdb_instance.
 * > **NOTE:**  Available in 1.127.0+
 * ## Example Usage
 * ### Create a AnalyticDB for PostgreSQL instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "Gpdb",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     name: "vpc-123456",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     vswitchName: "vpc-123456",
 * });
 * const adbPgInstance = new alicloud.gpdb.ElasticInstance("adb_pg_instance", {
 *     engine: "gpdb",
 *     engineVersion: "6.0",
 *     segStorageType: "cloud_essd",
 *     segNodeNum: 4,
 *     storageSize: 50,
 *     instanceSpec: "2C16G",
 *     dbInstanceDescription: "Created by terraform",
 *     instanceNetworkType: "VPC",
 *     paymentType: "PayAsYouGo",
 *     vswitchId: defaultSwitch.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_zones(available_resource_creation="Gpdb")
 * default_network = alicloud.vpc.Network("default",
 *     name="vpc-123456",
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     zone_id=default.zones[0].id,
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     vswitch_name="vpc-123456")
 * adb_pg_instance = alicloud.gpdb.ElasticInstance("adb_pg_instance",
 *     engine="gpdb",
 *     engine_version="6.0",
 *     seg_storage_type="cloud_essd",
 *     seg_node_num=4,
 *     storage_size=50,
 *     instance_spec="2C16G",
 *     db_instance_description="Created by terraform",
 *     instance_network_type="VPC",
 *     payment_type="PayAsYouGo",
 *     vswitch_id=default_switch.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Gpdb",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         Name = "vpc-123456",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         VswitchName = "vpc-123456",
 *     });
 *     var adbPgInstance = new AliCloud.Gpdb.ElasticInstance("adb_pg_instance", new()
 *     {
 *         Engine = "gpdb",
 *         EngineVersion = "6.0",
 *         SegStorageType = "cloud_essd",
 *         SegNodeNum = 4,
 *         StorageSize = 50,
 *         InstanceSpec = "2C16G",
 *         DbInstanceDescription = "Created by terraform",
 *         InstanceNetworkType = "VPC",
 *         PaymentType = "PayAsYouGo",
 *         VswitchId = defaultSwitch.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Gpdb"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			Name:      pulumi.String("vpc-123456"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			VswitchName: pulumi.String("vpc-123456"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gpdb.NewElasticInstance(ctx, "adb_pg_instance", &gpdb.ElasticInstanceArgs{
 * 			Engine:                pulumi.String("gpdb"),
 * 			EngineVersion:         pulumi.String("6.0"),
 * 			SegStorageType:        pulumi.String("cloud_essd"),
 * 			SegNodeNum:            pulumi.Int(4),
 * 			StorageSize:           pulumi.Int(50),
 * 			InstanceSpec:          pulumi.String("2C16G"),
 * 			DbInstanceDescription: pulumi.String("Created by terraform"),
 * 			InstanceNetworkType:   pulumi.String("VPC"),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			VswitchId:             defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.gpdb.ElasticInstance;
 * import com.pulumi.alicloud.gpdb.ElasticInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Gpdb")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .name("vpc-123456")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .zoneId(default_.zones()[0].id())
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .vswitchName("vpc-123456")
 *             .build());
 *         var adbPgInstance = new ElasticInstance("adbPgInstance", ElasticInstanceArgs.builder()
 *             .engine("gpdb")
 *             .engineVersion("6.0")
 *             .segStorageType("cloud_essd")
 *             .segNodeNum(4)
 *             .storageSize(50)
 *             .instanceSpec("2C16G")
 *             .dbInstanceDescription("Created by terraform")
 *             .instanceNetworkType("VPC")
 *             .paymentType("PayAsYouGo")
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       name: vpc-123456
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       zoneId: ${default.zones[0].id}
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       vswitchName: vpc-123456
 *   adbPgInstance:
 *     type: alicloud:gpdb:ElasticInstance
 *     name: adb_pg_instance
 *     properties:
 *       engine: gpdb
 *       engineVersion: '6.0'
 *       segStorageType: cloud_essd
 *       segNodeNum: 4
 *       storageSize: 50
 *       instanceSpec: 2C16G
 *       dbInstanceDescription: Created by terraform
 *       instanceNetworkType: VPC
 *       paymentType: PayAsYouGo
 *       vswitchId: ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Gpdb
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * AnalyticDB for PostgreSQL can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/elasticInstance:ElasticInstance adb_pg_instance gp-bpxxxxxxxxxxxxxx
 * ```
 * @property dbInstanceCategory The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
 * @property dbInstanceDescription The description of ADB PG instance. It is a string of 2 to 256 characters.
 * @property encryptionKey The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
 * @property encryptionType The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
 * @property engine Database engine: `gpdb`.
 * @property engineVersion Database version. Valid value is `6.0`.
 * @property instanceNetworkType The network type of ADB PG instance. Only `VPC` supported now.
 * @property instanceSpec The specification of segment nodes.
 * * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
 * * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
 * @property paymentDuration The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.
 * **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
 * @property paymentDurationUnit The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.
 * **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
 * @property paymentType Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
 * @property securityIpLists List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
 * @property segNodeNum The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
 * @property segStorageType The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
 * @property storageSize The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
 * @property tags A mapping of tags to assign to the resource.
 * @property vswitchId The virtual switch ID to launch ADB PG instances in one VPC.
 * @property zoneId The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
 */
public data class ElasticInstanceArgs(
    public val dbInstanceCategory: Output<String>? = null,
    public val dbInstanceDescription: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val encryptionType: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val instanceNetworkType: Output<String>? = null,
    public val instanceSpec: Output<String>? = null,
    public val paymentDuration: Output<Int>? = null,
    public val paymentDurationUnit: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val securityIpLists: Output<List<String>>? = null,
    public val segNodeNum: Output<Int>? = null,
    public val segStorageType: Output<String>? = null,
    public val storageSize: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.ElasticInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.ElasticInstanceArgs =
        com.pulumi.alicloud.gpdb.ElasticInstanceArgs.builder()
            .dbInstanceCategory(dbInstanceCategory?.applyValue({ args0 -> args0 }))
            .dbInstanceDescription(dbInstanceDescription?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .encryptionType(encryptionType?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .instanceNetworkType(instanceNetworkType?.applyValue({ args0 -> args0 }))
            .instanceSpec(instanceSpec?.applyValue({ args0 -> args0 }))
            .paymentDuration(paymentDuration?.applyValue({ args0 -> args0 }))
            .paymentDurationUnit(paymentDurationUnit?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .securityIpLists(securityIpLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .segNodeNum(segNodeNum?.applyValue({ args0 -> args0 }))
            .segStorageType(segStorageType?.applyValue({ args0 -> args0 }))
            .storageSize(storageSize?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ElasticInstanceArgs].
 */
@PulumiTagMarker
public class ElasticInstanceArgsBuilder internal constructor() {
    private var dbInstanceCategory: Output<String>? = null

    private var dbInstanceDescription: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var encryptionType: Output<String>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var instanceNetworkType: Output<String>? = null

    private var instanceSpec: Output<String>? = null

    private var paymentDuration: Output<Int>? = null

    private var paymentDurationUnit: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var securityIpLists: Output<List<String>>? = null

    private var segNodeNum: Output<Int>? = null

    private var segStorageType: Output<String>? = null

    private var storageSize: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
     */
    @JvmName("itxvuvggpdbciyis")
    public suspend fun dbInstanceCategory(`value`: Output<String>) {
        this.dbInstanceCategory = value
    }

    /**
     * @param value The description of ADB PG instance. It is a string of 2 to 256 characters.
     */
    @JvmName("hqpwhfftlmyinyuw")
    public suspend fun dbInstanceDescription(`value`: Output<String>) {
        this.dbInstanceDescription = value
    }

    /**
     * @param value The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
     */
    @JvmName("kbvniqyipocsotfs")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
     */
    @JvmName("iwnemtbmijfkqtrt")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value Database engine: `gpdb`.
     */
    @JvmName("wtumfqfaybpymruy")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Database version. Valid value is `6.0`.
     */
    @JvmName("oofocevfugwbktlm")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The network type of ADB PG instance. Only `VPC` supported now.
     */
    @JvmName("wttexjpxkvosxman")
    public suspend fun instanceNetworkType(`value`: Output<String>) {
        this.instanceNetworkType = value
    }

    /**
     * @param value The specification of segment nodes.
     * * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
     * * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
     */
    @JvmName("epennubrmppdvvdr")
    public suspend fun instanceSpec(`value`: Output<String>) {
        this.instanceSpec = value
    }

    /**
     * @param value The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.
     * **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
     */
    @JvmName("xjrwjhwbqjjnhwel")
    public suspend fun paymentDuration(`value`: Output<Int>) {
        this.paymentDuration = value
    }

    /**
     * @param value The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.
     * **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
     */
    @JvmName("hdievpjkqbfeekpb")
    public suspend fun paymentDurationUnit(`value`: Output<String>) {
        this.paymentDurationUnit = value
    }

    /**
     * @param value Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("flbkjxenjmgevlmv")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("imfkfuqjytdvdeqf")
    public suspend fun securityIpLists(`value`: Output<List<String>>) {
        this.securityIpLists = value
    }

    @JvmName("mljhmpppdsjwpgqv")
    public suspend fun securityIpLists(vararg values: Output<String>) {
        this.securityIpLists = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("osyhgywkapqlliop")
    public suspend fun securityIpLists(values: List<Output<String>>) {
        this.securityIpLists = Output.all(values)
    }

    /**
     * @param value The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
     */
    @JvmName("fikqcsnsnkfavlyu")
    public suspend fun segNodeNum(`value`: Output<Int>) {
        this.segNodeNum = value
    }

    /**
     * @param value The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
     */
    @JvmName("ukrbqgyerruiwkit")
    public suspend fun segStorageType(`value`: Output<String>) {
        this.segStorageType = value
    }

    /**
     * @param value The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
     */
    @JvmName("xoxshibfjhtquqfy")
    public suspend fun storageSize(`value`: Output<Int>) {
        this.storageSize = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jbimgibhreplqueb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The virtual switch ID to launch ADB PG instances in one VPC.
     */
    @JvmName("mvocrhyajptxwqbo")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
     */
    @JvmName("gsomqmqassprmnup")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
     */
    @JvmName("eacgxpawsedhqlpk")
    public suspend fun dbInstanceCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceCategory = mapped
    }

    /**
     * @param value The description of ADB PG instance. It is a string of 2 to 256 characters.
     */
    @JvmName("kioqmtehalmrxnug")
    public suspend fun dbInstanceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceDescription = mapped
    }

    /**
     * @param value The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
     */
    @JvmName("bcgymrhowstnpqso")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
     */
    @JvmName("hdemohqyyxmjpgca")
    public suspend fun encryptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value Database engine: `gpdb`.
     */
    @JvmName("pydgxgvhqdgdomil")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Database version. Valid value is `6.0`.
     */
    @JvmName("kcqtqfbeiispktsw")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The network type of ADB PG instance. Only `VPC` supported now.
     */
    @JvmName("jskxbcgyifnpbtri")
    public suspend fun instanceNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceNetworkType = mapped
    }

    /**
     * @param value The specification of segment nodes.
     * * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
     * * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
     */
    @JvmName("kvbybcoflieitmxk")
    public suspend fun instanceSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceSpec = mapped
    }

    /**
     * @param value The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.
     * **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
     */
    @JvmName("kalwirwgvlwlbwbx")
    public suspend fun paymentDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentDuration = mapped
    }

    /**
     * @param value The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.
     * **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
     */
    @JvmName("gdaxwyjcfcrmdjre")
    public suspend fun paymentDurationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentDurationUnit = mapped
    }

    /**
     * @param value Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("sdnwjupmtumgscvg")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("oysipvyjdawggjbi")
    public suspend fun securityIpLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpLists = mapped
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("vfbspubmcnwjxxrv")
    public suspend fun securityIpLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIpLists = mapped
    }

    /**
     * @param value The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
     */
    @JvmName("dcsvuxdqiisutgqq")
    public suspend fun segNodeNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segNodeNum = mapped
    }

    /**
     * @param value The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
     */
    @JvmName("plvujdkorxxmsffk")
    public suspend fun segStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segStorageType = mapped
    }

    /**
     * @param value The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
     */
    @JvmName("cjoimiumcqcscaup")
    public suspend fun storageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSize = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("emqnfxuryicphhlq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("utvkxrmovacuhhhq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The virtual switch ID to launch ADB PG instances in one VPC.
     */
    @JvmName("igeenjvarhievtke")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
     */
    @JvmName("emywxtraloyascke")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ElasticInstanceArgs = ElasticInstanceArgs(
        dbInstanceCategory = dbInstanceCategory,
        dbInstanceDescription = dbInstanceDescription,
        encryptionKey = encryptionKey,
        encryptionType = encryptionType,
        engine = engine,
        engineVersion = engineVersion,
        instanceNetworkType = instanceNetworkType,
        instanceSpec = instanceSpec,
        paymentDuration = paymentDuration,
        paymentDurationUnit = paymentDurationUnit,
        paymentType = paymentType,
        securityIpLists = securityIpLists,
        segNodeNum = segNodeNum,
        segStorageType = segStorageType,
        storageSize = storageSize,
        tags = tags,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
