@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.alicloud.gpdb.GpdbFunctions.getAccountsPlain
import com.pulumi.alicloud.gpdb.GpdbFunctions.getDbInstancePlansPlain
import com.pulumi.alicloud.gpdb.GpdbFunctions.getInstancesPlain
import com.pulumi.alicloud.gpdb.GpdbFunctions.getZonesPlain
import com.pulumi.alicloud.gpdb.kotlin.inputs.GetAccountsPlainArgs
import com.pulumi.alicloud.gpdb.kotlin.inputs.GetAccountsPlainArgsBuilder
import com.pulumi.alicloud.gpdb.kotlin.inputs.GetDbInstancePlansPlainArgs
import com.pulumi.alicloud.gpdb.kotlin.inputs.GetDbInstancePlansPlainArgsBuilder
import com.pulumi.alicloud.gpdb.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.gpdb.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.gpdb.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.gpdb.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.gpdb.kotlin.outputs.GetAccountsResult
import com.pulumi.alicloud.gpdb.kotlin.outputs.GetDbInstancePlansResult
import com.pulumi.alicloud.gpdb.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.gpdb.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.gpdb.kotlin.outputs.GetAccountsResult.Companion.toKotlin as getAccountsResultToKotlin
import com.pulumi.alicloud.gpdb.kotlin.outputs.GetDbInstancePlansResult.Companion.toKotlin as getDbInstancePlansResultToKotlin
import com.pulumi.alicloud.gpdb.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.gpdb.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object GpdbFunctions {
    /**
     * This data source provides the Gpdb Accounts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.gpdb.getAccounts({
     *     dbInstanceId: "example_value",
     *     ids: [
     *         "my-Account-1",
     *         "my-Account-2",
     *     ],
     * });
     * export const gpdbAccountId1 = ids.then(ids => ids.accounts?.[0]?.id);
     * const nameRegex = alicloud.gpdb.getAccounts({
     *     dbInstanceId: "example_value",
     *     nameRegex: "^my-Account",
     * });
     * export const gpdbAccountId2 = nameRegex.then(nameRegex => nameRegex.accounts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.gpdb.get_accounts(db_instance_id="example_value",
     *     ids=[
     *         "my-Account-1",
     *         "my-Account-2",
     *     ])
     * pulumi.export("gpdbAccountId1", ids.accounts[0].id)
     * name_regex = alicloud.gpdb.get_accounts(db_instance_id="example_value",
     *     name_regex="^my-Account")
     * pulumi.export("gpdbAccountId2", name_regex.accounts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Gpdb.GetAccounts.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "my-Account-1",
     *             "my-Account-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Gpdb.GetAccounts.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *         NameRegex = "^my-Account",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gpdbAccountId1"] = ids&#46;Apply(getAccountsResult => getAccountsResult&#46;Accounts[0]?.Id),
     *         ["gpdbAccountId2"] = nameRegex&#46;Apply(getAccountsResult => getAccountsResult&#46;Accounts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := gpdb.GetAccounts(ctx, &gpdb.GetAccountsArgs{
     * 			DbInstanceId: "example_value",
     * 			Ids: []string{
     * 				"my-Account-1",
     * 				"my-Account-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gpdbAccountId1", ids.Accounts[0].Id)
     * 		nameRegex, err := gpdb.GetAccounts(ctx, &gpdb.GetAccountsArgs{
     * 			DbInstanceId: "example_value",
     * 			NameRegex:    pulumi.StringRef("^my-Account"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gpdbAccountId2", nameRegex.Accounts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.gpdb.GpdbFunctions;
     * import com.pulumi.alicloud.gpdb.inputs.GetAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GpdbFunctions.getAccounts(GetAccountsArgs.builder()
     *             .dbInstanceId("example_value")
     *             .ids(
     *                 "my-Account-1",
     *                 "my-Account-2")
     *             .build());
     *         ctx.export("gpdbAccountId1", ids.applyValue(getAccountsResult -> getAccountsResult.accounts()[0].id()));
     *         final var nameRegex = GpdbFunctions.getAccounts(GetAccountsArgs.builder()
     *             .dbInstanceId("example_value")
     *             .nameRegex("^my-Account")
     *             .build());
     *         ctx.export("gpdbAccountId2", nameRegex.applyValue(getAccountsResult -> getAccountsResult.accounts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:gpdb:getAccounts
     *       Arguments:
     *         dbInstanceId: example_value
     *         ids:
     *           - my-Account-1
     *           - my-Account-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:gpdb:getAccounts
     *       Arguments:
     *         dbInstanceId: example_value
     *         nameRegex: ^my-Account
     * outputs:
     *   gpdbAccountId1: ${ids.accounts[0].id}
     *   gpdbAccountId2: ${nameRegex.accounts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccounts.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: GetAccountsPlainArgs): GetAccountsResult =
        getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())

    /**
     * @see [getAccounts].
     * @param dbInstanceId The ID of the instance.
     * @param ids A list of Account IDs. Its element value is same as Account Name.
     * @param nameRegex A regex string to filter results by Account name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the account. Valid values: `Active`, `Creating` and `Deleting`.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(
        dbInstanceId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAccountsResult {
        val argument = GetAccountsPlainArgs(
            dbInstanceId = dbInstanceId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;gpdb&#46;kotlin&#46;inputs&#46;GetAccountsPlainArgs].
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: suspend GetAccountsPlainArgsBuilder.() -> Unit): GetAccountsResult {
        val builder = GetAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountsResultToKotlin(getAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Gpdb Db Instance Plans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.189.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.gpdb.getDbInstancePlans({
     *     dbInstanceId: "example_value",
     *     ids: ["example_value"],
     * });
     * export const gpdbDbInstancePlanId1 = ids.then(ids => ids.plans?.[0]?.id);
     * const nameRegex = alicloud.gpdb.getDbInstancePlans({
     *     dbInstanceId: "example_value",
     *     nameRegex: "^my-DBInstancePlan",
     * });
     * export const gpdbDbInstancePlanId2 = nameRegex.then(nameRegex => nameRegex.plans?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.gpdb.get_db_instance_plans(db_instance_id="example_value",
     *     ids=["example_value"])
     * pulumi.export("gpdbDbInstancePlanId1", ids.plans[0].id)
     * name_regex = alicloud.gpdb.get_db_instance_plans(db_instance_id="example_value",
     *     name_regex="^my-DBInstancePlan")
     * pulumi.export("gpdbDbInstancePlanId2", name_regex.plans[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Gpdb.GetDbInstancePlans.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var nameRegex = AliCloud.Gpdb.GetDbInstancePlans.Invoke(new()
     *     {
     *         DbInstanceId = "example_value",
     *         NameRegex = "^my-DBInstancePlan",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["gpdbDbInstancePlanId1"] = ids&#46;Apply(getDbInstancePlansResult => getDbInstancePlansResult&#46;Plans[0]?.Id),
     *         ["gpdbDbInstancePlanId2"] = nameRegex&#46;Apply(getDbInstancePlansResult => getDbInstancePlansResult&#46;Plans[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := gpdb.GetDbInstancePlans(ctx, &gpdb.GetDbInstancePlansArgs{
     * 			DbInstanceId: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gpdbDbInstancePlanId1", ids.Plans[0].Id)
     * 		nameRegex, err := gpdb.GetDbInstancePlans(ctx, &gpdb.GetDbInstancePlansArgs{
     * 			DbInstanceId: "example_value",
     * 			NameRegex:    pulumi.StringRef("^my-DBInstancePlan"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gpdbDbInstancePlanId2", nameRegex.Plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.gpdb.GpdbFunctions;
     * import com.pulumi.alicloud.gpdb.inputs.GetDbInstancePlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GpdbFunctions.getDbInstancePlans(GetDbInstancePlansArgs.builder()
     *             .dbInstanceId("example_value")
     *             .ids("example_value")
     *             .build());
     *         ctx.export("gpdbDbInstancePlanId1", ids.applyValue(getDbInstancePlansResult -> getDbInstancePlansResult.plans()[0].id()));
     *         final var nameRegex = GpdbFunctions.getDbInstancePlans(GetDbInstancePlansArgs.builder()
     *             .dbInstanceId("example_value")
     *             .nameRegex("^my-DBInstancePlan")
     *             .build());
     *         ctx.export("gpdbDbInstancePlanId2", nameRegex.applyValue(getDbInstancePlansResult -> getDbInstancePlansResult.plans()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:gpdb:getDbInstancePlans
     *       Arguments:
     *         dbInstanceId: example_value
     *         ids:
     *           - example_value
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:gpdb:getDbInstancePlans
     *       Arguments:
     *         dbInstanceId: example_value
     *         nameRegex: ^my-DBInstancePlan
     * outputs:
     *   gpdbDbInstancePlanId1: ${ids.plans[0].id}
     *   gpdbDbInstancePlanId2: ${nameRegex.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDbInstancePlans.
     * @return A collection of values returned by getDbInstancePlans.
     */
    public suspend fun getDbInstancePlans(argument: GetDbInstancePlansPlainArgs): GetDbInstancePlansResult =
        getDbInstancePlansResultToKotlin(getDbInstancePlansPlain(argument.toJava()).await())

    /**
     * @see [getDbInstancePlans].
     * @param dbInstanceId The ID of the Database instance.
     * @param ids A list of DB Instance Plan IDs.
     * @param nameRegex A regex string to filter results by DB Instance Plan name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param planScheduleType Plan scheduling type. Valid values: `Postpone`, `Regular`.
     * @param planType The type of the Plan. Valid values: `PauseResume`, `Resize`.
     * @param status Planning Status. Valid values: `active`, `cancel`, `deleted`, `finished`.
     * @return A collection of values returned by getDbInstancePlans.
     */
    public suspend fun getDbInstancePlans(
        dbInstanceId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        planScheduleType: String? = null,
        planType: String? = null,
        status: String? = null,
    ): GetDbInstancePlansResult {
        val argument = GetDbInstancePlansPlainArgs(
            dbInstanceId = dbInstanceId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            planScheduleType = planScheduleType,
            planType = planType,
            status = status,
        )
        return getDbInstancePlansResultToKotlin(getDbInstancePlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getDbInstancePlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;gpdb&#46;kotlin&#46;inputs&#46;GetDbInstancePlansPlainArgs].
     * @return A collection of values returned by getDbInstancePlans.
     */
    public suspend fun getDbInstancePlans(argument: suspend GetDbInstancePlansPlainArgsBuilder.() -> Unit): GetDbInstancePlansResult {
        val builder = GetDbInstancePlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDbInstancePlansResultToKotlin(getDbInstancePlansPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the AnalyticDB for PostgreSQL instances of the current Alibaba Cloud user.
     * > **NOTE:**  Available in 1.47.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.gpdb.getInstances({});
     * export const gpdbDbInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.gpdb.get_instances()
     * pulumi.export("gpdbDbInstanceId1", ids.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Gpdb.GetInstances.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["gpdbDbInstanceId1"] = ids&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := gpdb.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("gpdbDbInstanceId1", ids.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.gpdb.GpdbFunctions;
     * import com.pulumi.alicloud.gpdb.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = GpdbFunctions.getInstances();
     *         ctx.export("gpdbDbInstanceId1", ids.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:gpdb:getInstances
     *       Arguments: {}
     * outputs:
     *   gpdbDbInstanceId1: ${ids.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param availabilityZone Instance availability zone.
     * @param dbInstanceCategories The db instance categories.
     * @param dbInstanceModes The db instance modes.
     * @param description The description of the instance.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids The ids list of AnalyticDB for PostgreSQL instances.
     * @param instanceNetworkType The network type of the instance.
     * @param nameRegex A regex string to apply to the instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the enterprise resource group to which the instance belongs.
     * @param status The status of the instance. Valid values: `Creating`, `DBInstanceClassChanging`, `DBInstanceNetTypeChanging`, `Deleting`, `EngineVersionUpgrading`, `GuardDBInstanceCreating`, `GuardSwitching`, `Importing`, `ImportingFromOtherInstance`, `Rebooting`, `Restoring`, `Running`, `Transfering`, `TransferingToOtherInstance`.
     * @param tags
     * @param vswitchId Used to retrieve instances belong to specified `vswitch` resources.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        availabilityZone: String? = null,
        dbInstanceCategories: String? = null,
        dbInstanceModes: String? = null,
        description: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceNetworkType: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vswitchId: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            availabilityZone = availabilityZone,
            dbInstanceCategories = dbInstanceCategories,
            dbInstanceModes = dbInstanceModes,
            description = description,
            enableDetails = enableDetails,
            ids = ids,
            instanceNetworkType = instanceNetworkType,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
            vswitchId = vswitchId,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;gpdb&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for Gpdb that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.73.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```yaml
     * resources:
     *   # Create an Gpdb instance with the first matched zone
     *   hbase:
     *     type: alicloud:hbase:Instance
     *     properties:
     *       availabilityZone: ${zonesIds.zones[0].id}
     * variables:
     *   # Declare the data source
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:gpdb:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch Gpdb instances.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(multi: Boolean? = null, outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            multi = multi,
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;gpdb&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
