@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.alicloud.gpdb.kotlin.outputs.InstanceIpWhitelist
import com.pulumi.alicloud.gpdb.kotlin.outputs.InstanceIpWhitelist.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.gpdb.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a AnalyticDB for PostgreSQL instance resource supports replica set instances only. the AnalyticDB for PostgreSQL provides stable, reliable, and automatic scalable database services.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/api-gpdb-2016-05-03-createdbinstance)
 * > **NOTE:** Available since v1.47.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetZones = alicloud.gpdb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, defaultGetZones])&#46;then(([defaultGetNetworks, defaultGetZones]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: defaultGetZones.ids?.[0],
 * }));
 * const defaultInstance = new alicloud.gpdb.Instance("default", {
 *     dbInstanceCategory: "HighAvailability",
 *     dbInstanceClass: "gpdb.group.segsdx1",
 *     dbInstanceMode: "StorageElastic",
 *     description: name,
 *     engine: "gpdb",
 *     engineVersion: "6.0",
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.ids?.[0]),
 *     instanceNetworkType: "VPC",
 *     instanceSpec: "2C16G",
 *     paymentType: "PayAsYouGo",
 *     segStorageType: "cloud_essd",
 *     segNodeNum: 4,
 *     storageSize: 50,
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     ipWhitelists: [{
 *         securityIpList: "127.0.0.1",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_zones = alicloud.gpdb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default_get_zones.ids[0])
 * default_instance = alicloud.gpdb.Instance("default",
 *     db_instance_category="HighAvailability",
 *     db_instance_class="gpdb.group.segsdx1",
 *     db_instance_mode="StorageElastic",
 *     description=name,
 *     engine="gpdb",
 *     engine_version="6.0",
 *     zone_id=default_get_zones.ids[0],
 *     instance_network_type="VPC",
 *     instance_spec="2C16G",
 *     payment_type="PayAsYouGo",
 *     seg_storage_type="cloud_essd",
 *     seg_node_num=4,
 *     storage_size=50,
 *     vpc_id=default_get_networks.ids[0],
 *     vswitch_id=default_get_switches.ids[0],
 *     ip_whitelists=[{
 *         "security_ip_list": "127.0.0.1",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetZones = AliCloud.Gpdb.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var defaultInstance = new AliCloud.Gpdb.Instance("default", new()
 *     {
 *         DbInstanceCategory = "HighAvailability",
 *         DbInstanceClass = "gpdb.group.segsdx1",
 *         DbInstanceMode = "StorageElastic",
 *         Description = name,
 *         Engine = "gpdb",
 *         EngineVersion = "6.0",
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Ids[0]),
 *         InstanceNetworkType = "VPC",
 *         InstanceSpec = "2C16G",
 *         PaymentType = "PayAsYouGo",
 *         SegStorageType = "cloud_essd",
 *         SegNodeNum = 4,
 *         StorageSize = 50,
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         IpWhitelists = new[]
 *         {
 *             new AliCloud.Gpdb.Inputs.InstanceIpWhitelistArgs
 *             {
 *                 SecurityIpList = "127.0.0.1",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := gpdb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(defaultGetZones.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gpdb.NewInstance(ctx, "default", &gpdb.InstanceArgs{
 * 			DbInstanceCategory:  pulumi.String("HighAvailability"),
 * 			DbInstanceClass:     pulumi.String("gpdb.group.segsdx1"),
 * 			DbInstanceMode:      pulumi.String("StorageElastic"),
 * 			Description:         pulumi.String(name),
 * 			Engine:              pulumi.String("gpdb"),
 * 			EngineVersion:       pulumi.String("6.0"),
 * 			ZoneId:              pulumi.String(defaultGetZones.Ids[0]),
 * 			InstanceNetworkType: pulumi.String("VPC"),
 * 			InstanceSpec:        pulumi.String("2C16G"),
 * 			PaymentType:         pulumi.String("PayAsYouGo"),
 * 			SegStorageType:      pulumi.String("cloud_essd"),
 * 			SegNodeNum:          pulumi.Int(4),
 * 			StorageSize:         pulumi.Int(50),
 * 			VpcId:               pulumi.String(defaultGetNetworks.Ids[0]),
 * 			VswitchId:           pulumi.String(defaultGetSwitches.Ids[0]),
 * 			IpWhitelists: gpdb.InstanceIpWhitelistArray{
 * 				&gpdb.InstanceIpWhitelistArgs{
 * 					SecurityIpList: pulumi.String("127.0.0.1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.gpdb.GpdbFunctions;
 * import com.pulumi.alicloud.gpdb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.gpdb.Instance;
 * import com.pulumi.alicloud.gpdb.InstanceArgs;
 * import com.pulumi.alicloud.gpdb.inputs.InstanceIpWhitelistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetZones = GpdbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.ids()[0]))
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .dbInstanceCategory("HighAvailability")
 *             .dbInstanceClass("gpdb.group.segsdx1")
 *             .dbInstanceMode("StorageElastic")
 *             .description(name)
 *             .engine("gpdb")
 *             .engineVersion("6.0")
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.ids()[0]))
 *             .instanceNetworkType("VPC")
 *             .instanceSpec("2C16G")
 *             .paymentType("PayAsYouGo")
 *             .segStorageType("cloud_essd")
 *             .segNodeNum(4)
 *             .storageSize(50)
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .ipWhitelists(InstanceIpWhitelistArgs.builder()
 *                 .securityIpList("127.0.0.1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:gpdb:Instance
 *     name: default
 *     properties:
 *       dbInstanceCategory: HighAvailability
 *       dbInstanceClass: gpdb.group.segsdx1
 *       dbInstanceMode: StorageElastic
 *       description: ${name}
 *       engine: gpdb
 *       engineVersion: '6.0'
 *       zoneId: ${defaultGetZones.ids[0]}
 *       instanceNetworkType: VPC
 *       instanceSpec: 2C16G
 *       paymentType: PayAsYouGo
 *       segStorageType: cloud_essd
 *       segNodeNum: 4
 *       storageSize: 50
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       ipWhitelists:
 *         - securityIpList: 127.0.0.1
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:gpdb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${defaultGetZones.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * AnalyticDB for PostgreSQL can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.gpdb.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Field `availability_zone` has been deprecated from provider version 1.187.0. New field `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from version 1.187.0. Use 'zone_id' instead.
  """,
    )
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.196.0) The connection string of the instance.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * Whether to load the sample dataset after the instance is created. Valid values: `true`, `false`.
     */
    public val createSampleData: Output<Boolean>
        get() = javaResource.createSampleData().applyValue({ args0 -> args0 })

    /**
     * The db instance category. Valid values: `Basic`, `HighAvailability`.
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    public val dbInstanceCategory: Output<String>
        get() = javaResource.dbInstanceCategory().applyValue({ args0 -> args0 })

    /**
     * The db instance class. see [Instance specifications](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/instance-types).
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    public val dbInstanceClass: Output<String>?
        get() = javaResource.dbInstanceClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The db instance mode. Valid values: `StorageElastic`, `Serverless`, `Classic`.
     */
    public val dbInstanceMode: Output<String>
        get() = javaResource.dbInstanceMode().applyValue({ args0 -> args0 })

    /**
     * The description of the instance.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the encryption key.
     * > **NOTE:** If `encryption_type` is set to `CloudDisk`, you must specify an encryption key that resides in the same region as the cloud disk that is specified by EncryptionType. Otherwise, leave this parameter empty.
     */
    public val encryptionKey: Output<String>?
        get() = javaResource.encryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The encryption type. Valid values: `CloudDisk`.
     * > **NOTE:** Disk encryption cannot be disabled after it is enabled.
     */
    public val encryptionType: Output<String>?
        get() = javaResource.encryptionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The database engine used by the instance. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/api-gpdb-2016-05-03-createdbinstance) `EngineVersion`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The version of the database engine used by the instance.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Field `instance_charge_type` has been deprecated from provider version 1.187.0. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Field `instance_charge_type` has been deprecated from version 1.187.0. Use `payment_type` instead.
  """,
    )
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * The number of nodes. Valid values: `2`, `4`, `8`, `12`, `16`, `24`, `32`, `64`, `96`, `128`.
     */
    public val instanceGroupCount: Output<Int>?
        get() = javaResource.instanceGroupCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The network type of the instance. Valid values: `VPC`.
     */
    public val instanceNetworkType: Output<String>
        get() = javaResource.instanceNetworkType().applyValue({ args0 -> args0 })

    /**
     * The specification of segment nodes.
     * * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
     * * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
     * * When `db_instance_category` is `Serverless`, Valid values: `4C16G`, `8C32G`.
     * > **NOTE:** This parameter must be passed to create a storage elastic mode instance and a serverless version instance.
     */
    public val instanceSpec: Output<String>?
        get() = javaResource.instanceSpec().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ip whitelist. See `ip_whitelist` below.
     * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
     */
    public val ipWhitelists: Output<List<InstanceIpWhitelist>>
        get() = javaResource.ipWhitelists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The end time of the maintenance window for the instance. in the format of HH:mmZ (UTC time), for example 03:00Z. start time should be later than end time.
     */
    public val maintainEndTime: Output<String>
        get() = javaResource.maintainEndTime().applyValue({ args0 -> args0 })

    /**
     * The start time of the maintenance window for the instance. in the format of HH:mmZ (UTC time), for example 02:00Z.
     */
    public val maintainStartTime: Output<String>
        get() = javaResource.maintainStartTime().applyValue({ args0 -> args0 })

    /**
     * The amount of coordinator node resources. Valid values: `2`, `4`, `8`, `16`, `32`.
     */
    public val masterCu: Output<Int>
        get() = javaResource.masterCu().applyValue({ args0 -> args0 })

    /**
     * The number of Master nodes. **NOTE:** Field `master_node_num` has been deprecated from provider version 1.213.0.
     */
    @Deprecated(
        message = """
  Field `master_node_num` has been deprecated from provider version 1.213.0.
  """,
    )
    public val masterNodeNum: Output<Int>?
        get() = javaResource.masterNodeNum().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing method of the instance. Valid values: `Subscription`, `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy the resource, in month. required when `payment_type` is `Subscription`. Valid values: `Year`, `Month`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (Available since v1.196.0) The connection port of the instance.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The private ip address. **NOTE:** Field `private_ip_address` has been deprecated from provider version 1.213.0.
     */
    @Deprecated(
        message = """
  Field `private_ip_address` has been deprecated from provider version 1.213.0.
  """,
    )
    public val privateIpAddress: Output<String>?
        get() = javaResource.privateIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the enterprise resource group to which the instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Resource management mode. Valid values: `resourceGroup`, `resourceQueue`.
     */
    public val resourceManagementMode: Output<String>
        get() = javaResource.resourceManagementMode().applyValue({ args0 -> args0 })

    /**
     * Field `security_ip_list` has been deprecated from provider version 1.187.0. New field `ip_whitelist` instead.
     */
    @Deprecated(
        message = """
  Field 'security_ip_list' has been deprecated from version 1.187.0. Use 'ip_whitelist' instead.
  """,
    )
    public val securityIpLists: Output<List<String>>?
        get() = javaResource.securityIpLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Calculate the number of nodes. Valid values: `2` to `512`. The value range of the high-availability version of the storage elastic mode is `4` to `512`, and the value must be a multiple of `4`. The value range of the basic version of the storage elastic mode is `2` to `512`, and the value must be a multiple of `2`. The-Serverless version has a value range of `2` to `512`. The value must be a multiple of `2`.
     * > **NOTE:** This parameter must be passed in to create a storage elastic mode instance and a Serverless version instance. During the public beta of the Serverless version (from 0101, 2022 to 0131, 2022), a maximum of 12 compute nodes can be created.
     */
    public val segNodeNum: Output<Int>
        get() = javaResource.segNodeNum().applyValue({ args0 -> args0 })

    /**
     * The seg storage type. Valid values: `cloud_essd`, `cloud_efficiency`.
     * > **NOTE:** This parameter must be passed in to create a storage elastic mode instance. Storage Elastic Mode Basic Edition instances only support ESSD cloud disks.
     */
    public val segStorageType: Output<String>?
        get() = javaResource.segStorageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable or disable SSL. Valid values: `0` and `1`.
     */
    public val sslEnabled: Output<Int>
        get() = javaResource.sslEnabled().applyValue({ args0 -> args0 })

    /**
     * The status of the instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The storage capacity. Unit: GB. Valid values: `50` to `4000`.
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    public val storageSize: Output<Int>
        get() = javaResource.storageSize().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The used time. When the parameter `period` is `Year`, the `used_time` value is `1` to `3`. When the parameter `period` is `Month`, the `used_time` value is `1` to `9`.
     */
    public val usedTime: Output<String>?
        get() = javaResource.usedTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to enable vector engine optimization. Default value: `disabled`. Valid values: `enabled` and `disabled`.
     */
    public val vectorConfigurationStatus: Output<String>
        get() = javaResource.vectorConfigurationStatus().applyValue({ args0 -> args0 })

    /**
     * The vpc ID of the resource.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The vswitch id.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The zone ID of the instance.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.gpdb.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.gpdb.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
