@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.alicloud.gpdb.InstanceArgs.builder
import com.pulumi.alicloud.gpdb.kotlin.inputs.InstanceIpWhitelistArgs
import com.pulumi.alicloud.gpdb.kotlin.inputs.InstanceIpWhitelistArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AnalyticDB for PostgreSQL instance resource supports replica set instances only. the AnalyticDB for PostgreSQL provides stable, reliable, and automatic scalable database services.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/api-gpdb-2016-05-03-createdbinstance)
 * > **NOTE:** Available since v1.47.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetZones = alicloud.gpdb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, defaultGetZones])&#46;then(([defaultGetNetworks, defaultGetZones]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: defaultGetZones.ids?.[0],
 * }));
 * const defaultInstance = new alicloud.gpdb.Instance("default", {
 *     dbInstanceCategory: "HighAvailability",
 *     dbInstanceClass: "gpdb.group.segsdx1",
 *     dbInstanceMode: "StorageElastic",
 *     description: name,
 *     engine: "gpdb",
 *     engineVersion: "6.0",
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.ids?.[0]),
 *     instanceNetworkType: "VPC",
 *     instanceSpec: "2C16G",
 *     paymentType: "PayAsYouGo",
 *     segStorageType: "cloud_essd",
 *     segNodeNum: 4,
 *     storageSize: 50,
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     ipWhitelists: [{
 *         securityIpList: "127.0.0.1",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_zones = alicloud.gpdb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default_get_zones.ids[0])
 * default_instance = alicloud.gpdb.Instance("default",
 *     db_instance_category="HighAvailability",
 *     db_instance_class="gpdb.group.segsdx1",
 *     db_instance_mode="StorageElastic",
 *     description=name,
 *     engine="gpdb",
 *     engine_version="6.0",
 *     zone_id=default_get_zones.ids[0],
 *     instance_network_type="VPC",
 *     instance_spec="2C16G",
 *     payment_type="PayAsYouGo",
 *     seg_storage_type="cloud_essd",
 *     seg_node_num=4,
 *     storage_size=50,
 *     vpc_id=default_get_networks.ids[0],
 *     vswitch_id=default_get_switches.ids[0],
 *     ip_whitelists=[{
 *         "security_ip_list": "127.0.0.1",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetZones = AliCloud.Gpdb.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var defaultInstance = new AliCloud.Gpdb.Instance("default", new()
 *     {
 *         DbInstanceCategory = "HighAvailability",
 *         DbInstanceClass = "gpdb.group.segsdx1",
 *         DbInstanceMode = "StorageElastic",
 *         Description = name,
 *         Engine = "gpdb",
 *         EngineVersion = "6.0",
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Ids[0]),
 *         InstanceNetworkType = "VPC",
 *         InstanceSpec = "2C16G",
 *         PaymentType = "PayAsYouGo",
 *         SegStorageType = "cloud_essd",
 *         SegNodeNum = 4,
 *         StorageSize = 50,
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         IpWhitelists = new[]
 *         {
 *             new AliCloud.Gpdb.Inputs.InstanceIpWhitelistArgs
 *             {
 *                 SecurityIpList = "127.0.0.1",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := gpdb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(defaultGetZones.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gpdb.NewInstance(ctx, "default", &gpdb.InstanceArgs{
 * 			DbInstanceCategory:  pulumi.String("HighAvailability"),
 * 			DbInstanceClass:     pulumi.String("gpdb.group.segsdx1"),
 * 			DbInstanceMode:      pulumi.String("StorageElastic"),
 * 			Description:         pulumi.String(name),
 * 			Engine:              pulumi.String("gpdb"),
 * 			EngineVersion:       pulumi.String("6.0"),
 * 			ZoneId:              pulumi.String(defaultGetZones.Ids[0]),
 * 			InstanceNetworkType: pulumi.String("VPC"),
 * 			InstanceSpec:        pulumi.String("2C16G"),
 * 			PaymentType:         pulumi.String("PayAsYouGo"),
 * 			SegStorageType:      pulumi.String("cloud_essd"),
 * 			SegNodeNum:          pulumi.Int(4),
 * 			StorageSize:         pulumi.Int(50),
 * 			VpcId:               pulumi.String(defaultGetNetworks.Ids[0]),
 * 			VswitchId:           pulumi.String(defaultGetSwitches.Ids[0]),
 * 			IpWhitelists: gpdb.InstanceIpWhitelistArray{
 * 				&gpdb.InstanceIpWhitelistArgs{
 * 					SecurityIpList: pulumi.String("127.0.0.1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.gpdb.GpdbFunctions;
 * import com.pulumi.alicloud.gpdb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.gpdb.Instance;
 * import com.pulumi.alicloud.gpdb.InstanceArgs;
 * import com.pulumi.alicloud.gpdb.inputs.InstanceIpWhitelistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetZones = GpdbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.ids()[0]))
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .dbInstanceCategory("HighAvailability")
 *             .dbInstanceClass("gpdb.group.segsdx1")
 *             .dbInstanceMode("StorageElastic")
 *             .description(name)
 *             .engine("gpdb")
 *             .engineVersion("6.0")
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.ids()[0]))
 *             .instanceNetworkType("VPC")
 *             .instanceSpec("2C16G")
 *             .paymentType("PayAsYouGo")
 *             .segStorageType("cloud_essd")
 *             .segNodeNum(4)
 *             .storageSize(50)
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .ipWhitelists(InstanceIpWhitelistArgs.builder()
 *                 .securityIpList("127.0.0.1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:gpdb:Instance
 *     name: default
 *     properties:
 *       dbInstanceCategory: HighAvailability
 *       dbInstanceClass: gpdb.group.segsdx1
 *       dbInstanceMode: StorageElastic
 *       description: ${name}
 *       engine: gpdb
 *       engineVersion: '6.0'
 *       zoneId: ${defaultGetZones.ids[0]}
 *       instanceNetworkType: VPC
 *       instanceSpec: 2C16G
 *       paymentType: PayAsYouGo
 *       segStorageType: cloud_essd
 *       segNodeNum: 4
 *       storageSize: 50
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       ipWhitelists:
 *         - securityIpList: 127.0.0.1
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:gpdb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${defaultGetZones.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * AnalyticDB for PostgreSQL can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/instance:Instance example <id>
 * ```
 * @property availabilityZone Field `availability_zone` has been deprecated from provider version 1.187.0. New field `zone_id` instead.
 * @property createSampleData Whether to load the sample dataset after the instance is created. Valid values: `true`, `false`.
 * @property dbInstanceCategory The db instance category. Valid values: `Basic`, `HighAvailability`.
 * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
 * @property dbInstanceClass The db instance class. see [Instance specifications](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/instance-types).
 * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
 * @property dbInstanceMode The db instance mode. Valid values: `StorageElastic`, `Serverless`, `Classic`.
 * @property description The description of the instance.
 * @property encryptionKey The ID of the encryption key.
 * > **NOTE:** If `encryption_type` is set to `CloudDisk`, you must specify an encryption key that resides in the same region as the cloud disk that is specified by EncryptionType. Otherwise, leave this parameter empty.
 * @property encryptionType The encryption type. Valid values: `CloudDisk`.
 * > **NOTE:** Disk encryption cannot be disabled after it is enabled.
 * @property engine The database engine used by the instance. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/api-gpdb-2016-05-03-createdbinstance) `EngineVersion`.
 * @property engineVersion The version of the database engine used by the instance.
 * @property instanceChargeType Field `instance_charge_type` has been deprecated from provider version 1.187.0. New field `payment_type` instead.
 * @property instanceGroupCount The number of nodes. Valid values: `2`, `4`, `8`, `12`, `16`, `24`, `32`, `64`, `96`, `128`.
 * @property instanceNetworkType The network type of the instance. Valid values: `VPC`.
 * @property instanceSpec The specification of segment nodes.
 * * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
 * * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
 * * When `db_instance_category` is `Serverless`, Valid values: `4C16G`, `8C32G`.
 * > **NOTE:** This parameter must be passed to create a storage elastic mode instance and a serverless version instance.
 * @property ipWhitelists The ip whitelist. See `ip_whitelist` below.
 * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
 * @property maintainEndTime The end time of the maintenance window for the instance. in the format of HH:mmZ (UTC time), for example 03:00Z. start time should be later than end time.
 * @property maintainStartTime The start time of the maintenance window for the instance. in the format of HH:mmZ (UTC time), for example 02:00Z.
 * @property masterCu The amount of coordinator node resources. Valid values: `2`, `4`, `8`, `16`, `32`.
 * @property masterNodeNum The number of Master nodes. **NOTE:** Field `master_node_num` has been deprecated from provider version 1.213.0.
 * @property paymentType The billing method of the instance. Valid values: `Subscription`, `PayAsYouGo`.
 * @property period The duration that you will buy the resource, in month. required when `payment_type` is `Subscription`. Valid values: `Year`, `Month`.
 * @property privateIpAddress The private ip address. **NOTE:** Field `private_ip_address` has been deprecated from provider version 1.213.0.
 * @property resourceGroupId The ID of the enterprise resource group to which the instance belongs.
 * @property resourceManagementMode Resource management mode. Valid values: `resourceGroup`, `resourceQueue`.
 * @property securityIpLists Field `security_ip_list` has been deprecated from provider version 1.187.0. New field `ip_whitelist` instead.
 * @property segNodeNum Calculate the number of nodes. Valid values: `2` to `512`. The value range of the high-availability version of the storage elastic mode is `4` to `512`, and the value must be a multiple of `4`. The value range of the basic version of the storage elastic mode is `2` to `512`, and the value must be a multiple of `2`. The-Serverless version has a value range of `2` to `512`. The value must be a multiple of `2`.
 * > **NOTE:** This parameter must be passed in to create a storage elastic mode instance and a Serverless version instance. During the public beta of the Serverless version (from 0101, 2022 to 0131, 2022), a maximum of 12 compute nodes can be created.
 * @property segStorageType The seg storage type. Valid values: `cloud_essd`, `cloud_efficiency`.
 * > **NOTE:** This parameter must be passed in to create a storage elastic mode instance. Storage Elastic Mode Basic Edition instances only support ESSD cloud disks.
 * @property sslEnabled Enable or disable SSL. Valid values: `0` and `1`.
 * @property storageSize The storage capacity. Unit: GB. Valid values: `50` to `4000`.
 * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
 * @property tags A mapping of tags to assign to the resource.
 * @property usedTime The used time. When the parameter `period` is `Year`, the `used_time` value is `1` to `3`. When the parameter `period` is `Month`, the `used_time` value is `1` to `9`.
 * @property vectorConfigurationStatus Specifies whether to enable vector engine optimization. Default value: `disabled`. Valid values: `enabled` and `disabled`.
 * @property vpcId The vpc ID of the resource.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID of the instance.
 */
public data class InstanceArgs(
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from version 1.187.0. Use 'zone_id' instead.
  """,
    )
    public val availabilityZone: Output<String>? = null,
    public val createSampleData: Output<Boolean>? = null,
    public val dbInstanceCategory: Output<String>? = null,
    public val dbInstanceClass: Output<String>? = null,
    public val dbInstanceMode: Output<String>? = null,
    public val description: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val encryptionType: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    @Deprecated(
        message = """
  Field `instance_charge_type` has been deprecated from version 1.187.0. Use `payment_type` instead.
  """,
    )
    public val instanceChargeType: Output<String>? = null,
    public val instanceGroupCount: Output<Int>? = null,
    public val instanceNetworkType: Output<String>? = null,
    public val instanceSpec: Output<String>? = null,
    public val ipWhitelists: Output<List<InstanceIpWhitelistArgs>>? = null,
    public val maintainEndTime: Output<String>? = null,
    public val maintainStartTime: Output<String>? = null,
    public val masterCu: Output<Int>? = null,
    @Deprecated(
        message = """
  Field `master_node_num` has been deprecated from provider version 1.213.0.
  """,
    )
    public val masterNodeNum: Output<Int>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    @Deprecated(
        message = """
  Field `private_ip_address` has been deprecated from provider version 1.213.0.
  """,
    )
    public val privateIpAddress: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val resourceManagementMode: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'security_ip_list' has been deprecated from version 1.187.0. Use 'ip_whitelist' instead.
  """,
    )
    public val securityIpLists: Output<List<String>>? = null,
    public val segNodeNum: Output<Int>? = null,
    public val segStorageType: Output<String>? = null,
    public val sslEnabled: Output<Int>? = null,
    public val storageSize: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val usedTime: Output<String>? = null,
    public val vectorConfigurationStatus: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.InstanceArgs =
        com.pulumi.alicloud.gpdb.InstanceArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .createSampleData(createSampleData?.applyValue({ args0 -> args0 }))
            .dbInstanceCategory(dbInstanceCategory?.applyValue({ args0 -> args0 }))
            .dbInstanceClass(dbInstanceClass?.applyValue({ args0 -> args0 }))
            .dbInstanceMode(dbInstanceMode?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .encryptionType(encryptionType?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .instanceGroupCount(instanceGroupCount?.applyValue({ args0 -> args0 }))
            .instanceNetworkType(instanceNetworkType?.applyValue({ args0 -> args0 }))
            .instanceSpec(instanceSpec?.applyValue({ args0 -> args0 }))
            .ipWhitelists(
                ipWhitelists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .maintainEndTime(maintainEndTime?.applyValue({ args0 -> args0 }))
            .maintainStartTime(maintainStartTime?.applyValue({ args0 -> args0 }))
            .masterCu(masterCu?.applyValue({ args0 -> args0 }))
            .masterNodeNum(masterNodeNum?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .resourceManagementMode(resourceManagementMode?.applyValue({ args0 -> args0 }))
            .securityIpLists(securityIpLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .segNodeNum(segNodeNum?.applyValue({ args0 -> args0 }))
            .segStorageType(segStorageType?.applyValue({ args0 -> args0 }))
            .sslEnabled(sslEnabled?.applyValue({ args0 -> args0 }))
            .storageSize(storageSize?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .usedTime(usedTime?.applyValue({ args0 -> args0 }))
            .vectorConfigurationStatus(vectorConfigurationStatus?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var createSampleData: Output<Boolean>? = null

    private var dbInstanceCategory: Output<String>? = null

    private var dbInstanceClass: Output<String>? = null

    private var dbInstanceMode: Output<String>? = null

    private var description: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var encryptionType: Output<String>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var instanceGroupCount: Output<Int>? = null

    private var instanceNetworkType: Output<String>? = null

    private var instanceSpec: Output<String>? = null

    private var ipWhitelists: Output<List<InstanceIpWhitelistArgs>>? = null

    private var maintainEndTime: Output<String>? = null

    private var maintainStartTime: Output<String>? = null

    private var masterCu: Output<Int>? = null

    private var masterNodeNum: Output<Int>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var resourceManagementMode: Output<String>? = null

    private var securityIpLists: Output<List<String>>? = null

    private var segNodeNum: Output<Int>? = null

    private var segStorageType: Output<String>? = null

    private var sslEnabled: Output<Int>? = null

    private var storageSize: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var usedTime: Output<String>? = null

    private var vectorConfigurationStatus: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Field `availability_zone` has been deprecated from provider version 1.187.0. New field `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from version 1.187.0. Use 'zone_id' instead.
  """,
    )
    @JvmName("ranuifyaybgojyyj")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Whether to load the sample dataset after the instance is created. Valid values: `true`, `false`.
     */
    @JvmName("niftldgykdwgtaop")
    public suspend fun createSampleData(`value`: Output<Boolean>) {
        this.createSampleData = value
    }

    /**
     * @param value The db instance category. Valid values: `Basic`, `HighAvailability`.
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    @JvmName("qbixhndxocujilbk")
    public suspend fun dbInstanceCategory(`value`: Output<String>) {
        this.dbInstanceCategory = value
    }

    /**
     * @param value The db instance class. see [Instance specifications](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/instance-types).
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    @JvmName("dqonjkaxfrhsfvmy")
    public suspend fun dbInstanceClass(`value`: Output<String>) {
        this.dbInstanceClass = value
    }

    /**
     * @param value The db instance mode. Valid values: `StorageElastic`, `Serverless`, `Classic`.
     */
    @JvmName("anytgjyrvifckjhx")
    public suspend fun dbInstanceMode(`value`: Output<String>) {
        this.dbInstanceMode = value
    }

    /**
     * @param value The description of the instance.
     */
    @JvmName("sydwwbxanstpiqlq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the encryption key.
     * > **NOTE:** If `encryption_type` is set to `CloudDisk`, you must specify an encryption key that resides in the same region as the cloud disk that is specified by EncryptionType. Otherwise, leave this parameter empty.
     */
    @JvmName("rvpxkbhtwhbnvyhy")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value The encryption type. Valid values: `CloudDisk`.
     * > **NOTE:** Disk encryption cannot be disabled after it is enabled.
     */
    @JvmName("ndncgylyktgykqoe")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value The database engine used by the instance. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/api-gpdb-2016-05-03-createdbinstance) `EngineVersion`.
     */
    @JvmName("xaqdusydoxamdohl")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The version of the database engine used by the instance.
     */
    @JvmName("itvaancdgdurpnbs")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Field `instance_charge_type` has been deprecated from provider version 1.187.0. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Field `instance_charge_type` has been deprecated from version 1.187.0. Use `payment_type` instead.
  """,
    )
    @JvmName("unvknkdcgenlafns")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value The number of nodes. Valid values: `2`, `4`, `8`, `12`, `16`, `24`, `32`, `64`, `96`, `128`.
     */
    @JvmName("fsacblkevipeimus")
    public suspend fun instanceGroupCount(`value`: Output<Int>) {
        this.instanceGroupCount = value
    }

    /**
     * @param value The network type of the instance. Valid values: `VPC`.
     */
    @JvmName("wmvpcewvohjphsal")
    public suspend fun instanceNetworkType(`value`: Output<String>) {
        this.instanceNetworkType = value
    }

    /**
     * @param value The specification of segment nodes.
     * * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
     * * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
     * * When `db_instance_category` is `Serverless`, Valid values: `4C16G`, `8C32G`.
     * > **NOTE:** This parameter must be passed to create a storage elastic mode instance and a serverless version instance.
     */
    @JvmName("afxxvqlwupwcvynj")
    public suspend fun instanceSpec(`value`: Output<String>) {
        this.instanceSpec = value
    }

    /**
     * @param value The ip whitelist. See `ip_whitelist` below.
     * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
     */
    @JvmName("pebiqdymeknobcxi")
    public suspend fun ipWhitelists(`value`: Output<List<InstanceIpWhitelistArgs>>) {
        this.ipWhitelists = value
    }

    @JvmName("brrncuontokjqxaq")
    public suspend fun ipWhitelists(vararg values: Output<InstanceIpWhitelistArgs>) {
        this.ipWhitelists = Output.all(values.asList())
    }

    /**
     * @param values The ip whitelist. See `ip_whitelist` below.
     * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
     */
    @JvmName("aqhcnrvarkmdmqbn")
    public suspend fun ipWhitelists(values: List<Output<InstanceIpWhitelistArgs>>) {
        this.ipWhitelists = Output.all(values)
    }

    /**
     * @param value The end time of the maintenance window for the instance. in the format of HH:mmZ (UTC time), for example 03:00Z. start time should be later than end time.
     */
    @JvmName("dcuxqltuuudgselw")
    public suspend fun maintainEndTime(`value`: Output<String>) {
        this.maintainEndTime = value
    }

    /**
     * @param value The start time of the maintenance window for the instance. in the format of HH:mmZ (UTC time), for example 02:00Z.
     */
    @JvmName("gvutbpjieparfuyu")
    public suspend fun maintainStartTime(`value`: Output<String>) {
        this.maintainStartTime = value
    }

    /**
     * @param value The amount of coordinator node resources. Valid values: `2`, `4`, `8`, `16`, `32`.
     */
    @JvmName("lvqcslovniqwtxft")
    public suspend fun masterCu(`value`: Output<Int>) {
        this.masterCu = value
    }

    /**
     * @param value The number of Master nodes. **NOTE:** Field `master_node_num` has been deprecated from provider version 1.213.0.
     */
    @Deprecated(
        message = """
  Field `master_node_num` has been deprecated from provider version 1.213.0.
  """,
    )
    @JvmName("oheyivuhwykpufxp")
    public suspend fun masterNodeNum(`value`: Output<Int>) {
        this.masterNodeNum = value
    }

    /**
     * @param value The billing method of the instance. Valid values: `Subscription`, `PayAsYouGo`.
     */
    @JvmName("blmobluexbudjkhj")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy the resource, in month. required when `payment_type` is `Subscription`. Valid values: `Year`, `Month`.
     */
    @JvmName("tstsyyafimtqqplk")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The private ip address. **NOTE:** Field `private_ip_address` has been deprecated from provider version 1.213.0.
     */
    @Deprecated(
        message = """
  Field `private_ip_address` has been deprecated from provider version 1.213.0.
  """,
    )
    @JvmName("wqmoorncmddaoapr")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The ID of the enterprise resource group to which the instance belongs.
     */
    @JvmName("wjbbibguphcuprso")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Resource management mode. Valid values: `resourceGroup`, `resourceQueue`.
     */
    @JvmName("dluyiisysjpxiwud")
    public suspend fun resourceManagementMode(`value`: Output<String>) {
        this.resourceManagementMode = value
    }

    /**
     * @param value Field `security_ip_list` has been deprecated from provider version 1.187.0. New field `ip_whitelist` instead.
     */
    @Deprecated(
        message = """
  Field 'security_ip_list' has been deprecated from version 1.187.0. Use 'ip_whitelist' instead.
  """,
    )
    @JvmName("bowcfjkhyqpsjgxf")
    public suspend fun securityIpLists(`value`: Output<List<String>>) {
        this.securityIpLists = value
    }

    @JvmName("xxhpfspivtxxsayp")
    public suspend fun securityIpLists(vararg values: Output<String>) {
        this.securityIpLists = Output.all(values.asList())
    }

    /**
     * @param values Field `security_ip_list` has been deprecated from provider version 1.187.0. New field `ip_whitelist` instead.
     */
    @Deprecated(
        message = """
  Field 'security_ip_list' has been deprecated from version 1.187.0. Use 'ip_whitelist' instead.
  """,
    )
    @JvmName("kruryhyvvxulihbu")
    public suspend fun securityIpLists(values: List<Output<String>>) {
        this.securityIpLists = Output.all(values)
    }

    /**
     * @param value Calculate the number of nodes. Valid values: `2` to `512`. The value range of the high-availability version of the storage elastic mode is `4` to `512`, and the value must be a multiple of `4`. The value range of the basic version of the storage elastic mode is `2` to `512`, and the value must be a multiple of `2`. The-Serverless version has a value range of `2` to `512`. The value must be a multiple of `2`.
     * > **NOTE:** This parameter must be passed in to create a storage elastic mode instance and a Serverless version instance. During the public beta of the Serverless version (from 0101, 2022 to 0131, 2022), a maximum of 12 compute nodes can be created.
     */
    @JvmName("dfygdgwmaitpunho")
    public suspend fun segNodeNum(`value`: Output<Int>) {
        this.segNodeNum = value
    }

    /**
     * @param value The seg storage type. Valid values: `cloud_essd`, `cloud_efficiency`.
     * > **NOTE:** This parameter must be passed in to create a storage elastic mode instance. Storage Elastic Mode Basic Edition instances only support ESSD cloud disks.
     */
    @JvmName("ikjgkcdpdooetimw")
    public suspend fun segStorageType(`value`: Output<String>) {
        this.segStorageType = value
    }

    /**
     * @param value Enable or disable SSL. Valid values: `0` and `1`.
     */
    @JvmName("awrvsrkdgqhgfimy")
    public suspend fun sslEnabled(`value`: Output<Int>) {
        this.sslEnabled = value
    }

    /**
     * @param value The storage capacity. Unit: GB. Valid values: `50` to `4000`.
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    @JvmName("lbyaylorcbqodlox")
    public suspend fun storageSize(`value`: Output<Int>) {
        this.storageSize = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("uskgdruofncescit")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The used time. When the parameter `period` is `Year`, the `used_time` value is `1` to `3`. When the parameter `period` is `Month`, the `used_time` value is `1` to `9`.
     */
    @JvmName("kavferscwbmnfrpq")
    public suspend fun usedTime(`value`: Output<String>) {
        this.usedTime = value
    }

    /**
     * @param value Specifies whether to enable vector engine optimization. Default value: `disabled`. Valid values: `enabled` and `disabled`.
     */
    @JvmName("bgsphviqwmqmyeqv")
    public suspend fun vectorConfigurationStatus(`value`: Output<String>) {
        this.vectorConfigurationStatus = value
    }

    /**
     * @param value The vpc ID of the resource.
     */
    @JvmName("swjdnbpporgbrkwu")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("uggapeqdofvuhyvq")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("aoxsjjbsukkrbfcs")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Field `availability_zone` has been deprecated from provider version 1.187.0. New field `zone_id` instead.
     */
    @Deprecated(
        message = """
  Field 'availability_zone' has been deprecated from version 1.187.0. Use 'zone_id' instead.
  """,
    )
    @JvmName("wluhpsiuqgloiwji")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Whether to load the sample dataset after the instance is created. Valid values: `true`, `false`.
     */
    @JvmName("lvjdlgfoutebhqyw")
    public suspend fun createSampleData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createSampleData = mapped
    }

    /**
     * @param value The db instance category. Valid values: `Basic`, `HighAvailability`.
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    @JvmName("kwhywodbcuuqayvg")
    public suspend fun dbInstanceCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceCategory = mapped
    }

    /**
     * @param value The db instance class. see [Instance specifications](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/instance-types).
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    @JvmName("bydxnkklcqgtnvof")
    public suspend fun dbInstanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceClass = mapped
    }

    /**
     * @param value The db instance mode. Valid values: `StorageElastic`, `Serverless`, `Classic`.
     */
    @JvmName("lsldmaoyvmgonips")
    public suspend fun dbInstanceMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceMode = mapped
    }

    /**
     * @param value The description of the instance.
     */
    @JvmName("vrpfexmhbnddkdcw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the encryption key.
     * > **NOTE:** If `encryption_type` is set to `CloudDisk`, you must specify an encryption key that resides in the same region as the cloud disk that is specified by EncryptionType. Otherwise, leave this parameter empty.
     */
    @JvmName("jbgmtaengnrtjkwt")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value The encryption type. Valid values: `CloudDisk`.
     * > **NOTE:** Disk encryption cannot be disabled after it is enabled.
     */
    @JvmName("rebaytxhnheqcmmr")
    public suspend fun encryptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value The database engine used by the instance. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/latest/api-gpdb-2016-05-03-createdbinstance) `EngineVersion`.
     */
    @JvmName("ngqbirskaxnwovnx")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The version of the database engine used by the instance.
     */
    @JvmName("ndteroadrtltqnua")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Field `instance_charge_type` has been deprecated from provider version 1.187.0. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Field `instance_charge_type` has been deprecated from version 1.187.0. Use `payment_type` instead.
  """,
    )
    @JvmName("stdjddlswsmhbarc")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The number of nodes. Valid values: `2`, `4`, `8`, `12`, `16`, `24`, `32`, `64`, `96`, `128`.
     */
    @JvmName("nhpomreqwugkwhfp")
    public suspend fun instanceGroupCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceGroupCount = mapped
    }

    /**
     * @param value The network type of the instance. Valid values: `VPC`.
     */
    @JvmName("idwhrribkebtukxg")
    public suspend fun instanceNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceNetworkType = mapped
    }

    /**
     * @param value The specification of segment nodes.
     * * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
     * * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
     * * When `db_instance_category` is `Serverless`, Valid values: `4C16G`, `8C32G`.
     * > **NOTE:** This parameter must be passed to create a storage elastic mode instance and a serverless version instance.
     */
    @JvmName("vrqqkruwwrauxmyf")
    public suspend fun instanceSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceSpec = mapped
    }

    /**
     * @param value The ip whitelist. See `ip_whitelist` below.
     * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
     */
    @JvmName("paabwhrtppabphyd")
    public suspend fun ipWhitelists(`value`: List<InstanceIpWhitelistArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipWhitelists = mapped
    }

    /**
     * @param argument The ip whitelist. See `ip_whitelist` below.
     * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
     */
    @JvmName("rasbxoggywrqlboq")
    public suspend fun ipWhitelists(argument: List<suspend InstanceIpWhitelistArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceIpWhitelistArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipWhitelists = mapped
    }

    /**
     * @param argument The ip whitelist. See `ip_whitelist` below.
     * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
     */
    @JvmName("mcaqdaniocudqpqq")
    public suspend fun ipWhitelists(vararg argument: suspend InstanceIpWhitelistArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceIpWhitelistArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipWhitelists = mapped
    }

    /**
     * @param argument The ip whitelist. See `ip_whitelist` below.
     * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
     */
    @JvmName("kaovbxixqjksgmkv")
    public suspend fun ipWhitelists(argument: suspend InstanceIpWhitelistArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceIpWhitelistArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipWhitelists = mapped
    }

    /**
     * @param values The ip whitelist. See `ip_whitelist` below.
     * Default to creating a whitelist group with the group name "default" and security_ip_list "127.0.0.1".
     */
    @JvmName("wgjohbyuhxwuqueq")
    public suspend fun ipWhitelists(vararg values: InstanceIpWhitelistArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipWhitelists = mapped
    }

    /**
     * @param value The end time of the maintenance window for the instance. in the format of HH:mmZ (UTC time), for example 03:00Z. start time should be later than end time.
     */
    @JvmName("klfpnqongwrdhwii")
    public suspend fun maintainEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainEndTime = mapped
    }

    /**
     * @param value The start time of the maintenance window for the instance. in the format of HH:mmZ (UTC time), for example 02:00Z.
     */
    @JvmName("oxsydggskoiewqgt")
    public suspend fun maintainStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainStartTime = mapped
    }

    /**
     * @param value The amount of coordinator node resources. Valid values: `2`, `4`, `8`, `16`, `32`.
     */
    @JvmName("xqfkpfpqerqtduyt")
    public suspend fun masterCu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterCu = mapped
    }

    /**
     * @param value The number of Master nodes. **NOTE:** Field `master_node_num` has been deprecated from provider version 1.213.0.
     */
    @Deprecated(
        message = """
  Field `master_node_num` has been deprecated from provider version 1.213.0.
  """,
    )
    @JvmName("jqfkqhuqxfyuyleu")
    public suspend fun masterNodeNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterNodeNum = mapped
    }

    /**
     * @param value The billing method of the instance. Valid values: `Subscription`, `PayAsYouGo`.
     */
    @JvmName("notjaondjotpbwxd")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy the resource, in month. required when `payment_type` is `Subscription`. Valid values: `Year`, `Month`.
     */
    @JvmName("asqhgdbkgtcmstpu")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The private ip address. **NOTE:** Field `private_ip_address` has been deprecated from provider version 1.213.0.
     */
    @Deprecated(
        message = """
  Field `private_ip_address` has been deprecated from provider version 1.213.0.
  """,
    )
    @JvmName("yyajjeoklaaifiue")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The ID of the enterprise resource group to which the instance belongs.
     */
    @JvmName("xuxslnokjcwdrggl")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Resource management mode. Valid values: `resourceGroup`, `resourceQueue`.
     */
    @JvmName("uwgabciiotvxtbhs")
    public suspend fun resourceManagementMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceManagementMode = mapped
    }

    /**
     * @param value Field `security_ip_list` has been deprecated from provider version 1.187.0. New field `ip_whitelist` instead.
     */
    @Deprecated(
        message = """
  Field 'security_ip_list' has been deprecated from version 1.187.0. Use 'ip_whitelist' instead.
  """,
    )
    @JvmName("qrosdsbakvkrqtpr")
    public suspend fun securityIpLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpLists = mapped
    }

    /**
     * @param values Field `security_ip_list` has been deprecated from provider version 1.187.0. New field `ip_whitelist` instead.
     */
    @Deprecated(
        message = """
  Field 'security_ip_list' has been deprecated from version 1.187.0. Use 'ip_whitelist' instead.
  """,
    )
    @JvmName("ypwwwftoleryxrlj")
    public suspend fun securityIpLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIpLists = mapped
    }

    /**
     * @param value Calculate the number of nodes. Valid values: `2` to `512`. The value range of the high-availability version of the storage elastic mode is `4` to `512`, and the value must be a multiple of `4`. The value range of the basic version of the storage elastic mode is `2` to `512`, and the value must be a multiple of `2`. The-Serverless version has a value range of `2` to `512`. The value must be a multiple of `2`.
     * > **NOTE:** This parameter must be passed in to create a storage elastic mode instance and a Serverless version instance. During the public beta of the Serverless version (from 0101, 2022 to 0131, 2022), a maximum of 12 compute nodes can be created.
     */
    @JvmName("pxiadsrpoxxrmqrg")
    public suspend fun segNodeNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segNodeNum = mapped
    }

    /**
     * @param value The seg storage type. Valid values: `cloud_essd`, `cloud_efficiency`.
     * > **NOTE:** This parameter must be passed in to create a storage elastic mode instance. Storage Elastic Mode Basic Edition instances only support ESSD cloud disks.
     */
    @JvmName("veaxgyqwhtfwxkjs")
    public suspend fun segStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segStorageType = mapped
    }

    /**
     * @param value Enable or disable SSL. Valid values: `0` and `1`.
     */
    @JvmName("qmppljbfsobmdujc")
    public suspend fun sslEnabled(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslEnabled = mapped
    }

    /**
     * @param value The storage capacity. Unit: GB. Valid values: `50` to `4000`.
     * > **NOTE:** This parameter must be passed in to create a storage reservation mode instance.
     */
    @JvmName("pekiqrosujlfacwp")
    public suspend fun storageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSize = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("gyqbrswyuggstuwd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("qihecnmcioxginig")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The used time. When the parameter `period` is `Year`, the `used_time` value is `1` to `3`. When the parameter `period` is `Month`, the `used_time` value is `1` to `9`.
     */
    @JvmName("mhqwkbqdxnejousv")
    public suspend fun usedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedTime = mapped
    }

    /**
     * @param value Specifies whether to enable vector engine optimization. Default value: `disabled`. Valid values: `enabled` and `disabled`.
     */
    @JvmName("jcrwbyxbbcypluxp")
    public suspend fun vectorConfigurationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vectorConfigurationStatus = mapped
    }

    /**
     * @param value The vpc ID of the resource.
     */
    @JvmName("bvglidbmybawmduv")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("pdvrfcaqgcblwayt")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("tnlmoglmaafyrjos")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        availabilityZone = availabilityZone,
        createSampleData = createSampleData,
        dbInstanceCategory = dbInstanceCategory,
        dbInstanceClass = dbInstanceClass,
        dbInstanceMode = dbInstanceMode,
        description = description,
        encryptionKey = encryptionKey,
        encryptionType = encryptionType,
        engine = engine,
        engineVersion = engineVersion,
        instanceChargeType = instanceChargeType,
        instanceGroupCount = instanceGroupCount,
        instanceNetworkType = instanceNetworkType,
        instanceSpec = instanceSpec,
        ipWhitelists = ipWhitelists,
        maintainEndTime = maintainEndTime,
        maintainStartTime = maintainStartTime,
        masterCu = masterCu,
        masterNodeNum = masterNodeNum,
        paymentType = paymentType,
        period = period,
        privateIpAddress = privateIpAddress,
        resourceGroupId = resourceGroupId,
        resourceManagementMode = resourceManagementMode,
        securityIpLists = securityIpLists,
        segNodeNum = segNodeNum,
        segStorageType = segStorageType,
        sslEnabled = sslEnabled,
        storageSize = storageSize,
        tags = tags,
        usedTime = usedTime,
        vectorConfigurationStatus = vectorConfigurationStatus,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
