@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.inputs

import com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property pause Pause instance plan config. See `pause` below.
 * @property resume Resume instance plan config. See `resume` below.
 * @property scaleIn Scale In instance plan config. See `scale_in` below.
 * @property scaleOut Scale out instance plan config. See `scale_out` below.
 */
public data class DbInstancePlanPlanConfigArgs(
    public val pause: Output<DbInstancePlanPlanConfigPauseArgs>? = null,
    public val resume: Output<DbInstancePlanPlanConfigResumeArgs>? = null,
    public val scaleIn: Output<DbInstancePlanPlanConfigScaleInArgs>? = null,
    public val scaleOut: Output<DbInstancePlanPlanConfigScaleOutArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigArgs =
        com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigArgs.builder()
            .pause(pause?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resume(resume?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scaleIn(scaleIn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scaleOut(scaleOut?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DbInstancePlanPlanConfigArgs].
 */
@PulumiTagMarker
public class DbInstancePlanPlanConfigArgsBuilder internal constructor() {
    private var pause: Output<DbInstancePlanPlanConfigPauseArgs>? = null

    private var resume: Output<DbInstancePlanPlanConfigResumeArgs>? = null

    private var scaleIn: Output<DbInstancePlanPlanConfigScaleInArgs>? = null

    private var scaleOut: Output<DbInstancePlanPlanConfigScaleOutArgs>? = null

    /**
     * @param value Pause instance plan config. See `pause` below.
     */
    @JvmName("udycwpyddcoiyytw")
    public suspend fun pause(`value`: Output<DbInstancePlanPlanConfigPauseArgs>) {
        this.pause = value
    }

    /**
     * @param value Resume instance plan config. See `resume` below.
     */
    @JvmName("bsjnjjbgsjcanmce")
    public suspend fun resume(`value`: Output<DbInstancePlanPlanConfigResumeArgs>) {
        this.resume = value
    }

    /**
     * @param value Scale In instance plan config. See `scale_in` below.
     */
    @JvmName("obpfhlijovnqaekq")
    public suspend fun scaleIn(`value`: Output<DbInstancePlanPlanConfigScaleInArgs>) {
        this.scaleIn = value
    }

    /**
     * @param value Scale out instance plan config. See `scale_out` below.
     */
    @JvmName("latqfddxyxcefqxe")
    public suspend fun scaleOut(`value`: Output<DbInstancePlanPlanConfigScaleOutArgs>) {
        this.scaleOut = value
    }

    /**
     * @param value Pause instance plan config. See `pause` below.
     */
    @JvmName("llwpswpnpbrswefa")
    public suspend fun pause(`value`: DbInstancePlanPlanConfigPauseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pause = mapped
    }

    /**
     * @param argument Pause instance plan config. See `pause` below.
     */
    @JvmName("dursxnrsnytmfmut")
    public suspend fun pause(argument: suspend DbInstancePlanPlanConfigPauseArgsBuilder.() -> Unit) {
        val toBeMapped = DbInstancePlanPlanConfigPauseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pause = mapped
    }

    /**
     * @param value Resume instance plan config. See `resume` below.
     */
    @JvmName("uhrlpkamtdmjxtdv")
    public suspend fun resume(`value`: DbInstancePlanPlanConfigResumeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resume = mapped
    }

    /**
     * @param argument Resume instance plan config. See `resume` below.
     */
    @JvmName("hkyalupaftiggukt")
    public suspend fun resume(argument: suspend DbInstancePlanPlanConfigResumeArgsBuilder.() -> Unit) {
        val toBeMapped = DbInstancePlanPlanConfigResumeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resume = mapped
    }

    /**
     * @param value Scale In instance plan config. See `scale_in` below.
     */
    @JvmName("wptmyyiwlaraypqb")
    public suspend fun scaleIn(`value`: DbInstancePlanPlanConfigScaleInArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleIn = mapped
    }

    /**
     * @param argument Scale In instance plan config. See `scale_in` below.
     */
    @JvmName("jxfythhnjwhyspqd")
    public suspend fun scaleIn(argument: suspend DbInstancePlanPlanConfigScaleInArgsBuilder.() -> Unit) {
        val toBeMapped = DbInstancePlanPlanConfigScaleInArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scaleIn = mapped
    }

    /**
     * @param value Scale out instance plan config. See `scale_out` below.
     */
    @JvmName("ymhxnrabtxpoikoj")
    public suspend fun scaleOut(`value`: DbInstancePlanPlanConfigScaleOutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleOut = mapped
    }

    /**
     * @param argument Scale out instance plan config. See `scale_out` below.
     */
    @JvmName("amqvwtiycwtmmgsu")
    public suspend fun scaleOut(argument: suspend DbInstancePlanPlanConfigScaleOutArgsBuilder.() -> Unit) {
        val toBeMapped = DbInstancePlanPlanConfigScaleOutArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scaleOut = mapped
    }

    internal fun build(): DbInstancePlanPlanConfigArgs = DbInstancePlanPlanConfigArgs(
        pause = pause,
        resume = resume,
        scaleIn = scaleIn,
        scaleOut = scaleOut,
    )
}
