@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.inputs

import com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigPauseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property executeTime The executed time of the Plan.
 * @property planCronTime The Cron Time of the plan.
 */
public data class DbInstancePlanPlanConfigPauseArgs(
    public val executeTime: Output<String>? = null,
    public val planCronTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigPauseArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigPauseArgs =
        com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigPauseArgs.builder()
            .executeTime(executeTime?.applyValue({ args0 -> args0 }))
            .planCronTime(planCronTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstancePlanPlanConfigPauseArgs].
 */
@PulumiTagMarker
public class DbInstancePlanPlanConfigPauseArgsBuilder internal constructor() {
    private var executeTime: Output<String>? = null

    private var planCronTime: Output<String>? = null

    /**
     * @param value The executed time of the Plan.
     */
    @JvmName("evseublpoinmjomd")
    public suspend fun executeTime(`value`: Output<String>) {
        this.executeTime = value
    }

    /**
     * @param value The Cron Time of the plan.
     */
    @JvmName("pbufnubvgbakihnq")
    public suspend fun planCronTime(`value`: Output<String>) {
        this.planCronTime = value
    }

    /**
     * @param value The executed time of the Plan.
     */
    @JvmName("dkwoqalktrnduedc")
    public suspend fun executeTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executeTime = mapped
    }

    /**
     * @param value The Cron Time of the plan.
     */
    @JvmName("lumlxgfednswyvgl")
    public suspend fun planCronTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planCronTime = mapped
    }

    internal fun build(): DbInstancePlanPlanConfigPauseArgs = DbInstancePlanPlanConfigPauseArgs(
        executeTime = executeTime,
        planCronTime = planCronTime,
    )
}
