@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.inputs

import com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigScaleInArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property executeTime The executed time of the Plan.
 * @property planCronTime The Cron Time of the plan.
 * @property segmentNodeNum The segment Node Num of the Plan.
 */
public data class DbInstancePlanPlanConfigScaleInArgs(
    public val executeTime: Output<String>? = null,
    public val planCronTime: Output<String>? = null,
    public val segmentNodeNum: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigScaleInArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigScaleInArgs =
        com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigScaleInArgs.builder()
            .executeTime(executeTime?.applyValue({ args0 -> args0 }))
            .planCronTime(planCronTime?.applyValue({ args0 -> args0 }))
            .segmentNodeNum(segmentNodeNum?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstancePlanPlanConfigScaleInArgs].
 */
@PulumiTagMarker
public class DbInstancePlanPlanConfigScaleInArgsBuilder internal constructor() {
    private var executeTime: Output<String>? = null

    private var planCronTime: Output<String>? = null

    private var segmentNodeNum: Output<String>? = null

    /**
     * @param value The executed time of the Plan.
     */
    @JvmName("rdwanlqqvxhpntdj")
    public suspend fun executeTime(`value`: Output<String>) {
        this.executeTime = value
    }

    /**
     * @param value The Cron Time of the plan.
     */
    @JvmName("apijmyjvihhakxru")
    public suspend fun planCronTime(`value`: Output<String>) {
        this.planCronTime = value
    }

    /**
     * @param value The segment Node Num of the Plan.
     */
    @JvmName("yieboxbjykejaekd")
    public suspend fun segmentNodeNum(`value`: Output<String>) {
        this.segmentNodeNum = value
    }

    /**
     * @param value The executed time of the Plan.
     */
    @JvmName("mfdlyasimtatxare")
    public suspend fun executeTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executeTime = mapped
    }

    /**
     * @param value The Cron Time of the plan.
     */
    @JvmName("vmfuvhfqtvmfukvf")
    public suspend fun planCronTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planCronTime = mapped
    }

    /**
     * @param value The segment Node Num of the Plan.
     */
    @JvmName("gpwwsjclgjwwgwav")
    public suspend fun segmentNodeNum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentNodeNum = mapped
    }

    internal fun build(): DbInstancePlanPlanConfigScaleInArgs = DbInstancePlanPlanConfigScaleInArgs(
        executeTime = executeTime,
        planCronTime = planCronTime,
        segmentNodeNum = segmentNodeNum,
    )
}
