@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.inputs

import com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigScaleOutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property executeTime The executed time of the Plan.
 * @property planCronTime The Cron Time of the plan.
 * @property segmentNodeNum The segment Node Num of the Plan.
 */
public data class DbInstancePlanPlanConfigScaleOutArgs(
    public val executeTime: Output<String>? = null,
    public val planCronTime: Output<String>? = null,
    public val segmentNodeNum: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigScaleOutArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigScaleOutArgs =
        com.pulumi.alicloud.gpdb.inputs.DbInstancePlanPlanConfigScaleOutArgs.builder()
            .executeTime(executeTime?.applyValue({ args0 -> args0 }))
            .planCronTime(planCronTime?.applyValue({ args0 -> args0 }))
            .segmentNodeNum(segmentNodeNum?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstancePlanPlanConfigScaleOutArgs].
 */
@PulumiTagMarker
public class DbInstancePlanPlanConfigScaleOutArgsBuilder internal constructor() {
    private var executeTime: Output<String>? = null

    private var planCronTime: Output<String>? = null

    private var segmentNodeNum: Output<String>? = null

    /**
     * @param value The executed time of the Plan.
     */
    @JvmName("jvlydwphcwqtksxs")
    public suspend fun executeTime(`value`: Output<String>) {
        this.executeTime = value
    }

    /**
     * @param value The Cron Time of the plan.
     */
    @JvmName("mrsfqxfbubhrsuty")
    public suspend fun planCronTime(`value`: Output<String>) {
        this.planCronTime = value
    }

    /**
     * @param value The segment Node Num of the Plan.
     */
    @JvmName("fwuadxucgxebwxlw")
    public suspend fun segmentNodeNum(`value`: Output<String>) {
        this.segmentNodeNum = value
    }

    /**
     * @param value The executed time of the Plan.
     */
    @JvmName("agnuggcxfonnfayl")
    public suspend fun executeTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executeTime = mapped
    }

    /**
     * @param value The Cron Time of the plan.
     */
    @JvmName("cernkgfujbrlhnsd")
    public suspend fun planCronTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planCronTime = mapped
    }

    /**
     * @param value The segment Node Num of the Plan.
     */
    @JvmName("fhaejitgimwutgfg")
    public suspend fun segmentNodeNum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentNodeNum = mapped
    }

    internal fun build(): DbInstancePlanPlanConfigScaleOutArgs = DbInstancePlanPlanConfigScaleOutArgs(
        executeTime = executeTime,
        planCronTime = planCronTime,
        segmentNodeNum = segmentNodeNum,
    )
}
