@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.inputs

import com.pulumi.alicloud.gpdb.inputs.GetDbInstancePlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDbInstancePlans.
 * @property dbInstanceId The ID of the Database instance.
 * @property ids A list of DB Instance Plan IDs.
 * @property nameRegex A regex string to filter results by DB Instance Plan name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property planScheduleType Plan scheduling type. Valid values: `Postpone`, `Regular`.
 * @property planType The type of the Plan. Valid values: `PauseResume`, `Resize`.
 * @property status Planning Status. Valid values: `active`, `cancel`, `deleted`, `finished`.
 */
public data class GetDbInstancePlansPlainArgs(
    public val dbInstanceId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val planScheduleType: String? = null,
    public val planType: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.inputs.GetDbInstancePlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.inputs.GetDbInstancePlansPlainArgs =
        com.pulumi.alicloud.gpdb.inputs.GetDbInstancePlansPlainArgs.builder()
            .dbInstanceId(dbInstanceId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .planScheduleType(planScheduleType?.let({ args0 -> args0 }))
            .planType(planType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDbInstancePlansPlainArgs].
 */
@PulumiTagMarker
public class GetDbInstancePlansPlainArgsBuilder internal constructor() {
    private var dbInstanceId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var planScheduleType: String? = null

    private var planType: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Database instance.
     */
    @JvmName("ubrviyaupwoomdgd")
    public suspend fun dbInstanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceId = mapped
    }

    /**
     * @param value A list of DB Instance Plan IDs.
     */
    @JvmName("ftusmmjoabqwxmto")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of DB Instance Plan IDs.
     */
    @JvmName("itqubydikovcehhn")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by DB Instance Plan name.
     */
    @JvmName("rmxxljukkjlxspcm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pwmfnbdcjnbmoqhr")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Plan scheduling type. Valid values: `Postpone`, `Regular`.
     */
    @JvmName("snjevtbfhpqchopw")
    public suspend fun planScheduleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.planScheduleType = mapped
    }

    /**
     * @param value The type of the Plan. Valid values: `PauseResume`, `Resize`.
     */
    @JvmName("vvhrkblnbtlhwabj")
    public suspend fun planType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.planType = mapped
    }

    /**
     * @param value Planning Status. Valid values: `active`, `cancel`, `deleted`, `finished`.
     */
    @JvmName("tivgfgiivcsjemvo")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDbInstancePlansPlainArgs = GetDbInstancePlansPlainArgs(
        dbInstanceId = dbInstanceId ?: throw PulumiNullFieldException("dbInstanceId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        planScheduleType = planScheduleType,
        planType = planType,
        status = status,
    )
}
