@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.inputs

import com.pulumi.alicloud.gpdb.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property availabilityZone Instance availability zone.
 * @property dbInstanceCategories The db instance categories.
 * @property dbInstanceModes The db instance modes.
 * @property description The description of the instance.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids The ids list of AnalyticDB for PostgreSQL instances.
 * @property instanceNetworkType The network type of the instance.
 * @property nameRegex A regex string to apply to the instance name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the enterprise resource group to which the instance belongs.
 * @property status The status of the instance. Valid values: `Creating`, `DBInstanceClassChanging`, `DBInstanceNetTypeChanging`, `Deleting`, `EngineVersionUpgrading`, `GuardDBInstanceCreating`, `GuardSwitching`, `Importing`, `ImportingFromOtherInstance`, `Rebooting`, `Restoring`, `Running`, `Transfering`, `TransferingToOtherInstance`.
 * @property tags
 * @property vswitchId Used to retrieve instances belong to specified `vswitch` resources.
 */
public data class GetInstancesPlainArgs(
    public val availabilityZone: String? = null,
    public val dbInstanceCategories: String? = null,
    public val dbInstanceModes: String? = null,
    public val description: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val instanceNetworkType: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vswitchId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.gpdb.inputs.GetInstancesPlainArgs.builder()
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .dbInstanceCategories(dbInstanceCategories?.let({ args0 -> args0 }))
            .dbInstanceModes(dbInstanceModes?.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceNetworkType(instanceNetworkType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var availabilityZone: String? = null

    private var dbInstanceCategories: String? = null

    private var dbInstanceModes: String? = null

    private var description: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var instanceNetworkType: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vswitchId: String? = null

    /**
     * @param value Instance availability zone.
     */
    @JvmName("icakqxhmosttkuwk")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value The db instance categories.
     */
    @JvmName("xudoycymxarqsmrv")
    public suspend fun dbInstanceCategories(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceCategories = mapped
    }

    /**
     * @param value The db instance modes.
     */
    @JvmName("ghuayrcoqvyhxbhx")
    public suspend fun dbInstanceModes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceModes = mapped
    }

    /**
     * @param value The description of the instance.
     */
    @JvmName("jysfbdlltxdocbta")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("kdoheekejrmftfuv")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The ids list of AnalyticDB for PostgreSQL instances.
     */
    @JvmName("fvtaqkpmseoeqpia")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values The ids list of AnalyticDB for PostgreSQL instances.
     */
    @JvmName("pvqmslnljobtqpoe")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The network type of the instance.
     */
    @JvmName("lonouacmndoaxcxc")
    public suspend fun instanceNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceNetworkType = mapped
    }

    /**
     * @param value A regex string to apply to the instance name.
     */
    @JvmName("demdmbqbydmveudt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jjtjbdcudtdbnuhk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the enterprise resource group to which the instance belongs.
     */
    @JvmName("qjruedhejwikeixc")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the instance. Valid values: `Creating`, `DBInstanceClassChanging`, `DBInstanceNetTypeChanging`, `Deleting`, `EngineVersionUpgrading`, `GuardDBInstanceCreating`, `GuardSwitching`, `Importing`, `ImportingFromOtherInstance`, `Rebooting`, `Restoring`, `Running`, `Transfering`, `TransferingToOtherInstance`.
     */
    @JvmName("nkplgwdlxcdqjxxk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("msaouvrymeyljvqx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("yaojdujamgxsrlil")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Used to retrieve instances belong to specified `vswitch` resources.
     */
    @JvmName("bllsntpxhivmbbxd")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        availabilityZone = availabilityZone,
        dbInstanceCategories = dbInstanceCategories,
        dbInstanceModes = dbInstanceModes,
        description = description,
        enableDetails = enableDetails,
        ids = ids,
        instanceNetworkType = instanceNetworkType,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
        vswitchId = vswitchId,
    )
}
