@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.inputs

import com.pulumi.alicloud.gpdb.inputs.InstanceIpWhitelistArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipGroupAttribute The value of this parameter is empty by default. The attribute of the whitelist group.
 * If the value contains `hidden`, this white list item will not output.
 * @property ipGroupName IP whitelist group name.
 * @property securityIpList List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
 */
public data class InstanceIpWhitelistArgs(
    public val ipGroupAttribute: Output<String>? = null,
    public val ipGroupName: Output<String>? = null,
    public val securityIpList: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.inputs.InstanceIpWhitelistArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.inputs.InstanceIpWhitelistArgs =
        com.pulumi.alicloud.gpdb.inputs.InstanceIpWhitelistArgs.builder()
            .ipGroupAttribute(ipGroupAttribute?.applyValue({ args0 -> args0 }))
            .ipGroupName(ipGroupName?.applyValue({ args0 -> args0 }))
            .securityIpList(securityIpList?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceIpWhitelistArgs].
 */
@PulumiTagMarker
public class InstanceIpWhitelistArgsBuilder internal constructor() {
    private var ipGroupAttribute: Output<String>? = null

    private var ipGroupName: Output<String>? = null

    private var securityIpList: Output<String>? = null

    /**
     * @param value The value of this parameter is empty by default. The attribute of the whitelist group.
     * If the value contains `hidden`, this white list item will not output.
     */
    @JvmName("brrcdeoevpyyjxws")
    public suspend fun ipGroupAttribute(`value`: Output<String>) {
        this.ipGroupAttribute = value
    }

    /**
     * @param value IP whitelist group name.
     */
    @JvmName("wlkjyxyrypbgbpgm")
    public suspend fun ipGroupName(`value`: Output<String>) {
        this.ipGroupName = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
     */
    @JvmName("wahcmrwpovgrrlcv")
    public suspend fun securityIpList(`value`: Output<String>) {
        this.securityIpList = value
    }

    /**
     * @param value The value of this parameter is empty by default. The attribute of the whitelist group.
     * If the value contains `hidden`, this white list item will not output.
     */
    @JvmName("mfvkkgeiywnbuajp")
    public suspend fun ipGroupAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipGroupAttribute = mapped
    }

    /**
     * @param value IP whitelist group name.
     */
    @JvmName("rifkucudnvspnpfj")
    public suspend fun ipGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipGroupName = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
     */
    @JvmName("budqtrxqiiohxate")
    public suspend fun securityIpList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIpList = mapped
    }

    internal fun build(): InstanceIpWhitelistArgs = InstanceIpWhitelistArgs(
        ipGroupAttribute = ipGroupAttribute,
        ipGroupName = ipGroupName,
        securityIpList = securityIpList,
    )
}
