@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property pause Pause instance plan config. See `pause` below.
 * @property resume Resume instance plan config. See `resume` below.
 * @property scaleIn Scale In instance plan config. See `scale_in` below.
 * @property scaleOut Scale out instance plan config. See `scale_out` below.
 */
public data class DbInstancePlanPlanConfig(
    public val pause: DbInstancePlanPlanConfigPause? = null,
    public val resume: DbInstancePlanPlanConfigResume? = null,
    public val scaleIn: DbInstancePlanPlanConfigScaleIn? = null,
    public val scaleOut: DbInstancePlanPlanConfigScaleOut? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.gpdb.outputs.DbInstancePlanPlanConfig): DbInstancePlanPlanConfig = DbInstancePlanPlanConfig(
            pause = javaType.pause().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.DbInstancePlanPlanConfigPause.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resume = javaType.resume().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.DbInstancePlanPlanConfigResume.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scaleIn = javaType.scaleIn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.DbInstancePlanPlanConfigScaleIn.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scaleOut = javaType.scaleOut().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.DbInstancePlanPlanConfigScaleOut.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
