@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountDescription The description of the account.
 * @property accountName The name of the account.
 * @property dbInstanceId The ID of the instance.
 * @property id The ID of the Account. Its value is same as Queue Name.
 * @property status The status of the account. Valid values: `Active`, `Creating` and `Deleting`.
 */
public data class GetAccountsAccount(
    public val accountDescription: String,
    public val accountName: String,
    public val dbInstanceId: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.gpdb.outputs.GetAccountsAccount): GetAccountsAccount = GetAccountsAccount(
            accountDescription = javaType.accountDescription(),
            accountName = javaType.accountName(),
            dbInstanceId = javaType.dbInstanceId(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
