@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dbInstancePlanName The name of the Plan.
 * @property id The ID of the resource. The value formats as `<db_instance_id>:<plan_id>`.
 * @property planConfigs Plan configuration information.
 * @property planDesc
 * @property planEndDate The end time of the Plan.
 * @property planId The ID of DB Instance Plan.
 * @property planScheduleType Plan scheduling type. Valid values: `Postpone`, `Regular`.
 * @property planStartDate The start time of the Plan.
 * @property planType The type of the Plan. Valid values: `PauseResume`, `Resize`.
 * @property status The Status of the Plan.
 */
public data class GetDbInstancePlansPlan(
    public val dbInstancePlanName: String,
    public val id: String,
    public val planConfigs: List<GetDbInstancePlansPlanPlanConfig>,
    public val planDesc: String,
    public val planEndDate: String,
    public val planId: String,
    public val planScheduleType: String,
    public val planStartDate: String,
    public val planType: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.gpdb.outputs.GetDbInstancePlansPlan): GetDbInstancePlansPlan = GetDbInstancePlansPlan(
            dbInstancePlanName = javaType.dbInstancePlanName(),
            id = javaType.id(),
            planConfigs = javaType.planConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.GetDbInstancePlansPlanPlanConfig.Companion.toKotlin(args0)
                })
            }),
            planDesc = javaType.planDesc(),
            planEndDate = javaType.planEndDate(),
            planId = javaType.planId(),
            planScheduleType = javaType.planScheduleType(),
            planStartDate = javaType.planStartDate(),
            planType = javaType.planType(),
            status = javaType.status(),
        )
    }
}
