@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property pauses Pause instance plan config.
 * @property resumes Resume instance plan config.
 * @property scaleIns Scale In instance plan config.
 * @property scaleOuts Scale out instance plan config.
 */
public data class GetDbInstancePlansPlanPlanConfig(
    public val pauses: List<GetDbInstancePlansPlanPlanConfigPause>,
    public val resumes: List<GetDbInstancePlansPlanPlanConfigResume>,
    public val scaleIns: List<GetDbInstancePlansPlanPlanConfigScaleIn>,
    public val scaleOuts: List<GetDbInstancePlansPlanPlanConfigScaleOut>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.gpdb.outputs.GetDbInstancePlansPlanPlanConfig): GetDbInstancePlansPlanPlanConfig = GetDbInstancePlansPlanPlanConfig(
            pauses = javaType.pauses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.GetDbInstancePlansPlanPlanConfigPause.Companion.toKotlin(args0)
                })
            }),
            resumes = javaType.resumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.GetDbInstancePlansPlanPlanConfigResume.Companion.toKotlin(args0)
                })
            }),
            scaleIns = javaType.scaleIns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.GetDbInstancePlansPlanPlanConfigScaleIn.Companion.toKotlin(args0)
                })
            }),
            scaleOuts = javaType.scaleOuts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.GetDbInstancePlansPlanPlanConfigScaleOut.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
