@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDbInstancePlans.
 * @property dbInstanceId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property planScheduleType
 * @property planType
 * @property plans
 * @property status
 */
public data class GetDbInstancePlansResult(
    public val dbInstanceId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val planScheduleType: String? = null,
    public val planType: String? = null,
    public val plans: List<GetDbInstancePlansPlan>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.gpdb.outputs.GetDbInstancePlansResult): GetDbInstancePlansResult = GetDbInstancePlansResult(
            dbInstanceId = javaType.dbInstanceId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            planScheduleType = javaType.planScheduleType().map({ args0 -> args0 }).orElse(null),
            planType = javaType.planType().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.GetDbInstancePlansPlan.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
