@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property availabilityZone Instance availability zone.
 * @property chargeType
 * @property connectionString The connection string of the instance.
 * @property cpuCores The number of CPU cores of the computing node. Unit: Core.
 * @property createTime The time when the instance was created. The time is in the YYYY-MM-DDThh:mm:ssZ format, such as 2011-05-30T12:11:4Z.
 * @property creationTime
 * @property dbInstanceCategory The db instance category. Valid values: `HighAvailability`, `Basic`.
 * @property dbInstanceClass The db instance class.
 * @property dbInstanceId The db instance id.
 * @property dbInstanceMode The db instance mode. Valid values: `StorageElastic`, `Serverless`, `Classic`.
 * @property description The description of the instance.
 * @property engine The database engine used by the instance.
 * @property engineVersion The version of the database engine used by the instance.
 * @property id The ID of the db Instance.
 * @property instanceNetworkType The network type of the instance.
 * @property ipWhitelists The ip whitelist.
 * @property maintainEndTime The end time of the maintenance window for the instance.
 * @property maintainStartTime The start time of the maintenance window for the instance.
 * @property masterNodeNum The number of Master nodes. Valid values: 1 to 2. if it is not filled in, the default value is 1 Master node.
 * @property memorySize The memory size of the compute node.
 * @property paymentType The billing method of the instance. Valid values: `Subscription`, `PayAsYouGo`.
 * @property regionId Region ID the instance belongs to.
 * @property segNodeNum Calculate the number of nodes. The value range of the high-availability version of the storage elastic mode is 4 to 512, and the value must be a multiple of 4. The value range of the basic version of the storage elastic mode is 2 to 512, and the value must be a multiple of 2. The-Serverless version has a value range of 2 to 512. The value must be a multiple of 2.
 * @property status The status of the instance. Valid values: `Creating`, `DBInstanceClassChanging`, `DBInstanceNetTypeChanging`, `Deleting`, `EngineVersionUpgrading`, `GuardDBInstanceCreating`, `GuardSwitching`, `Importing`, `ImportingFromOtherInstance`, `Rebooting`, `Restoring`, `Running`, `Transfering`, `TransferingToOtherInstance`.
 * @property storageSize The storage capacity. Unit: GB. Value: `50` to `4000`.
 * @property storageType The type of disks. Valid values: `cloud_essd`, `cloud_efficiency`.
 * @property tags The tags of the instance.
 * @property vpcId The ID of the VPC。.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID of the instance.
 */
public data class GetInstancesInstance(
    public val availabilityZone: String,
    public val chargeType: String,
    public val connectionString: String,
    public val cpuCores: String,
    public val createTime: String,
    public val creationTime: String,
    public val dbInstanceCategory: String,
    public val dbInstanceClass: String,
    public val dbInstanceId: String,
    public val dbInstanceMode: String,
    public val description: String,
    public val engine: String,
    public val engineVersion: String,
    public val id: String,
    public val instanceNetworkType: String,
    public val ipWhitelists: List<GetInstancesInstanceIpWhitelist>,
    public val maintainEndTime: String,
    public val maintainStartTime: String,
    public val masterNodeNum: String,
    public val memorySize: String,
    public val paymentType: String,
    public val regionId: String,
    public val segNodeNum: String,
    public val status: String,
    public val storageSize: Int,
    public val storageType: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.gpdb.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            availabilityZone = javaType.availabilityZone(),
            chargeType = javaType.chargeType(),
            connectionString = javaType.connectionString(),
            cpuCores = javaType.cpuCores(),
            createTime = javaType.createTime(),
            creationTime = javaType.creationTime(),
            dbInstanceCategory = javaType.dbInstanceCategory(),
            dbInstanceClass = javaType.dbInstanceClass(),
            dbInstanceId = javaType.dbInstanceId(),
            dbInstanceMode = javaType.dbInstanceMode(),
            description = javaType.description(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            instanceNetworkType = javaType.instanceNetworkType(),
            ipWhitelists = javaType.ipWhitelists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.gpdb.kotlin.outputs.GetInstancesInstanceIpWhitelist.Companion.toKotlin(args0)
                })
            }),
            maintainEndTime = javaType.maintainEndTime(),
            maintainStartTime = javaType.maintainStartTime(),
            masterNodeNum = javaType.masterNodeNum(),
            memorySize = javaType.memorySize(),
            paymentType = javaType.paymentType(),
            regionId = javaType.regionId(),
            segNodeNum = javaType.segNodeNum(),
            status = javaType.status(),
            storageSize = javaType.storageSize(),
            storageType = javaType.storageType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
