@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipGroupAttribute The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
 * @property ipGroupName IP whitelist group name
 * @property securityIpList List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
 */
public data class GetInstancesInstanceIpWhitelist(
    public val ipGroupAttribute: String,
    public val ipGroupName: String,
    public val securityIpList: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.gpdb.outputs.GetInstancesInstanceIpWhitelist): GetInstancesInstanceIpWhitelist = GetInstancesInstanceIpWhitelist(
            ipGroupAttribute = javaType.ipGroupAttribute(),
            ipGroupName = javaType.ipGroupName(),
            securityIpList = javaType.securityIpList(),
        )
    }
}
