@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipGroupAttribute The value of this parameter is empty by default. The attribute of the whitelist group.
 * If the value contains `hidden`, this white list item will not output.
 * @property ipGroupName IP whitelist group name.
 * @property securityIpList List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32])&#46; System default to `["127&#46;0&#46;0&#46;1"]`.
 */
public data class InstanceIpWhitelist(
    public val ipGroupAttribute: String? = null,
    public val ipGroupName: String? = null,
    public val securityIpList: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.gpdb.outputs.InstanceIpWhitelist): InstanceIpWhitelist = InstanceIpWhitelist(
            ipGroupAttribute = javaType.ipGroupAttribute().map({ args0 -> args0 }).orElse(null),
            ipGroupName = javaType.ipGroupName().map({ args0 -> args0 }).orElse(null),
            securityIpList = javaType.securityIpList().map({ args0 -> args0 }).orElse(null),
        )
    }
}
