@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.graphdatabase.kotlin

import com.pulumi.alicloud.graphdatabase.kotlin.outputs.DbInstanceDbInstanceIpArray
import com.pulumi.alicloud.graphdatabase.kotlin.outputs.DbInstanceDbInstanceIpArray.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DbInstance].
 */
@PulumiTagMarker
public class DbInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DbInstanceArgs = DbInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DbInstanceArgsBuilder.() -> Unit) {
        val builder = DbInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DbInstance {
        val builtJavaResource = com.pulumi.alicloud.graphdatabase.DbInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DbInstance(builtJavaResource)
    }
}

/**
 * Provides a Graph Database Db Instance resource.
 * For information about Graph Database Db Instance and how to use it, see [What is Db Instance](https://www.alibabacloud.com/help/en/graph-compute/latest/placeholder).
 * > **NOTE:** Available since v1.136.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.graphdatabase.DbInstance("example", {
 *     dbNodeClass: "gdb.r.2xlarge",
 *     dbInstanceNetworkType: "vpc",
 *     dbVersion: "1.0",
 *     dbInstanceCategory: "HA",
 *     dbInstanceStorageType: "cloud_ssd",
 *     dbNodeStorage: 50,
 *     paymentType: "PayAsYouGo",
 *     dbInstanceDescription: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.graphdatabase.DbInstance("example",
 *     db_node_class="gdb.r.2xlarge",
 *     db_instance_network_type="vpc",
 *     db_version="1.0",
 *     db_instance_category="HA",
 *     db_instance_storage_type="cloud_ssd",
 *     db_node_storage=50,
 *     payment_type="PayAsYouGo",
 *     db_instance_description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.GraphDatabase.DbInstance("example", new()
 *     {
 *         DbNodeClass = "gdb.r.2xlarge",
 *         DbInstanceNetworkType = "vpc",
 *         DbVersion = "1.0",
 *         DbInstanceCategory = "HA",
 *         DbInstanceStorageType = "cloud_ssd",
 *         DbNodeStorage = 50,
 *         PaymentType = "PayAsYouGo",
 *         DbInstanceDescription = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/graphdatabase"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := graphdatabase.NewDbInstance(ctx, "example", &graphdatabase.DbInstanceArgs{
 * 			DbNodeClass:           pulumi.String("gdb.r.2xlarge"),
 * 			DbInstanceNetworkType: pulumi.String("vpc"),
 * 			DbVersion:             pulumi.String("1.0"),
 * 			DbInstanceCategory:    pulumi.String("HA"),
 * 			DbInstanceStorageType: pulumi.String("cloud_ssd"),
 * 			DbNodeStorage:         pulumi.Int(50),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			DbInstanceDescription: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.graphdatabase.DbInstance;
 * import com.pulumi.alicloud.graphdatabase.DbInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new DbInstance("example", DbInstanceArgs.builder()
 *             .dbNodeClass("gdb.r.2xlarge")
 *             .dbInstanceNetworkType("vpc")
 *             .dbVersion("1.0")
 *             .dbInstanceCategory("HA")
 *             .dbInstanceStorageType("cloud_ssd")
 *             .dbNodeStorage("50")
 *             .paymentType("PayAsYouGo")
 *             .dbInstanceDescription(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:graphdatabase:DbInstance
 *     properties:
 *       dbNodeClass: gdb.r.2xlarge
 *       dbInstanceNetworkType: vpc
 *       dbVersion: '1.0'
 *       dbInstanceCategory: HA
 *       dbInstanceStorageType: cloud_ssd
 *       dbNodeStorage: '50'
 *       paymentType: PayAsYouGo
 *       dbInstanceDescription: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Graph Database Db Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:graphdatabase/dbInstance:DbInstance example <id>
 * ```
 */
public class DbInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.graphdatabase.DbInstance,
) : KotlinCustomResource(javaResource, DbInstanceMapper) {
    /**
     * (Available in 1.196.0+)  The connection string of the instance.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
     */
    public val dbInstanceCategory: Output<String>
        get() = javaResource.dbInstanceCategory().applyValue({ args0 -> args0 })

    /**
     * According to the practical example or notes.
     */
    public val dbInstanceDescription: Output<String>?
        get() = javaResource.dbInstanceDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
     */
    public val dbInstanceIpArrays: Output<List<DbInstanceDbInstanceIpArray>>
        get() = javaResource.dbInstanceIpArrays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The network type of the db instance. Valid values: `vpc`.
     */
    public val dbInstanceNetworkType: Output<String>
        get() = javaResource.dbInstanceNetworkType().applyValue({ args0 -> args0 })

    /**
     * Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
     */
    public val dbInstanceStorageType: Output<String>
        get() = javaResource.dbInstanceStorageType().applyValue({ args0 -> args0 })

    /**
     * The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
     */
    public val dbNodeClass: Output<String>
        get() = javaResource.dbNodeClass().applyValue({ args0 -> args0 })

    /**
     * Instance storage space, which is measured in GB.
     */
    public val dbNodeStorage: Output<Int>
        get() = javaResource.dbNodeStorage().applyValue({ args0 -> args0 })

    /**
     * Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
     */
    public val dbVersion: Output<String>
        get() = javaResource.dbVersion().applyValue({ args0 -> args0 })

    /**
     * The paymen type of the resource. Valid values: `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * (Available in 1.196.0+) The connection port of the instance.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * Instance status. Value range: `Creating`, `Running`, `Deleting`, `Rebooting`, `DBInstanceClassChanging`, `NetAddressCreating` and `NetAddressDeleting`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of attaching vswitch to instance.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The zone ID of the resource.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DbInstanceMapper : ResourceMapper<DbInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.graphdatabase.DbInstance::class == javaResource::class

    override fun map(javaResource: Resource): DbInstance = DbInstance(
        javaResource as
            com.pulumi.alicloud.graphdatabase.DbInstance,
    )
}

/**
 * @see [DbInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DbInstance].
 */
public suspend fun dbInstance(name: String, block: suspend DbInstanceResourceBuilder.() -> Unit): DbInstance {
    val builder = DbInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DbInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dbInstance(name: String): DbInstance {
    val builder = DbInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
