@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.graphdatabase.kotlin

import com.pulumi.alicloud.graphdatabase.DbInstanceArgs.builder
import com.pulumi.alicloud.graphdatabase.kotlin.inputs.DbInstanceDbInstanceIpArrayArgs
import com.pulumi.alicloud.graphdatabase.kotlin.inputs.DbInstanceDbInstanceIpArrayArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Graph Database Db Instance resource.
 * For information about Graph Database Db Instance and how to use it, see [What is Db Instance](https://www.alibabacloud.com/help/en/graph-compute/latest/placeholder).
 * > **NOTE:** Available since v1.136.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.graphdatabase.DbInstance("example", {
 *     dbNodeClass: "gdb.r.2xlarge",
 *     dbInstanceNetworkType: "vpc",
 *     dbVersion: "1.0",
 *     dbInstanceCategory: "HA",
 *     dbInstanceStorageType: "cloud_ssd",
 *     dbNodeStorage: 50,
 *     paymentType: "PayAsYouGo",
 *     dbInstanceDescription: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.graphdatabase.DbInstance("example",
 *     db_node_class="gdb.r.2xlarge",
 *     db_instance_network_type="vpc",
 *     db_version="1.0",
 *     db_instance_category="HA",
 *     db_instance_storage_type="cloud_ssd",
 *     db_node_storage=50,
 *     payment_type="PayAsYouGo",
 *     db_instance_description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.GraphDatabase.DbInstance("example", new()
 *     {
 *         DbNodeClass = "gdb.r.2xlarge",
 *         DbInstanceNetworkType = "vpc",
 *         DbVersion = "1.0",
 *         DbInstanceCategory = "HA",
 *         DbInstanceStorageType = "cloud_ssd",
 *         DbNodeStorage = 50,
 *         PaymentType = "PayAsYouGo",
 *         DbInstanceDescription = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/graphdatabase"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := graphdatabase.NewDbInstance(ctx, "example", &graphdatabase.DbInstanceArgs{
 * 			DbNodeClass:           pulumi.String("gdb.r.2xlarge"),
 * 			DbInstanceNetworkType: pulumi.String("vpc"),
 * 			DbVersion:             pulumi.String("1.0"),
 * 			DbInstanceCategory:    pulumi.String("HA"),
 * 			DbInstanceStorageType: pulumi.String("cloud_ssd"),
 * 			DbNodeStorage:         pulumi.Int(50),
 * 			PaymentType:           pulumi.String("PayAsYouGo"),
 * 			DbInstanceDescription: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.graphdatabase.DbInstance;
 * import com.pulumi.alicloud.graphdatabase.DbInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new DbInstance("example", DbInstanceArgs.builder()
 *             .dbNodeClass("gdb.r.2xlarge")
 *             .dbInstanceNetworkType("vpc")
 *             .dbVersion("1.0")
 *             .dbInstanceCategory("HA")
 *             .dbInstanceStorageType("cloud_ssd")
 *             .dbNodeStorage("50")
 *             .paymentType("PayAsYouGo")
 *             .dbInstanceDescription(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:graphdatabase:DbInstance
 *     properties:
 *       dbNodeClass: gdb.r.2xlarge
 *       dbInstanceNetworkType: vpc
 *       dbVersion: '1.0'
 *       dbInstanceCategory: HA
 *       dbInstanceStorageType: cloud_ssd
 *       dbNodeStorage: '50'
 *       paymentType: PayAsYouGo
 *       dbInstanceDescription: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Graph Database Db Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:graphdatabase/dbInstance:DbInstance example <id>
 * ```
 * @property dbInstanceCategory The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
 * @property dbInstanceDescription According to the practical example or notes.
 * @property dbInstanceIpArrays IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
 * @property dbInstanceNetworkType The network type of the db instance. Valid values: `vpc`.
 * @property dbInstanceStorageType Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
 * @property dbNodeClass The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
 * @property dbNodeStorage Instance storage space, which is measured in GB.
 * @property dbVersion Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
 * @property paymentType The paymen type of the resource. Valid values: `PayAsYouGo`.
 * @property vpcId ID of the VPC.
 * @property vswitchId The ID of attaching vswitch to instance.
 * @property zoneId The zone ID of the resource.
 */
public data class DbInstanceArgs(
    public val dbInstanceCategory: Output<String>? = null,
    public val dbInstanceDescription: Output<String>? = null,
    public val dbInstanceIpArrays: Output<List<DbInstanceDbInstanceIpArrayArgs>>? = null,
    public val dbInstanceNetworkType: Output<String>? = null,
    public val dbInstanceStorageType: Output<String>? = null,
    public val dbNodeClass: Output<String>? = null,
    public val dbNodeStorage: Output<Int>? = null,
    public val dbVersion: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.graphdatabase.DbInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.graphdatabase.DbInstanceArgs =
        com.pulumi.alicloud.graphdatabase.DbInstanceArgs.builder()
            .dbInstanceCategory(dbInstanceCategory?.applyValue({ args0 -> args0 }))
            .dbInstanceDescription(dbInstanceDescription?.applyValue({ args0 -> args0 }))
            .dbInstanceIpArrays(
                dbInstanceIpArrays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dbInstanceNetworkType(dbInstanceNetworkType?.applyValue({ args0 -> args0 }))
            .dbInstanceStorageType(dbInstanceStorageType?.applyValue({ args0 -> args0 }))
            .dbNodeClass(dbNodeClass?.applyValue({ args0 -> args0 }))
            .dbNodeStorage(dbNodeStorage?.applyValue({ args0 -> args0 }))
            .dbVersion(dbVersion?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstanceArgs].
 */
@PulumiTagMarker
public class DbInstanceArgsBuilder internal constructor() {
    private var dbInstanceCategory: Output<String>? = null

    private var dbInstanceDescription: Output<String>? = null

    private var dbInstanceIpArrays: Output<List<DbInstanceDbInstanceIpArrayArgs>>? = null

    private var dbInstanceNetworkType: Output<String>? = null

    private var dbInstanceStorageType: Output<String>? = null

    private var dbNodeClass: Output<String>? = null

    private var dbNodeStorage: Output<Int>? = null

    private var dbVersion: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
     */
    @JvmName("xvdebyfperkbnlkf")
    public suspend fun dbInstanceCategory(`value`: Output<String>) {
        this.dbInstanceCategory = value
    }

    /**
     * @param value According to the practical example or notes.
     */
    @JvmName("oeioemucrtcdjccg")
    public suspend fun dbInstanceDescription(`value`: Output<String>) {
        this.dbInstanceDescription = value
    }

    /**
     * @param value IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
     */
    @JvmName("jbbrpfbhxodgscag")
    public suspend fun dbInstanceIpArrays(`value`: Output<List<DbInstanceDbInstanceIpArrayArgs>>) {
        this.dbInstanceIpArrays = value
    }

    @JvmName("tvphradydckpshnj")
    public suspend fun dbInstanceIpArrays(vararg values: Output<DbInstanceDbInstanceIpArrayArgs>) {
        this.dbInstanceIpArrays = Output.all(values.asList())
    }

    /**
     * @param values IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
     */
    @JvmName("piecuoovkubjsdic")
    public suspend fun dbInstanceIpArrays(values: List<Output<DbInstanceDbInstanceIpArrayArgs>>) {
        this.dbInstanceIpArrays = Output.all(values)
    }

    /**
     * @param value The network type of the db instance. Valid values: `vpc`.
     */
    @JvmName("khidkvliqqfvocgy")
    public suspend fun dbInstanceNetworkType(`value`: Output<String>) {
        this.dbInstanceNetworkType = value
    }

    /**
     * @param value Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
     */
    @JvmName("yweyuenoifdlhqie")
    public suspend fun dbInstanceStorageType(`value`: Output<String>) {
        this.dbInstanceStorageType = value
    }

    /**
     * @param value The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
     */
    @JvmName("ootbnijudpousxjw")
    public suspend fun dbNodeClass(`value`: Output<String>) {
        this.dbNodeClass = value
    }

    /**
     * @param value Instance storage space, which is measured in GB.
     */
    @JvmName("bwdqufbkgfpbgfkn")
    public suspend fun dbNodeStorage(`value`: Output<Int>) {
        this.dbNodeStorage = value
    }

    /**
     * @param value Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
     */
    @JvmName("qgfihebqswxxbbyr")
    public suspend fun dbVersion(`value`: Output<String>) {
        this.dbVersion = value
    }

    /**
     * @param value The paymen type of the resource. Valid values: `PayAsYouGo`.
     */
    @JvmName("lgkkivxvxirqtvws")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value ID of the VPC.
     */
    @JvmName("ycfaqdkdnlqtiual")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of attaching vswitch to instance.
     */
    @JvmName("etyghhuvilqbshvl")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("idtdqhddyfdinvfk")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
     */
    @JvmName("qakpraqvjhjlmawf")
    public suspend fun dbInstanceCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceCategory = mapped
    }

    /**
     * @param value According to the practical example or notes.
     */
    @JvmName("jmkbvgukmkyscogm")
    public suspend fun dbInstanceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceDescription = mapped
    }

    /**
     * @param value IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
     */
    @JvmName("qqvemtsdmnefxblo")
    public suspend fun dbInstanceIpArrays(`value`: List<DbInstanceDbInstanceIpArrayArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIpArrays = mapped
    }

    /**
     * @param argument IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
     */
    @JvmName("oytucpbvkrgnshti")
    public suspend fun dbInstanceIpArrays(argument: List<suspend DbInstanceDbInstanceIpArrayArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DbInstanceDbInstanceIpArrayArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dbInstanceIpArrays = mapped
    }

    /**
     * @param argument IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
     */
    @JvmName("cyjcqargcahvryqo")
    public suspend fun dbInstanceIpArrays(vararg argument: suspend DbInstanceDbInstanceIpArrayArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DbInstanceDbInstanceIpArrayArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dbInstanceIpArrays = mapped
    }

    /**
     * @param argument IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
     */
    @JvmName("gednhjayiigaypcn")
    public suspend fun dbInstanceIpArrays(argument: suspend DbInstanceDbInstanceIpArrayArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DbInstanceDbInstanceIpArrayArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dbInstanceIpArrays = mapped
    }

    /**
     * @param values IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
     */
    @JvmName("kmgqpjdxpbugmnfj")
    public suspend fun dbInstanceIpArrays(vararg values: DbInstanceDbInstanceIpArrayArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbInstanceIpArrays = mapped
    }

    /**
     * @param value The network type of the db instance. Valid values: `vpc`.
     */
    @JvmName("dkitkqifjsvgpsux")
    public suspend fun dbInstanceNetworkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceNetworkType = mapped
    }

    /**
     * @param value Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
     */
    @JvmName("tidyckjsoewkomas")
    public suspend fun dbInstanceStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceStorageType = mapped
    }

    /**
     * @param value The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
     */
    @JvmName("svrmviuumrbdiall")
    public suspend fun dbNodeClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeClass = mapped
    }

    /**
     * @param value Instance storage space, which is measured in GB.
     */
    @JvmName("pderhnjnbltiarue")
    public suspend fun dbNodeStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeStorage = mapped
    }

    /**
     * @param value Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
     */
    @JvmName("vxvammtjkvewjnfa")
    public suspend fun dbVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbVersion = mapped
    }

    /**
     * @param value The paymen type of the resource. Valid values: `PayAsYouGo`.
     */
    @JvmName("lydsvnymfalhksgu")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value ID of the VPC.
     */
    @JvmName("fndtnuiyageprgcg")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of attaching vswitch to instance.
     */
    @JvmName("htddsixxogmrnsym")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("gnilkdewinfrbnoy")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DbInstanceArgs = DbInstanceArgs(
        dbInstanceCategory = dbInstanceCategory,
        dbInstanceDescription = dbInstanceDescription,
        dbInstanceIpArrays = dbInstanceIpArrays,
        dbInstanceNetworkType = dbInstanceNetworkType,
        dbInstanceStorageType = dbInstanceStorageType,
        dbNodeClass = dbNodeClass,
        dbNodeStorage = dbNodeStorage,
        dbVersion = dbVersion,
        paymentType = paymentType,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
