@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.graphdatabase.kotlin.inputs

import com.pulumi.alicloud.graphdatabase.inputs.DbInstanceDbInstanceIpArrayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dbInstanceIpArrayAttribute The default is empty. To distinguish between the different property console does not display a `hidden` label grouping.
 * @property dbInstanceIpArrayName IP ADDRESS whitelist group name.
 * @property securityIps IP ADDRESS whitelist addresses in the IP ADDRESS list, and a maximum of 1000 comma-separated format is as follows: `0.0.0.0/0` and `10.23.12.24`(IP) or `10.23.12.24/24`(CIDR mode, CIDR (Classless Inter-Domain Routing)/24 represents the address prefixes in the length of the range [1,32]).
 */
public data class DbInstanceDbInstanceIpArrayArgs(
    public val dbInstanceIpArrayAttribute: Output<String>? = null,
    public val dbInstanceIpArrayName: Output<String>? = null,
    public val securityIps: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.graphdatabase.inputs.DbInstanceDbInstanceIpArrayArgs> {
    override fun toJava(): com.pulumi.alicloud.graphdatabase.inputs.DbInstanceDbInstanceIpArrayArgs =
        com.pulumi.alicloud.graphdatabase.inputs.DbInstanceDbInstanceIpArrayArgs.builder()
            .dbInstanceIpArrayAttribute(dbInstanceIpArrayAttribute?.applyValue({ args0 -> args0 }))
            .dbInstanceIpArrayName(dbInstanceIpArrayName?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstanceDbInstanceIpArrayArgs].
 */
@PulumiTagMarker
public class DbInstanceDbInstanceIpArrayArgsBuilder internal constructor() {
    private var dbInstanceIpArrayAttribute: Output<String>? = null

    private var dbInstanceIpArrayName: Output<String>? = null

    private var securityIps: Output<String>? = null

    /**
     * @param value The default is empty. To distinguish between the different property console does not display a `hidden` label grouping.
     */
    @JvmName("ssowifombbbvvtpb")
    public suspend fun dbInstanceIpArrayAttribute(`value`: Output<String>) {
        this.dbInstanceIpArrayAttribute = value
    }

    /**
     * @param value IP ADDRESS whitelist group name.
     */
    @JvmName("wbkgtogjcqvondqr")
    public suspend fun dbInstanceIpArrayName(`value`: Output<String>) {
        this.dbInstanceIpArrayName = value
    }

    /**
     * @param value IP ADDRESS whitelist addresses in the IP ADDRESS list, and a maximum of 1000 comma-separated format is as follows: `0.0.0.0/0` and `10.23.12.24`(IP) or `10.23.12.24/24`(CIDR mode, CIDR (Classless Inter-Domain Routing)/24 represents the address prefixes in the length of the range [1,32]).
     */
    @JvmName("gvlycrqvahbjoluf")
    public suspend fun securityIps(`value`: Output<String>) {
        this.securityIps = value
    }

    /**
     * @param value The default is empty. To distinguish between the different property console does not display a `hidden` label grouping.
     */
    @JvmName("kfghbxjbuxbtpgxj")
    public suspend fun dbInstanceIpArrayAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIpArrayAttribute = mapped
    }

    /**
     * @param value IP ADDRESS whitelist group name.
     */
    @JvmName("qeqgubountqvpfow")
    public suspend fun dbInstanceIpArrayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIpArrayName = mapped
    }

    /**
     * @param value IP ADDRESS whitelist addresses in the IP ADDRESS list, and a maximum of 1000 comma-separated format is as follows: `0.0.0.0/0` and `10.23.12.24`(IP) or `10.23.12.24/24`(CIDR mode, CIDR (Classless Inter-Domain Routing)/24 represents the address prefixes in the length of the range [1,32]).
     */
    @JvmName("awdogmdjuepjldue")
    public suspend fun securityIps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    internal fun build(): DbInstanceDbInstanceIpArrayArgs = DbInstanceDbInstanceIpArrayArgs(
        dbInstanceIpArrayAttribute = dbInstanceIpArrayAttribute,
        dbInstanceIpArrayName = dbInstanceIpArrayName,
        securityIps = securityIps,
    )
}
