@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.graphdatabase.kotlin.inputs

import com.pulumi.alicloud.graphdatabase.inputs.GetDbInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDbInstances.
 * @property dbInstanceDescription According to the practical example or notes.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Db Instance IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Instance status. Value range: `Creating`, `Running`, `Deleting`, `DBInstanceClassChanging`, `NetAddressCreating` and `NetAddressDeleting`.
 */
public data class GetDbInstancesPlainArgs(
    public val dbInstanceDescription: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.graphdatabase.inputs.GetDbInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.graphdatabase.inputs.GetDbInstancesPlainArgs =
        com.pulumi.alicloud.graphdatabase.inputs.GetDbInstancesPlainArgs.builder()
            .dbInstanceDescription(dbInstanceDescription?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDbInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetDbInstancesPlainArgsBuilder internal constructor() {
    private var dbInstanceDescription: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value According to the practical example or notes.
     */
    @JvmName("onsutkadjbujugmb")
    public suspend fun dbInstanceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceDescription = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("tejvcnttorfnvxwm")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Db Instance IDs.
     */
    @JvmName("wlvsmdtteyodudfp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Db Instance IDs.
     */
    @JvmName("swedjxgvqmccyrea")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lyfhmntprnqypcfk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Instance status. Value range: `Creating`, `Running`, `Deleting`, `DBInstanceClassChanging`, `NetAddressCreating` and `NetAddressDeleting`.
     */
    @JvmName("jxxsvrhybxeyuefj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDbInstancesPlainArgs = GetDbInstancesPlainArgs(
        dbInstanceDescription = dbInstanceDescription,
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
