@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.graphdatabase.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property connectionString Virtual Private Cloud (vpc connection such as a VPN connection or leased line domain name).
 * @property createTime Creation time, which follows the format of `YYYY-MM-DD 'T'hh:mm:ssZ`, such as `2011-05-30 T12:11:4Z`.
 * @property currentMinorVersion The current kernel image version.
 * @property dbInstanceCategory The category of the db instance.
 * @property dbInstanceCpu For example, instances can be grouped according to Cpu core count.
 * @property dbInstanceDescription According to the practical example or notes.
 * @property dbInstanceId The ID of the instance.
 * @property dbInstanceIpArrays IP ADDRESS whitelist for the instance group list.
 * @property dbInstanceMemory Instance memory, which is measured in MB.
 * @property dbInstanceNetworkType The network type of the db instance.
 * @property dbInstanceStorageType Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`.
 * @property dbInstanceType The type of the db instance.
 * @property dbNodeClass The class of the db node.
 * @property dbNodeCount The count of the db node.
 * @property dbNodeStorage Instance storage space, which is measured in GB.
 * @property dbVersion Kernel Version. Value range: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
 * @property expireTime The instance after it expires time for subscription instance.
 * @property expired The expire status of the db instance.
 * @property id The ID of the Db Instance.
 * @property latestMinorVersion The latest kernel image version.
 * @property lockMode Instance lock state. Value range: `Unlock`, `ManualLock`, `LockByExpiration`, `LockByRestoration` and `LockByDiskQuota`. `Unlock`: normal. `ManualLock`: the manual trigger lock. `LockByExpiration`: that represents the instance expires automatically lock. `LockByRestoration`: indicates that the instance rollback before auto-lock. `LockByDiskQuota`: that represents the instance space full automatic lock.
 * @property lockReason An instance is locked the reason.
 * @property maintainTime Instance maintenance time such as `00:00Z-02:00Z`, 0 to 2 points to carry out routine maintenance.
 * @property masterDbInstanceId The master instance ID of the db instance.
 * @property paymentType The paymen type of the resource.
 * @property port Application Port.
 * @property publicConnectionString The public connection string ID of the resource.
 * @property publicPort The public port ID of the resource.
 * @property readOnlyDbInstanceIds The array of the readonly db instances.
 * @property status Instance status. Value range: `Creating`, `Running`, `Deleting`, `Rebooting`, `DBInstanceClassChanging`, `NetAddressCreating` and `NetAddressDeleting`.
 * @property vpcId The vpc id of the db instance.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID of the resource.
 */
public data class GetDbInstancesInstance(
    public val connectionString: String,
    public val createTime: String,
    public val currentMinorVersion: String,
    public val dbInstanceCategory: String,
    public val dbInstanceCpu: String,
    public val dbInstanceDescription: String,
    public val dbInstanceId: String,
    public val dbInstanceIpArrays: List<GetDbInstancesInstanceDbInstanceIpArray>,
    public val dbInstanceMemory: String,
    public val dbInstanceNetworkType: String,
    public val dbInstanceStorageType: String,
    public val dbInstanceType: String,
    public val dbNodeClass: String,
    public val dbNodeCount: String,
    public val dbNodeStorage: String,
    public val dbVersion: String,
    public val expireTime: String,
    public val expired: String,
    public val id: String,
    public val latestMinorVersion: String,
    public val lockMode: String,
    public val lockReason: String,
    public val maintainTime: String,
    public val masterDbInstanceId: String,
    public val paymentType: String,
    public val port: Int,
    public val publicConnectionString: String,
    public val publicPort: Int,
    public val readOnlyDbInstanceIds: List<String>,
    public val status: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.graphdatabase.outputs.GetDbInstancesInstance): GetDbInstancesInstance = GetDbInstancesInstance(
            connectionString = javaType.connectionString(),
            createTime = javaType.createTime(),
            currentMinorVersion = javaType.currentMinorVersion(),
            dbInstanceCategory = javaType.dbInstanceCategory(),
            dbInstanceCpu = javaType.dbInstanceCpu(),
            dbInstanceDescription = javaType.dbInstanceDescription(),
            dbInstanceId = javaType.dbInstanceId(),
            dbInstanceIpArrays = javaType.dbInstanceIpArrays().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.graphdatabase.kotlin.outputs.GetDbInstancesInstanceDbInstanceIpArray.Companion.toKotlin(args0)
                })
            }),
            dbInstanceMemory = javaType.dbInstanceMemory(),
            dbInstanceNetworkType = javaType.dbInstanceNetworkType(),
            dbInstanceStorageType = javaType.dbInstanceStorageType(),
            dbInstanceType = javaType.dbInstanceType(),
            dbNodeClass = javaType.dbNodeClass(),
            dbNodeCount = javaType.dbNodeCount(),
            dbNodeStorage = javaType.dbNodeStorage(),
            dbVersion = javaType.dbVersion(),
            expireTime = javaType.expireTime(),
            expired = javaType.expired(),
            id = javaType.id(),
            latestMinorVersion = javaType.latestMinorVersion(),
            lockMode = javaType.lockMode(),
            lockReason = javaType.lockReason(),
            maintainTime = javaType.maintainTime(),
            masterDbInstanceId = javaType.masterDbInstanceId(),
            paymentType = javaType.paymentType(),
            port = javaType.port(),
            publicConnectionString = javaType.publicConnectionString(),
            publicPort = javaType.publicPort(),
            readOnlyDbInstanceIds = javaType.readOnlyDbInstanceIds().map({ args0 -> args0 }),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
