@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.graphdatabase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dbInstanceIpArrayAttribute The default is empty. To distinguish between the different property console does not display a `hidden` label grouping.
 * @property dbInstanceIpArrayName IP ADDRESS whitelist group name.
 * @property securityIps IP ADDRESS whitelist addresses in the IP ADDRESS list, and a maximum of 1000 comma-separated format is as follows: `0.0.0.0/0` and `10.23.12.24`(IP) or `10.23.12.24/24`(CIDR mode, CIDR (Classless Inter-Domain Routing)/24 represents the address prefixes in the length of the range [1,32]).
 */
public data class GetDbInstancesInstanceDbInstanceIpArray(
    public val dbInstanceIpArrayAttribute: String? = null,
    public val dbInstanceIpArrayName: String? = null,
    public val securityIps: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.graphdatabase.outputs.GetDbInstancesInstanceDbInstanceIpArray): GetDbInstancesInstanceDbInstanceIpArray = GetDbInstancesInstanceDbInstanceIpArray(
            dbInstanceIpArrayAttribute = javaType.dbInstanceIpArrayAttribute().map({ args0 ->
                args0
            }).orElse(null),
            dbInstanceIpArrayName = javaType.dbInstanceIpArrayName().map({ args0 -> args0 }).orElse(null),
            securityIps = javaType.securityIps().map({ args0 -> args0 }).orElse(null),
        )
    }
}
