@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin

import com.pulumi.alicloud.hbase.HbaseFunctions.getInstanceTypesPlain
import com.pulumi.alicloud.hbase.HbaseFunctions.getInstancesPlain
import com.pulumi.alicloud.hbase.HbaseFunctions.getZonesPlain
import com.pulumi.alicloud.hbase.kotlin.inputs.GetInstanceTypesPlainArgs
import com.pulumi.alicloud.hbase.kotlin.inputs.GetInstanceTypesPlainArgsBuilder
import com.pulumi.alicloud.hbase.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.hbase.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.hbase.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.hbase.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.hbase.kotlin.outputs.GetInstanceTypesResult
import com.pulumi.alicloud.hbase.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.hbase.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.hbase.kotlin.outputs.GetInstanceTypesResult.Companion.toKotlin as getInstanceTypesResultToKotlin
import com.pulumi.alicloud.hbase.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.hbase.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object HbaseFunctions {
    /**
     * This data source provides availability instance_types for HBase that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available since v1.106.0.
     * @param argument A collection of arguments for invoking getInstanceTypes.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: GetInstanceTypesPlainArgs): GetInstanceTypesResult =
        getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypes].
     * @param chargeType The charge type of create hbase cluster instance, `PrePaid` or `PostPaid`.
     * @param diskType The disk type, `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`.
     * @param engine The engine name, `singlehbase`, `hbase`, `hbaseue`, `bds`.
     * @param instanceType The hbase instance type of create hbase cluster instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param regionId The dest region id, default client region.
     * @param version The engine version, singlehbase/hbase=1.1/2.0, bds=1.0.
     * @param zoneId The zone id, belong to regionId.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(
        chargeType: String? = null,
        diskType: String? = null,
        engine: String? = null,
        instanceType: String? = null,
        outputFile: String? = null,
        regionId: String? = null,
        version: String? = null,
        zoneId: String? = null,
    ): GetInstanceTypesResult {
        val argument = GetInstanceTypesPlainArgs(
            chargeType = chargeType,
            diskType = diskType,
            engine = engine,
            instanceType = instanceType,
            outputFile = outputFile,
            regionId = regionId,
            version = version,
            zoneId = zoneId,
        )
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbase&#46;kotlin&#46;inputs&#46;GetInstanceTypesPlainArgs].
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: suspend GetInstanceTypesPlainArgsBuilder.() -> Unit): GetInstanceTypesResult {
        val builder = GetInstanceTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.hbase.getInstances` data source provides a collection of HBase instances available in Alicloud account.
     * Filters support regular expression for the instance name, ids or availability_zone.
     * > **NOTE:**  Available in 1.67.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const hbase = alicloud.hbase.getInstances({
     *     nameRegex: "tf_testAccHBase",
     *     availabilityZone: "cn-shenzhen-b",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * hbase = alicloud.hbase.get_instances(name_regex="tf_testAccHBase",
     *     availability_zone="cn-shenzhen-b")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var hbase = AliCloud.Hbase.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "tf_testAccHBase",
     *         AvailabilityZone = "cn-shenzhen-b",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbase"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := hbase.GetInstances(ctx, &hbase.GetInstancesArgs{
     * 			NameRegex:        pulumi.StringRef("tf_testAccHBase"),
     * 			AvailabilityZone: pulumi.StringRef("cn-shenzhen-b"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbase.HbaseFunctions;
     * import com.pulumi.alicloud.hbase.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var hbase = HbaseFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("tf_testAccHBase")
     *             .availabilityZone("cn-shenzhen-b")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   hbase:
     *     fn::invoke:
     *       Function: alicloud:hbase:getInstances
     *       Arguments:
     *         nameRegex: tf_testAccHBase
     *         availabilityZone: cn-shenzhen-b
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param availabilityZone Instance availability zone.
     * @param ids The ids list of HBase instances
     * @param nameRegex A regex string to apply to the instance name.
     * @param outputFile The name of file that can save the collection of instances after running `pulumi preview`.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        availabilityZone: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            availabilityZone = availabilityZone,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbase&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for HBase that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.73.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const zonesIds = alicloud.hbase.getZones({});
     * const hbase = new alicloud.hbase.Instance("hbase", {zoneId: zonesIds.then(zonesIds => zonesIds.zones?.[0]?.id)});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * zones_ids = alicloud.hbase.get_zones()
     * hbase = alicloud.hbase.Instance("hbase", zone_id=zones_ids.zones[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var zonesIds = AliCloud.Hbase.GetZones.Invoke();
     *     var hbase = new AliCloud.Hbase.Instance("hbase", new()
     *     {
     *         ZoneId = zonesIds.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbase"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		zonesIds, err := hbase.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = hbase.NewInstance(ctx, "hbase", &hbase.InstanceArgs{
     * 			ZoneId: pulumi.String(zonesIds.Zones[0].Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbase.HbaseFunctions;
     * import com.pulumi.alicloud.hbase.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.hbase.Instance;
     * import com.pulumi.alicloud.hbase.InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var zonesIds = HbaseFunctions.getZones();
     *         var hbase = new Instance("hbase", InstanceArgs.builder()
     *             .zoneId(zonesIds.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   hbase:
     *     type: alicloud:hbase:Instance
     *     properties:
     *       zoneId: ${zonesIds.zones[0].id}
     * variables:
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:hbase:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbase&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
