@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin

import com.pulumi.alicloud.hbase.kotlin.outputs.InstanceSlbConnAddr
import com.pulumi.alicloud.hbase.kotlin.outputs.InstanceUiProxyConnAddr
import com.pulumi.alicloud.hbase.kotlin.outputs.InstanceZkConnAddr
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.hbase.kotlin.outputs.InstanceSlbConnAddr.Companion.toKotlin as instanceSlbConnAddrToKotlin
import com.pulumi.alicloud.hbase.kotlin.outputs.InstanceUiProxyConnAddr.Companion.toKotlin as instanceUiProxyConnAddrToKotlin
import com.pulumi.alicloud.hbase.kotlin.outputs.InstanceZkConnAddr.Companion.toKotlin as instanceZkConnAddrToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.hbase.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a HBase instance resource supports replica set instances only. The HBase provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/en/apsaradb-for-hbase/latest/createcluster)
 * > **NOTE:** Available since v1.67.0.
 * > **NOTE:**  The following regions don't support create Classic network HBase instance.
 * [`cn-hangzhou`,`cn-shanghai`,`cn-qingdao`,`cn-beijing`,`cn-shenzhen`,`ap-southeast-1a`,&#46;&#46;&#46;&#46;&#46;]
 * The official website mark  more regions. or you can call [DescribeRegions](https://www.alibabacloud.com/help/en/apsaradb-for-hbase/latest/describeregions)
 * > **NOTE:**  Create HBase instance or change instance type and storage would cost 15 minutes. Please make full preparation
 * ## Example Usage
 * ### Create a hbase instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.hbase.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[1]?.id,
 * }));
 * const defaultInstance = new alicloud.hbase.Instance("default", {
 *     name: name,
 *     zoneId: _default.then(_default => _default.zones?.[1]?.id),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     engine: "hbaseue",
 *     engineVersion: "2.0",
 *     masterInstanceType: "hbase.sn2.2xlarge",
 *     coreInstanceType: "hbase.sn2.2xlarge",
 *     coreInstanceQuantity: 2,
 *     coreDiskType: "cloud_efficiency",
 *     coreDiskSize: 400,
 *     payType: "PostPaid",
 *     coldStorageSize: 0,
 *     deletionProtection: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.hbase.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[1].id)
 * default_instance = alicloud.hbase.Instance("default",
 *     name=name,
 *     zone_id=default.zones[1].id,
 *     vswitch_id=default_get_switches.ids[0],
 *     vpc_id=default_get_networks.ids[0],
 *     engine="hbaseue",
 *     engine_version="2.0",
 *     master_instance_type="hbase.sn2.2xlarge",
 *     core_instance_type="hbase.sn2.2xlarge",
 *     core_instance_quantity=2,
 *     core_disk_type="cloud_efficiency",
 *     core_disk_size=400,
 *     pay_type="PostPaid",
 *     cold_storage_size=0,
 *     deletion_protection=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Hbase.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *     });
 *     var defaultInstance = new AliCloud.Hbase.Instance("default", new()
 *     {
 *         Name = name,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[1]?.Id)),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         Engine = "hbaseue",
 *         EngineVersion = "2.0",
 *         MasterInstanceType = "hbase.sn2.2xlarge",
 *         CoreInstanceType = "hbase.sn2.2xlarge",
 *         CoreInstanceQuantity = 2,
 *         CoreDiskType = "cloud_efficiency",
 *         CoreDiskSize = 400,
 *         PayType = "PostPaid",
 *         ColdStorageSize = 0,
 *         DeletionProtection = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbase"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := hbase.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Zones[1].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbase.NewInstance(ctx, "default", &hbase.InstanceArgs{
 * 			Name:                 pulumi.String(name),
 * 			ZoneId:               pulumi.String(_default.Zones[1].Id),
 * 			VswitchId:            pulumi.String(defaultGetSwitches.Ids[0]),
 * 			VpcId:                pulumi.String(defaultGetNetworks.Ids[0]),
 * 			Engine:               pulumi.String("hbaseue"),
 * 			EngineVersion:        pulumi.String("2.0"),
 * 			MasterInstanceType:   pulumi.String("hbase.sn2.2xlarge"),
 * 			CoreInstanceType:     pulumi.String("hbase.sn2.2xlarge"),
 * 			CoreInstanceQuantity: pulumi.Int(2),
 * 			CoreDiskType:         pulumi.String("cloud_efficiency"),
 * 			CoreDiskSize:         pulumi.Int(400),
 * 			PayType:              pulumi.String("PostPaid"),
 * 			ColdStorageSize:      pulumi.Int(0),
 * 			DeletionProtection:   pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.hbase.HbaseFunctions;
 * import com.pulumi.alicloud.hbase.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.hbase.Instance;
 * import com.pulumi.alicloud.hbase.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = HbaseFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[1].id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(name)
 *             .zoneId(default_.zones()[1].id())
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .engine("hbaseue")
 *             .engineVersion("2.0")
 *             .masterInstanceType("hbase.sn2.2xlarge")
 *             .coreInstanceType("hbase.sn2.2xlarge")
 *             .coreInstanceQuantity(2)
 *             .coreDiskType("cloud_efficiency")
 *             .coreDiskSize(400)
 *             .payType("PostPaid")
 *             .coldStorageSize(0)
 *             .deletionProtection("false")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:hbase:Instance
 *     name: default
 *     properties:
 *       name: ${name}
 *       zoneId: ${default.zones[1].id}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       engine: hbaseue
 *       engineVersion: '2.0'
 *       masterInstanceType: hbase.sn2.2xlarge
 *       coreInstanceType: hbase.sn2.2xlarge
 *       coreInstanceQuantity: 2
 *       coreDiskType: cloud_efficiency
 *       coreDiskSize: 400
 *       payType: PostPaid
 *       coldStorageSize: 0
 *       deletionProtection: 'false'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:hbase:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[1].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * this is a example for class netType instance. you can find more detail with the examples/hbase dir.
 * ## Import
 * HBase can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbase/instance:Instance example hb-wz96815u13k659fvd
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.hbase.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The account of the cluster web ui. Size [0-128].
     */
    public val account: Output<String>?
        get() = javaResource.account().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
     */
    public val autoRenew: Output<Boolean>
        get() = javaResource.autoRenew().applyValue({ args0 -> args0 })

    /**
     * 0 or [800, 100000000], step:10-GB increments&#46; 0 means is_cold_storage = false&#46; [800, 100000000] means is_cold_storage = true.
     */
    public val coldStorageSize: Output<Int>?
        get() = javaResource.coldStorageSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
     * - Custom storage space, value range: [20, 64000].
     * - Cluster [400, 64000], step:40-GB increments.
     * - Single [20-500GB], step:1-GB increments.
     */
    public val coreDiskSize: Output<Int>?
        get() = javaResource.coreDiskSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
     */
    public val coreDiskType: Output<String>?
        get() = javaResource.coreDiskType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
     */
    public val coreInstanceQuantity: Output<Int>?
        get() = javaResource.coreInstanceQuantity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
     */
    public val coreInstanceType: Output<String>
        get() = javaResource.coreInstanceType().applyValue({ args0 -> args0 })

    /**
     * The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
     */
    public val duration: Output<Int>
        get() = javaResource.duration().applyValue({ args0 -> args0 })

    /**
     * Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
     */
    public val engine: Output<String>?
        get() = javaResource.engine().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
     */
    public val immediateDeleteFlag: Output<Boolean>?
        get() = javaResource.immediateDeleteFlag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The white ip list of the cluster.
     */
    public val ipWhite: Output<String>
        get() = javaResource.ipWhite().applyValue({ args0 -> args0 })

    /**
     * The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
     */
    public val maintainEndTime: Output<String>
        get() = javaResource.maintainEndTime().applyValue({ args0 -> args0 })

    /**
     * The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
     */
    public val maintainStartTime: Output<String>
        get() = javaResource.maintainStartTime().applyValue({ args0 -> args0 })

    /**
     * Count nodes of the master node.
     */
    public val masterInstanceQuantity: Output<Int>
        get() = javaResource.masterInstanceQuantity().applyValue({ args0 -> args0 })

    /**
     * Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
     */
    public val masterInstanceType: Output<String>
        get() = javaResource.masterInstanceType().applyValue({ args0 -> args0 })

    /**
     * HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The password of the cluster web ui account. Size [0-128].
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
     */
    public val payType: Output<String>?
        get() = javaResource.payType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The security group resource of the cluster.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The slb service addresses of the cluster. See `slb_conn_addrs` below.
     * > **NOTE:** Now only instance name can be change. The others(instance_type, disk_size, core_instance_quantity and so on) will be supported in the furture.
     */
    public val slbConnAddrs: Output<List<InstanceSlbConnAddr>>
        get() = javaResource.slbConnAddrs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceSlbConnAddrToKotlin(args0)
                })
            })
        })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The Web UI proxy addresses of the cluster. See `ui_proxy_conn_addrs` below.
     */
    public val uiProxyConnAddrs: Output<List<InstanceUiProxyConnAddr>>
        get() = javaResource.uiProxyConnAddrs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceUiProxyConnAddrToKotlin(args0) })
            })
        })

    /**
     * The id of the VPC.
     */
    public val vpcId: Output<String>?
        get() = javaResource.vpcId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The zookeeper addresses of the cluster. See `zk_conn_addrs` below.
     */
    public val zkConnAddrs: Output<List<InstanceZkConnAddr>>
        get() = javaResource.zkConnAddrs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceZkConnAddrToKotlin(args0)
                })
            })
        })

    /**
     * The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.hbase.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.hbase.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
