@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin

import com.pulumi.alicloud.hbase.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a HBase instance resource supports replica set instances only. The HBase provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/en/apsaradb-for-hbase/latest/createcluster)
 * > **NOTE:** Available since v1.67.0.
 * > **NOTE:**  The following regions don't support create Classic network HBase instance.
 * [`cn-hangzhou`,`cn-shanghai`,`cn-qingdao`,`cn-beijing`,`cn-shenzhen`,`ap-southeast-1a`,&#46;&#46;&#46;&#46;&#46;]
 * The official website mark  more regions. or you can call [DescribeRegions](https://www.alibabacloud.com/help/en/apsaradb-for-hbase/latest/describeregions)
 * > **NOTE:**  Create HBase instance or change instance type and storage would cost 15 minutes. Please make full preparation
 * ## Example Usage
 * ### Create a hbase instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.hbase.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[1]?.id,
 * }));
 * const defaultInstance = new alicloud.hbase.Instance("default", {
 *     name: name,
 *     zoneId: _default.then(_default => _default.zones?.[1]?.id),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     engine: "hbaseue",
 *     engineVersion: "2.0",
 *     masterInstanceType: "hbase.sn2.2xlarge",
 *     coreInstanceType: "hbase.sn2.2xlarge",
 *     coreInstanceQuantity: 2,
 *     coreDiskType: "cloud_efficiency",
 *     coreDiskSize: 400,
 *     payType: "PostPaid",
 *     coldStorageSize: 0,
 *     deletionProtection: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.hbase.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[1].id)
 * default_instance = alicloud.hbase.Instance("default",
 *     name=name,
 *     zone_id=default.zones[1].id,
 *     vswitch_id=default_get_switches.ids[0],
 *     vpc_id=default_get_networks.ids[0],
 *     engine="hbaseue",
 *     engine_version="2.0",
 *     master_instance_type="hbase.sn2.2xlarge",
 *     core_instance_type="hbase.sn2.2xlarge",
 *     core_instance_quantity=2,
 *     core_disk_type="cloud_efficiency",
 *     core_disk_size=400,
 *     pay_type="PostPaid",
 *     cold_storage_size=0,
 *     deletion_protection=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Hbase.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[1]?.Id),
 *     });
 *     var defaultInstance = new AliCloud.Hbase.Instance("default", new()
 *     {
 *         Name = name,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[1]?.Id)),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         Engine = "hbaseue",
 *         EngineVersion = "2.0",
 *         MasterInstanceType = "hbase.sn2.2xlarge",
 *         CoreInstanceType = "hbase.sn2.2xlarge",
 *         CoreInstanceQuantity = 2,
 *         CoreDiskType = "cloud_efficiency",
 *         CoreDiskSize = 400,
 *         PayType = "PostPaid",
 *         ColdStorageSize = 0,
 *         DeletionProtection = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbase"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := hbase.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Zones[1].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbase.NewInstance(ctx, "default", &hbase.InstanceArgs{
 * 			Name:                 pulumi.String(name),
 * 			ZoneId:               pulumi.String(_default.Zones[1].Id),
 * 			VswitchId:            pulumi.String(defaultGetSwitches.Ids[0]),
 * 			VpcId:                pulumi.String(defaultGetNetworks.Ids[0]),
 * 			Engine:               pulumi.String("hbaseue"),
 * 			EngineVersion:        pulumi.String("2.0"),
 * 			MasterInstanceType:   pulumi.String("hbase.sn2.2xlarge"),
 * 			CoreInstanceType:     pulumi.String("hbase.sn2.2xlarge"),
 * 			CoreInstanceQuantity: pulumi.Int(2),
 * 			CoreDiskType:         pulumi.String("cloud_efficiency"),
 * 			CoreDiskSize:         pulumi.Int(400),
 * 			PayType:              pulumi.String("PostPaid"),
 * 			ColdStorageSize:      pulumi.Int(0),
 * 			DeletionProtection:   pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.hbase.HbaseFunctions;
 * import com.pulumi.alicloud.hbase.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.hbase.Instance;
 * import com.pulumi.alicloud.hbase.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = HbaseFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[1].id())
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(name)
 *             .zoneId(default_.zones()[1].id())
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .engine("hbaseue")
 *             .engineVersion("2.0")
 *             .masterInstanceType("hbase.sn2.2xlarge")
 *             .coreInstanceType("hbase.sn2.2xlarge")
 *             .coreInstanceQuantity(2)
 *             .coreDiskType("cloud_efficiency")
 *             .coreDiskSize(400)
 *             .payType("PostPaid")
 *             .coldStorageSize(0)
 *             .deletionProtection("false")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:hbase:Instance
 *     name: default
 *     properties:
 *       name: ${name}
 *       zoneId: ${default.zones[1].id}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       engine: hbaseue
 *       engineVersion: '2.0'
 *       masterInstanceType: hbase.sn2.2xlarge
 *       coreInstanceType: hbase.sn2.2xlarge
 *       coreInstanceQuantity: 2
 *       coreDiskType: cloud_efficiency
 *       coreDiskSize: 400
 *       payType: PostPaid
 *       coldStorageSize: 0
 *       deletionProtection: 'false'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:hbase:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[1].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * this is a example for class netType instance. you can find more detail with the examples/hbase dir.
 * ## Import
 * HBase can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbase/instance:Instance example hb-wz96815u13k659fvd
 * ```
 * @property account The account of the cluster web ui. Size [0-128].
 * @property autoRenew Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
 * @property coldStorageSize 0 or [800, 100000000], step:10-GB increments&#46; 0 means is_cold_storage = false&#46; [800, 100000000] means is_cold_storage = true.
 * @property coreDiskSize User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
 * - Custom storage space, value range: [20, 64000].
 * - Cluster [400, 64000], step:40-GB increments.
 * - Single [20-500GB], step:1-GB increments.
 * @property coreDiskType Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
 * @property coreInstanceQuantity Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
 * @property coreInstanceType Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
 * @property deletionProtection The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
 * @property duration 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
 * @property engine Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
 * @property engineVersion HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
 * @property immediateDeleteFlag The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
 * @property ipWhite The white ip list of the cluster.
 * @property maintainEndTime The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
 * @property maintainStartTime The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
 * @property masterInstanceType Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
 * @property name HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
 * @property password The password of the cluster web ui account. Size [0-128].
 * @property payType Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
 * @property securityGroups The security group resource of the cluster.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId The id of the VPC.
 * @property vswitchId If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
 * @property zoneId The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
 */
public data class InstanceArgs(
    public val account: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val coldStorageSize: Output<Int>? = null,
    public val coreDiskSize: Output<Int>? = null,
    public val coreDiskType: Output<String>? = null,
    public val coreInstanceQuantity: Output<Int>? = null,
    public val coreInstanceType: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val duration: Output<Int>? = null,
    public val engine: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val immediateDeleteFlag: Output<Boolean>? = null,
    public val ipWhite: Output<String>? = null,
    public val maintainEndTime: Output<String>? = null,
    public val maintainStartTime: Output<String>? = null,
    public val masterInstanceType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
    public val payType: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbase.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.hbase.InstanceArgs =
        com.pulumi.alicloud.hbase.InstanceArgs.builder()
            .account(account?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .coldStorageSize(coldStorageSize?.applyValue({ args0 -> args0 }))
            .coreDiskSize(coreDiskSize?.applyValue({ args0 -> args0 }))
            .coreDiskType(coreDiskType?.applyValue({ args0 -> args0 }))
            .coreInstanceQuantity(coreInstanceQuantity?.applyValue({ args0 -> args0 }))
            .coreInstanceType(coreInstanceType?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .immediateDeleteFlag(immediateDeleteFlag?.applyValue({ args0 -> args0 }))
            .ipWhite(ipWhite?.applyValue({ args0 -> args0 }))
            .maintainEndTime(maintainEndTime?.applyValue({ args0 -> args0 }))
            .maintainStartTime(maintainStartTime?.applyValue({ args0 -> args0 }))
            .masterInstanceType(masterInstanceType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .payType(payType?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var account: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var coldStorageSize: Output<Int>? = null

    private var coreDiskSize: Output<Int>? = null

    private var coreDiskType: Output<String>? = null

    private var coreInstanceQuantity: Output<Int>? = null

    private var coreInstanceType: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var duration: Output<Int>? = null

    private var engine: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var immediateDeleteFlag: Output<Boolean>? = null

    private var ipWhite: Output<String>? = null

    private var maintainEndTime: Output<String>? = null

    private var maintainStartTime: Output<String>? = null

    private var masterInstanceType: Output<String>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var payType: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The account of the cluster web ui. Size [0-128].
     */
    @JvmName("xhkoayrwdyvajctq")
    public suspend fun account(`value`: Output<String>) {
        this.account = value
    }

    /**
     * @param value Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
     */
    @JvmName("pxrlbffwpfqwgylc")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value 0 or [800, 100000000], step:10-GB increments&#46; 0 means is_cold_storage = false&#46; [800, 100000000] means is_cold_storage = true.
     */
    @JvmName("nthtrljihqysxido")
    public suspend fun coldStorageSize(`value`: Output<Int>) {
        this.coldStorageSize = value
    }

    /**
     * @param value User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
     * - Custom storage space, value range: [20, 64000].
     * - Cluster [400, 64000], step:40-GB increments.
     * - Single [20-500GB], step:1-GB increments.
     */
    @JvmName("bpcgeuwlrmbhdluo")
    public suspend fun coreDiskSize(`value`: Output<Int>) {
        this.coreDiskSize = value
    }

    /**
     * @param value Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
     */
    @JvmName("hfapckuiqmrcpgjr")
    public suspend fun coreDiskType(`value`: Output<String>) {
        this.coreDiskType = value
    }

    /**
     * @param value Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
     */
    @JvmName("comssortknpfqgqe")
    public suspend fun coreInstanceQuantity(`value`: Output<Int>) {
        this.coreInstanceQuantity = value
    }

    /**
     * @param value Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
     */
    @JvmName("fjqtnmskftelsqrs")
    public suspend fun coreInstanceType(`value`: Output<String>) {
        this.coreInstanceType = value
    }

    /**
     * @param value The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
     */
    @JvmName("csecwnsjiaqqisgq")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
     */
    @JvmName("nbbvvowwtjbjsjew")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
     */
    @JvmName("wsnilqxsvxtifkya")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
     */
    @JvmName("hdkqpdhsrjsbsgsy")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
     */
    @JvmName("lplkedowtauajuaa")
    public suspend fun immediateDeleteFlag(`value`: Output<Boolean>) {
        this.immediateDeleteFlag = value
    }

    /**
     * @param value The white ip list of the cluster.
     */
    @JvmName("retpeovsldvyflxh")
    public suspend fun ipWhite(`value`: Output<String>) {
        this.ipWhite = value
    }

    /**
     * @param value The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
     */
    @JvmName("vnvflgphsoxsonmk")
    public suspend fun maintainEndTime(`value`: Output<String>) {
        this.maintainEndTime = value
    }

    /**
     * @param value The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
     */
    @JvmName("aiyqouphfkcrvkdk")
    public suspend fun maintainStartTime(`value`: Output<String>) {
        this.maintainStartTime = value
    }

    /**
     * @param value Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
     */
    @JvmName("qjbvudxyayiruxuu")
    public suspend fun masterInstanceType(`value`: Output<String>) {
        this.masterInstanceType = value
    }

    /**
     * @param value HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
     */
    @JvmName("aydfuusomykuqyea")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The password of the cluster web ui account. Size [0-128].
     */
    @JvmName("mwvonpibgemahpmw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
     */
    @JvmName("tqmtpsxwkkoknttt")
    public suspend fun payType(`value`: Output<String>) {
        this.payType = value
    }

    /**
     * @param value The security group resource of the cluster.
     */
    @JvmName("jkverlsrwebhuanv")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("xfibifftbcocndnf")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The security group resource of the cluster.
     */
    @JvmName("vbylcytsdlxywjot")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("fglkexyielanmtel")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("kinbhwpeuvsjbtuy")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
     */
    @JvmName("svtxlcgbminvgxip")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    @JvmName("bpaawinvqpmupimy")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The account of the cluster web ui. Size [0-128].
     */
    @JvmName("sqpiaygscsaktvnl")
    public suspend fun account(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.account = mapped
    }

    /**
     * @param value Valid values are `true`, `false`, system default to `false`, valid when pay_type = PrePaid.
     */
    @JvmName("bncyjafonypilnho")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value 0 or [800, 100000000], step:10-GB increments&#46; 0 means is_cold_storage = false&#46; [800, 100000000] means is_cold_storage = true.
     */
    @JvmName("vdgwgtbmqicsnbwh")
    public suspend fun coldStorageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coldStorageSize = mapped
    }

    /**
     * @param value User-defined HBase instance one core node's storage. Valid when engine=hbase/hbaseue. Bds engine no need core_disk_size, space.Unit: GB. Value range:
     * - Custom storage space, value range: [20, 64000].
     * - Cluster [400, 64000], step:40-GB increments.
     * - Single [20-500GB], step:1-GB increments.
     */
    @JvmName("kxbmbptosfciihuv")
    public suspend fun coreDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreDiskSize = mapped
    }

    /**
     * @param value Valid values are `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`，``, local_disk size is fixed. When engine=bds, no need to set disk type(or empty string).
     */
    @JvmName("gtcevrjpcdqaybmi")
    public suspend fun coreDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreDiskType = mapped
    }

    /**
     * @param value Default=2, [1-200]. If core_instance_quantity > 1, this is cluster's instance. If core_instance_quantity = 1, this is a single instance.
     */
    @JvmName("fnenkdrleigpfobo")
    public suspend fun coreInstanceQuantity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreInstanceQuantity = mapped
    }

    /**
     * @param value Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
     */
    @JvmName("kgkqxbegtpxuyjqq")
    public suspend fun coreInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreInstanceType = mapped
    }

    /**
     * @param value The switch of delete protection. True: delete protect, False: no delete protect. You must set false when you want to delete cluster.
     */
    @JvmName("vwchydchvgryugqq")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, valid when pay_type = PrePaid,  unit: month. 12, 24, 36 mean 1, 2, 3 years.
     */
    @JvmName("ulcdfbwhytlcldca")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Valid values are "hbase/hbaseue/bds". The following types are supported after v1.73.0: `hbaseue` and `bds`. Single hbase instance need to set engine=hbase, core_instance_quantity=1.
     */
    @JvmName("wnvabegprekpgnbo")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value HBase major version. hbase:1.1/2.0, hbaseue:2.0, bds:1.0, unsupport other engine temporarily. Value options can refer to the latest docs [CreateInstance](https://www.alibabacloud.com/help/en/data-lake-analytics/latest/createinstance).
     */
    @JvmName("itmvunuxoqfwpmgr")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The switch of delete immediate. True: delete immediate, False: delete delay. You will not found the cluster no matter set true or false.
     */
    @JvmName("musulyqwlboehcwf")
    public suspend fun immediateDeleteFlag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immediateDeleteFlag = mapped
    }

    /**
     * @param value The white ip list of the cluster.
     */
    @JvmName("okkmvscdepftuhto")
    public suspend fun ipWhite(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipWhite = mapped
    }

    /**
     * @param value The end time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 04:00Z.
     */
    @JvmName("gttreyunvncxojil")
    public suspend fun maintainEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainEndTime = mapped
    }

    /**
     * @param value The start time of the operation and maintenance time period of the instance, in the format of HH:mmZ (UTC time), for example 02:00Z.
     */
    @JvmName("meqoixxckdjgkayo")
    public suspend fun maintainStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainStartTime = mapped
    }

    /**
     * @param value Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/53532.html), or you can call describeInstanceType api.
     */
    @JvmName("qfijhqgemtvnymyk")
    public suspend fun masterInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterInstanceType = mapped
    }

    /**
     * @param value HBase instance name. Length must be 2-128 characters long. Only Chinese characters, English letters, numbers, period (.), underline (_), or dash (-) are permitted.
     */
    @JvmName("xswslueamapfgeno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The password of the cluster web ui account. Size [0-128].
     */
    @JvmName("praxpwvwvtyemvls")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, System default to `PostPaid`. You can also convert PostPaid to PrePaid. And support convert PrePaid to PostPaid from 1.115.0+.
     */
    @JvmName("hdewkioclfsqdrrw")
    public suspend fun payType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payType = mapped
    }

    /**
     * @param value The security group resource of the cluster.
     */
    @JvmName("gdaksotndwsnqxpn")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The security group resource of the cluster.
     */
    @JvmName("jfimsmefhacudydq")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("bvwcrvtcdyalyrsv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ntuviagatpccsohx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("liiwwwkocvhjtgis")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value If vswitch_id is not empty, that mean net_type = vpc and has a same region. If vswitch_id is empty, net_type=classic. Intl site not support classic network.
     */
    @JvmName("hfbrbdmrwrreengd")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the HBase instance. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    @JvmName("iduyqmuhbeakjebe")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        account = account,
        autoRenew = autoRenew,
        coldStorageSize = coldStorageSize,
        coreDiskSize = coreDiskSize,
        coreDiskType = coreDiskType,
        coreInstanceQuantity = coreInstanceQuantity,
        coreInstanceType = coreInstanceType,
        deletionProtection = deletionProtection,
        duration = duration,
        engine = engine,
        engineVersion = engineVersion,
        immediateDeleteFlag = immediateDeleteFlag,
        ipWhite = ipWhite,
        maintainEndTime = maintainEndTime,
        maintainStartTime = maintainStartTime,
        masterInstanceType = masterInstanceType,
        name = name,
        password = password,
        payType = payType,
        securityGroups = securityGroups,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
