@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin.inputs

import com.pulumi.alicloud.hbase.inputs.GetInstanceTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypes.
 * @property chargeType The charge type of create hbase cluster instance, `PrePaid` or `PostPaid`.
 * @property diskType The disk type, `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`.
 * @property engine The engine name, `singlehbase`, `hbase`, `hbaseue`, `bds`.
 * @property instanceType The hbase instance type of create hbase cluster instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property regionId The dest region id, default client region.
 * @property version The engine version, singlehbase/hbase=1.1/2.0, bds=1.0.
 * @property zoneId The zone id, belong to regionId.
 */
public data class GetInstanceTypesPlainArgs(
    public val chargeType: String? = null,
    public val diskType: String? = null,
    public val engine: String? = null,
    public val instanceType: String? = null,
    public val outputFile: String? = null,
    public val regionId: String? = null,
    public val version: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbase.inputs.GetInstanceTypesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbase.inputs.GetInstanceTypesPlainArgs =
        com.pulumi.alicloud.hbase.inputs.GetInstanceTypesPlainArgs.builder()
            .chargeType(chargeType?.let({ args0 -> args0 }))
            .diskType(diskType?.let({ args0 -> args0 }))
            .engine(engine?.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .regionId(regionId?.let({ args0 -> args0 }))
            .version(version?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceTypesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypesPlainArgsBuilder internal constructor() {
    private var chargeType: String? = null

    private var diskType: String? = null

    private var engine: String? = null

    private var instanceType: String? = null

    private var outputFile: String? = null

    private var regionId: String? = null

    private var version: String? = null

    private var zoneId: String? = null

    /**
     * @param value The charge type of create hbase cluster instance, `PrePaid` or `PostPaid`.
     */
    @JvmName("jsgdhlclttprsdkh")
    public suspend fun chargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.chargeType = mapped
    }

    /**
     * @param value The disk type, `cloud_ssd`, `cloud_essd_pl1`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`.
     */
    @JvmName("mmhqjsmvooiwcfvl")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskType = mapped
    }

    /**
     * @param value The engine name, `singlehbase`, `hbase`, `hbaseue`, `bds`.
     */
    @JvmName("enyklogdvqarykrk")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value The hbase instance type of create hbase cluster instance.
     */
    @JvmName("vvtmhnxgpqshcebw")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("akyryrhocxapqdkm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The dest region id, default client region.
     */
    @JvmName("fnbedjltmacbmkmr")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regionId = mapped
    }

    /**
     * @param value The engine version, singlehbase/hbase=1.1/2.0, bds=1.0.
     */
    @JvmName("ccpkcxrkgfwlnnpg")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    /**
     * @param value The zone id, belong to regionId.
     */
    @JvmName("vqgkommieroknnsh")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstanceTypesPlainArgs = GetInstanceTypesPlainArgs(
        chargeType = chargeType,
        diskType = diskType,
        engine = engine,
        instanceType = instanceType,
        outputFile = outputFile,
        regionId = regionId,
        version = version,
        zoneId = zoneId,
    )
}
