@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category Name of the category, single or cluster.
 * @property cpuSize Cpu size of the instance type.
 * @property engine The engine name, `singlehbase`, `hbase`, `hbaseue`, `bds`.
 * @property instanceType The hbase instance type of create hbase cluster instance.
 * @property maxCoreCount Max count of the core instance nodes.
 * @property memSize Mem size of the instance type.
 * @property storageType Name of the storage type.
 * @property version The engine version, singlehbase/hbase=1.1/2.0, bds=1.0.
 * @property zone Name of zone id.
 */
public data class GetInstanceTypesCoreInstanceType(
    public val category: String,
    public val cpuSize: Int,
    public val engine: String,
    public val instanceType: String,
    public val maxCoreCount: Int,
    public val memSize: Int,
    public val storageType: String,
    public val version: String,
    public val zone: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbase.outputs.GetInstanceTypesCoreInstanceType): GetInstanceTypesCoreInstanceType = GetInstanceTypesCoreInstanceType(
            category = javaType.category(),
            cpuSize = javaType.cpuSize(),
            engine = javaType.engine(),
            instanceType = javaType.instanceType(),
            maxCoreCount = javaType.maxCoreCount(),
            memSize = javaType.memSize(),
            storageType = javaType.storageType(),
            version = javaType.version(),
            zone = javaType.zone(),
        )
    }
}
