@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpuSize Cpu size of the instance type.
 * @property instanceType The hbase instance type of create hbase cluster instance.
 * @property memSize Mem size of the instance type.
 */
public data class GetInstanceTypesMasterInstanceType(
    public val cpuSize: Int,
    public val instanceType: String,
    public val memSize: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbase.outputs.GetInstanceTypesMasterInstanceType): GetInstanceTypesMasterInstanceType = GetInstanceTypesMasterInstanceType(
            cpuSize = javaType.cpuSize(),
            instanceType = javaType.instanceType(),
            memSize = javaType.memSize(),
        )
    }
}
