@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceTypes.
 * @property chargeType
 * @property coreInstanceTypes (Available in 1.115.0+) A list of core instance types. Each element contains the following attributes:
 * @property diskType
 * @property engine Name of the engine.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of instance types type IDs.
 * @property instanceType Name of the instance type.
 * @property masterInstanceTypes (Available in 1.115.0+) A list of master instance types. Each element contains the following attributes:
 * @property outputFile
 * @property regionId
 * @property types (Deprecated) A list of instance types. Each element contains the following attributes:
 * @property version The version of the engine.
 * @property zoneId
 */
public data class GetInstanceTypesResult(
    public val chargeType: String? = null,
    public val coreInstanceTypes: List<GetInstanceTypesCoreInstanceType>,
    public val diskType: String? = null,
    public val engine: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceType: String? = null,
    public val masterInstanceTypes: List<GetInstanceTypesMasterInstanceType>,
    public val outputFile: String? = null,
    public val regionId: String? = null,
    public val types: List<GetInstanceTypesType>,
    public val version: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbase.outputs.GetInstanceTypesResult): GetInstanceTypesResult = GetInstanceTypesResult(
            chargeType = javaType.chargeType().map({ args0 -> args0 }).orElse(null),
            coreInstanceTypes = javaType.coreInstanceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbase.kotlin.outputs.GetInstanceTypesCoreInstanceType.Companion.toKotlin(args0)
                })
            }),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            masterInstanceTypes = javaType.masterInstanceTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbase.kotlin.outputs.GetInstanceTypesMasterInstanceType.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            regionId = javaType.regionId().map({ args0 -> args0 }).orElse(null),
            types = javaType.types().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbase.kotlin.outputs.GetInstanceTypesType.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
