@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property backupStatus The Backup Status of the instance.
 * @property coreDiskSize Core node disk size, unit:GB.
 * @property coreDiskType Cloud_ssd or cloud_efficiency
 * @property coreInstanceType Like hbase.sn2.2xlarge, hbase.sn2.4xlarge, hbase.sn2.8xlarge and so on.
 * @property coreNodeCount Same with "core_instance_quantity"
 * @property createdTime The created time of the instance.
 * @property deletionProtection The switch of delete protection.
 * @property engine The engine of the instance.
 * @property engineVersion The engine_version of the instance.
 * @property expireTime The expire time of the instance.
 * @property id The ID of the HBase instance.
 * @property masterInstanceType Like hbase.sn2.2xlarge, hbase.sn2.4xlarge, hbase.sn2.8xlarge and so on.
 * @property masterNodeCount The node count of master
 * @property name The name of the HBase instance.
 * @property networkType Classic network or VPC.
 * @property payType Billing method. Value options are `PostPaid` for  Pay-As-You-Go and `PrePaid` for yearly or monthly subscription.
 * @property regionId Region ID the instance belongs to.
 * @property status Status of the instance.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId VPC ID the instance belongs to.
 * @property vswitchId VSwitch ID the instance belongs to.
 * @property zoneId Zone ID the instance belongs to.
 */
public data class GetInstancesInstance(
    public val backupStatus: String,
    public val coreDiskSize: Int,
    public val coreDiskType: String,
    public val coreInstanceType: String,
    public val coreNodeCount: Int,
    public val createdTime: String,
    public val deletionProtection: Boolean,
    public val engine: String,
    public val engineVersion: String,
    public val expireTime: String,
    public val id: String,
    public val masterInstanceType: String,
    public val masterNodeCount: Int,
    public val name: String,
    public val networkType: String,
    public val payType: String,
    public val regionId: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbase.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            backupStatus = javaType.backupStatus(),
            coreDiskSize = javaType.coreDiskSize(),
            coreDiskType = javaType.coreDiskType(),
            coreInstanceType = javaType.coreInstanceType(),
            coreNodeCount = javaType.coreNodeCount(),
            createdTime = javaType.createdTime(),
            deletionProtection = javaType.deletionProtection(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            masterInstanceType = javaType.masterInstanceType(),
            masterNodeCount = javaType.masterNodeCount(),
            name = javaType.name(),
            networkType = javaType.networkType(),
            payType = javaType.payType(),
            regionId = javaType.regionId(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
