@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstances.
 * @property availabilityZone
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids The ids list of HBase instances
 * @property instances A list of HBase instances. Its every element contains the following attributes:
 * @property nameRegex
 * @property names The names list of HBase instances
 * @property outputFile
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetInstancesResult(
    public val availabilityZone: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetInstancesInstance>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbase.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbase.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
