@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connAddr The Phoenix address.
 * @property connAddrPort The number of the port over which Phoenix connects to the instance.
 * @property netType The type of the network. Valid values:
 */
public data class InstanceZkConnAddr(
    public val connAddr: String? = null,
    public val connAddrPort: String? = null,
    public val netType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbase.outputs.InstanceZkConnAddr): InstanceZkConnAddr = InstanceZkConnAddr(
            connAddr = javaType.connAddr().map({ args0 -> args0 }).orElse(null),
            connAddrPort = javaType.connAddrPort().map({ args0 -> args0 }).orElse(null),
            netType = javaType.netType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
