@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HanaBackupClient].
 */
@PulumiTagMarker
public class HanaBackupClientResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HanaBackupClientArgs = HanaBackupClientArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HanaBackupClientArgsBuilder.() -> Unit) {
        val builder = HanaBackupClientArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HanaBackupClient {
        val builtJavaResource = com.pulumi.alicloud.hbr.HanaBackupClient(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HanaBackupClient(builtJavaResource)
    }
}

/**
 * Provides a Hybrid Backup Recovery (HBR) Hana Backup Client resource.
 * For information about Hybrid Backup Recovery (HBR) Hana Backup Client and how to use it, see [What is Hana Backup Client](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/api-hbr-2017-09-08-createclients).
 * > **NOTE:** Available in v1.198.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.getZones({
 *     availableResourceCreation: "Instance",
 * });
 * const exampleGetInstanceTypes = example.then(example => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: example.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const exampleGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_[0-9]+_[0-9]+_x64*",
 *     owners: "system",
 * });
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: "terraform-example",
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: exampleNetwork.id,
 *     zoneId: example.then(example => example.zones?.[0]?.id),
 * });
 * const exampleSecurityGroup = new alicloud.ecs.SecurityGroup("example", {
 *     name: "terraform-example",
 *     vpcId: exampleNetwork.id,
 * });
 * const exampleInstance = new alicloud.ecs.Instance("example", {
 *     imageId: exampleGetImages.then(exampleGetImages => exampleGetImages.images?.[0]?.id),
 *     instanceType: exampleGetInstanceTypes.then(exampleGetInstanceTypes => exampleGetInstanceTypes.instanceTypes?.[0]?.id),
 *     availabilityZone: example.then(example => example.zones?.[0]?.id),
 *     securityGroups: [exampleSecurityGroup&#46;id],
 *     instanceName: "terraform-example",
 *     internetChargeType: "PayByBandwidth",
 *     vswitchId: exampleSwitch.id,
 * });
 * const exampleGetResourceGroups = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const exampleVault = new alicloud.hbr.Vault("example", {vaultName: "terraform-example"});
 * const exampleHanaInstance = new alicloud.hbr.HanaInstance("example", {
 *     alertSetting: "INHERITED",
 *     hanaName: "terraform-example",
 *     host: "1.1.1.1",
 *     instanceNumber: 1,
 *     password: "YouPassword123",
 *     resourceGroupId: exampleGetResourceGroups.then(exampleGetResourceGroups => exampleGetResourceGroups.groups?.[0]?.id),
 *     sid: "HXE",
 *     useSsl: false,
 *     userName: "admin",
 *     validateCertificate: false,
 *     vaultId: exampleVault.id,
 * });
 * const _default = new alicloud.hbr.HanaBackupClient("default", {
 *     vaultId: exampleVault.id,
 *     clientInfo: pulumi.interpolate`[ { "instanceId": "${exampleInstance&#46;id}", "clusterId": "${exampleHanaInstance&#46;hanaInstanceId}", "sourceTypes": [ "HANA" ]  }]`,
 *     alertSetting: "INHERITED",
 *     useHttps: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.get_zones(available_resource_creation="Instance")
 * example_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=example.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
 *     owners="system")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name="terraform-example",
 *     cidr_block="172.17.3.0/24")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name="terraform-example",
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=example_network.id,
 *     zone_id=example.zones[0].id)
 * example_security_group = alicloud.ecs.SecurityGroup("example",
 *     name="terraform-example",
 *     vpc_id=example_network.id)
 * example_instance = alicloud.ecs.Instance("example",
 *     image_id=example_get_images.images[0].id,
 *     instance_type=example_get_instance_types.instance_types[0].id,
 *     availability_zone=example.zones[0].id,
 *     security_groups=[example_security_group&#46;id],
 *     instance_name="terraform-example",
 *     internet_charge_type="PayByBandwidth",
 *     vswitch_id=example_switch.id)
 * example_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
 * example_vault = alicloud.hbr.Vault("example", vault_name="terraform-example")
 * example_hana_instance = alicloud.hbr.HanaInstance("example",
 *     alert_setting="INHERITED",
 *     hana_name="terraform-example",
 *     host="1.1.1.1",
 *     instance_number=1,
 *     password="YouPassword123",
 *     resource_group_id=example_get_resource_groups.groups[0].id,
 *     sid="HXE",
 *     use_ssl=False,
 *     user_name="admin",
 *     validate_certificate=False,
 *     vault_id=example_vault.id)
 * default = alicloud.hbr.HanaBackupClient("default",
 *     vault_id=example_vault.id,
 *     client_info=pulumi.Output.all(
 *         id=example_instance.id,
 *         hana_instance_id=example_hana_instance.hana_instance_id
 * ).apply(lambda resolved_outputs: f"[ {{ \"instanceId\": \"{resolved_outputs['id']}\", \"clusterId\": \"{resolved_outputs['hana_instance_id']}\", \"sourceTypes\": [ \"HANA\" ]  }}]")
 * ,
 *     alert_setting="INHERITED",
 *     use_https=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "Instance",
 *     });
 *     var exampleGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var exampleGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_[0-9]+_[0-9]+_x64*",
 *         Owners = "system",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = "terraform-example",
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = exampleNetwork.Id,
 *         ZoneId = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var exampleSecurityGroup = new AliCloud.Ecs.SecurityGroup("example", new()
 *     {
 *         Name = "terraform-example",
 *         VpcId = exampleNetwork.Id,
 *     });
 *     var exampleInstance = new AliCloud.Ecs.Instance("example", new()
 *     {
 *         ImageId = exampleGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = exampleGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         AvailabilityZone = example.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         SecurityGroups = new[]
 *         {
 *             exampleSecurityGroup.Id,
 *         },
 *         InstanceName = "terraform-example",
 *         InternetChargeType = "PayByBandwidth",
 *         VswitchId = exampleSwitch.Id,
 *     });
 *     var exampleGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var exampleVault = new AliCloud.Hbr.Vault("example", new()
 *     {
 *         VaultName = "terraform-example",
 *     });
 *     var exampleHanaInstance = new AliCloud.Hbr.HanaInstance("example", new()
 *     {
 *         AlertSetting = "INHERITED",
 *         HanaName = "terraform-example",
 *         Host = "1.1.1.1",
 *         InstanceNumber = 1,
 *         Password = "YouPassword123",
 *         ResourceGroupId = exampleGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *         Sid = "HXE",
 *         UseSsl = false,
 *         UserName = "admin",
 *         ValidateCertificate = false,
 *         VaultId = exampleVault.Id,
 *     });
 *     var @default = new AliCloud.Hbr.HanaBackupClient("default", new()
 *     {
 *         VaultId = exampleVault.Id,
 *         ClientInfo = Output.Tuple(exampleInstance.Id, exampleHanaInstance.HanaInstanceId).Apply(values =>
 *         {
 *             var id = values.Item1;
 *             var hanaInstanceId = values.Item2;
 *             return $"[ {{ \"instanceId\": \"{id}\", \"clusterId\": \"{hanaInstanceId}\", \"sourceTypes\": [ \"HANA\" ]  }}]";
 *         }),
 *         AlertSetting = "INHERITED",
 *         UseHttps = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("Instance"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(example.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(1),
 * 			MemorySize:       pulumi.Float64Ref(2),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ubuntu_[0-9]+_[0-9]+_x64*"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String("terraform-example"),
 * 			CidrBlock:   pulumi.String("172.17.3.0/24"),
 * 			VpcId:       exampleNetwork.ID(),
 * 			ZoneId:      pulumi.String(example.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSecurityGroup, err := ecs.NewSecurityGroup(ctx, "example", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String("terraform-example"),
 * 			VpcId: exampleNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := ecs.NewInstance(ctx, "example", &ecs.InstanceArgs{
 * 			ImageId:          pulumi.String(exampleGetImages.Images[0].Id),
 * 			InstanceType:     pulumi.String(exampleGetInstanceTypes.InstanceTypes[0].Id),
 * 			AvailabilityZone: pulumi.String(example.Zones[0].Id),
 * 			SecurityGroups: pulumi.StringArray{
 * 				exampleSecurityGroup.ID(),
 * 			},
 * 			InstanceName:       pulumi.String("terraform-example"),
 * 			InternetChargeType: pulumi.String("PayByBandwidth"),
 * 			VswitchId:          exampleSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVault, err := hbr.NewVault(ctx, "example", &hbr.VaultArgs{
 * 			VaultName: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleHanaInstance, err := hbr.NewHanaInstance(ctx, "example", &hbr.HanaInstanceArgs{
 * 			AlertSetting:        pulumi.String("INHERITED"),
 * 			HanaName:            pulumi.String("terraform-example"),
 * 			Host:                pulumi.String("1.1.1.1"),
 * 			InstanceNumber:      pulumi.Int(1),
 * 			Password:            pulumi.String("YouPassword123"),
 * 			ResourceGroupId:     pulumi.String(exampleGetResourceGroups.Groups[0].Id),
 * 			Sid:                 pulumi.String("HXE"),
 * 			UseSsl:              pulumi.Bool(false),
 * 			UserName:            pulumi.String("admin"),
 * 			ValidateCertificate: pulumi.Bool(false),
 * 			VaultId:             exampleVault.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewHanaBackupClient(ctx, "default", &hbr.HanaBackupClientArgs{
 * 			VaultId: exampleVault.ID(),
 * 			ClientInfo: pulumi.All(exampleInstance.ID(), exampleHanaInstance.HanaInstanceId).ApplyT(func(_args []interface{}) (string, error) {
 * 				id := _args[0].(string)
 * 				hanaInstanceId := _args[1].(string)
 * 				return fmt.Sprintf("[ { \"instanceId\": \"%v\", \"clusterId\": \"%v\", \"sourceTypes\": [ \"HANA\" ]  }]", id, hanaInstanceId), nil
 * 			}).(pulumi.StringOutput),
 * 			AlertSetting: pulumi.String("INHERITED"),
 * 			UseHttps:     pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.hbr.HanaInstance;
 * import com.pulumi.alicloud.hbr.HanaInstanceArgs;
 * import com.pulumi.alicloud.hbr.HanaBackupClient;
 * import com.pulumi.alicloud.hbr.HanaBackupClientArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("Instance")
 *             .build());
 *         final var exampleGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var exampleGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_[0-9]+_[0-9]+_x64*")
 *             .owners("system")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName("terraform-example")
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(exampleNetwork.id())
 *             .zoneId(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup", SecurityGroupArgs.builder()
 *             .name("terraform-example")
 *             .vpcId(exampleNetwork.id())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .imageId(exampleGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(exampleGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .availabilityZone(example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .securityGroups(exampleSecurityGroup.id())
 *             .instanceName("terraform-example")
 *             .internetChargeType("PayByBandwidth")
 *             .vswitchId(exampleSwitch.id())
 *             .build());
 *         final var exampleGetResourceGroups = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var exampleVault = new Vault("exampleVault", VaultArgs.builder()
 *             .vaultName("terraform-example")
 *             .build());
 *         var exampleHanaInstance = new HanaInstance("exampleHanaInstance", HanaInstanceArgs.builder()
 *             .alertSetting("INHERITED")
 *             .hanaName("terraform-example")
 *             .host("1.1.1.1")
 *             .instanceNumber(1)
 *             .password("YouPassword123")
 *             .resourceGroupId(exampleGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .sid("HXE")
 *             .useSsl(false)
 *             .userName("admin")
 *             .validateCertificate(false)
 *             .vaultId(exampleVault.id())
 *             .build());
 *         var default_ = new HanaBackupClient("default", HanaBackupClientArgs.builder()
 *             .vaultId(exampleVault.id())
 *             .clientInfo(Output.tuple(exampleInstance.id(), exampleHanaInstance.hanaInstanceId()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var hanaInstanceId = values.t2;
 *                 return String.format("[ {{ \"instanceId\": \"%s\", \"clusterId\": \"%s\", \"sourceTypes\": [ \"HANA\" ]  }}]", id,hanaInstanceId);
 *             }))
 *             .alertSetting("INHERITED")
 *             .useHttps(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: terraform-example
 *       cidrBlock: 172.17.3.0/24
 *       vpcId: ${exampleNetwork.id}
 *       zoneId: ${example.zones[0].id}
 *   exampleSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: example
 *     properties:
 *       name: terraform-example
 *       vpcId: ${exampleNetwork.id}
 *   exampleInstance:
 *     type: alicloud:ecs:Instance
 *     name: example
 *     properties:
 *       imageId: ${exampleGetImages.images[0].id}
 *       instanceType: ${exampleGetInstanceTypes.instanceTypes[0].id}
 *       availabilityZone: ${example.zones[0].id}
 *       securityGroups:
 *         - ${exampleSecurityGroup.id}
 *       instanceName: terraform-example
 *       internetChargeType: PayByBandwidth
 *       vswitchId: ${exampleSwitch.id}
 *   exampleVault:
 *     type: alicloud:hbr:Vault
 *     name: example
 *     properties:
 *       vaultName: terraform-example
 *   exampleHanaInstance:
 *     type: alicloud:hbr:HanaInstance
 *     name: example
 *     properties:
 *       alertSetting: INHERITED
 *       hanaName: terraform-example
 *       host: 1.1.1.1
 *       instanceNumber: 1
 *       password: YouPassword123
 *       resourceGroupId: ${exampleGetResourceGroups.groups[0].id}
 *       sid: HXE
 *       useSsl: false
 *       userName: admin
 *       validateCertificate: false
 *       vaultId: ${exampleVault.id}
 *   default:
 *     type: alicloud:hbr:HanaBackupClient
 *     properties:
 *       vaultId: ${exampleVault.id}
 *       clientInfo: '[ { "instanceId": "${exampleInstance&#46;id}", "clusterId": "${exampleHanaInstance&#46;hanaInstanceId}", "sourceTypes": [ "HANA" ]  }]'
 *       alertSetting: INHERITED
 *       useHttps: true
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: Instance
 *   exampleGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${example.zones[0].id}
 *         cpuCoreCount: 1
 *         memorySize: 2
 *   exampleGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_[0-9]+_[0-9]+_x64*
 *         owners: system
 *   exampleGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Hybrid Backup Recovery (HBR) Hana Backup Client can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/hanaBackupClient:HanaBackupClient example <vault_id>:<client_id>
 * ```
 */
public class HanaBackupClient internal constructor(
    override val javaResource: com.pulumi.alicloud.hbr.HanaBackupClient,
) : KotlinCustomResource(javaResource, HanaBackupClientMapper) {
    /**
     * The alert settings. Valid value: `INHERITED`.
     */
    public val alertSetting: Output<String>
        get() = javaResource.alertSetting().applyValue({ args0 -> args0 })

    /**
     * The ID of the backup client.
     */
    public val clientId: Output<String>
        get() = javaResource.clientId().applyValue({ args0 -> args0 })

    /**
     * The installation information of the HBR clients.
     */
    public val clientInfo: Output<String>?
        get() = javaResource.clientInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the SAP HANA instance.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The status of the Hana Backup Client.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to transmit data over HTTPS. Valid values: `true`, `false`.
     */
    public val useHttps: Output<Boolean>?
        get() = javaResource.useHttps().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the backup vault.
     */
    public val vaultId: Output<String>
        get() = javaResource.vaultId().applyValue({ args0 -> args0 })
}

public object HanaBackupClientMapper : ResourceMapper<HanaBackupClient> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.hbr.HanaBackupClient::class == javaResource::class

    override fun map(javaResource: Resource): HanaBackupClient = HanaBackupClient(
        javaResource as
            com.pulumi.alicloud.hbr.HanaBackupClient,
    )
}

/**
 * @see [HanaBackupClient].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HanaBackupClient].
 */
public suspend fun hanaBackupClient(
    name: String,
    block: suspend HanaBackupClientResourceBuilder.() -> Unit,
): HanaBackupClient {
    val builder = HanaBackupClientResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HanaBackupClient].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hanaBackupClient(name: String): HanaBackupClient {
    val builder = HanaBackupClientResourceBuilder()
    builder.name(name)
    return builder.build()
}
