@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.HanaBackupPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Hybrid Backup Recovery (HBR) Hana Backup Plan resource.
 * For information about Hybrid Backup Recovery (HBR) Hana Backup Plan and how to use it, see [What is Hana Backup Plan](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/api-hbr-2017-09-08-createhanabackupplan).
 * > **NOTE:** Available in v1.179.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const example = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const exampleVault = new alicloud.hbr.Vault("example", {vaultName: `terraform-example-${_default.result}`});
 * const exampleHanaInstance = new alicloud.hbr.HanaInstance("example", {
 *     alertSetting: "INHERITED",
 *     hanaName: `terraform-example-${_default.result}`,
 *     host: "1.1.1.1",
 *     instanceNumber: 1,
 *     password: "YouPassword123",
 *     resourceGroupId: example.then(example => example.groups?.[0]?.id),
 *     sid: "HXE",
 *     useSsl: false,
 *     userName: "admin",
 *     validateCertificate: false,
 *     vaultId: exampleVault.id,
 * });
 * const exampleHanaBackupPlan = new alicloud.hbr.HanaBackupPlan("example", {
 *     backupPrefix: "DIFF_DATA_BACKUP",
 *     backupType: "COMPLETE",
 *     clusterId: exampleHanaInstance.hanaInstanceId,
 *     databaseName: "SYSTEMDB",
 *     planName: "terraform-example",
 *     resourceGroupId: example.then(example => example.groups?.[0]?.id),
 *     schedule: "I|1602673264|P1D",
 *     vaultId: exampleHanaInstance.vaultId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * example = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example_vault = alicloud.hbr.Vault("example", vault_name=f"terraform-example-{default['result']}")
 * example_hana_instance = alicloud.hbr.HanaInstance("example",
 *     alert_setting="INHERITED",
 *     hana_name=f"terraform-example-{default['result']}",
 *     host="1.1.1.1",
 *     instance_number=1,
 *     password="YouPassword123",
 *     resource_group_id=example.groups[0].id,
 *     sid="HXE",
 *     use_ssl=False,
 *     user_name="admin",
 *     validate_certificate=False,
 *     vault_id=example_vault.id)
 * example_hana_backup_plan = alicloud.hbr.HanaBackupPlan("example",
 *     backup_prefix="DIFF_DATA_BACKUP",
 *     backup_type="COMPLETE",
 *     cluster_id=example_hana_instance.hana_instance_id,
 *     database_name="SYSTEMDB",
 *     plan_name="terraform-example",
 *     resource_group_id=example.groups[0].id,
 *     schedule="I|1602673264|P1D",
 *     vault_id=example_hana_instance.vault_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var exampleVault = new AliCloud.Hbr.Vault("example", new()
 *     {
 *         VaultName = $"terraform-example-{@default.Result}",
 *     });
 *     var exampleHanaInstance = new AliCloud.Hbr.HanaInstance("example", new()
 *     {
 *         AlertSetting = "INHERITED",
 *         HanaName = $"terraform-example-{@default.Result}",
 *         Host = "1.1.1.1",
 *         InstanceNumber = 1,
 *         Password = "YouPassword123",
 *         ResourceGroupId = example.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *         Sid = "HXE",
 *         UseSsl = false,
 *         UserName = "admin",
 *         ValidateCertificate = false,
 *         VaultId = exampleVault.Id,
 *     });
 *     var exampleHanaBackupPlan = new AliCloud.Hbr.HanaBackupPlan("example", new()
 *     {
 *         BackupPrefix = "DIFF_DATA_BACKUP",
 *         BackupType = "COMPLETE",
 *         ClusterId = exampleHanaInstance.HanaInstanceId,
 *         DatabaseName = "SYSTEMDB",
 *         PlanName = "terraform-example",
 *         ResourceGroupId = example.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *         Schedule = "I|1602673264|P1D",
 *         VaultId = exampleHanaInstance.VaultId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVault, err := hbr.NewVault(ctx, "example", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleHanaInstance, err := hbr.NewHanaInstance(ctx, "example", &hbr.HanaInstanceArgs{
 * 			AlertSetting:        pulumi.String("INHERITED"),
 * 			HanaName:            pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Host:                pulumi.String("1.1.1.1"),
 * 			InstanceNumber:      pulumi.Int(1),
 * 			Password:            pulumi.String("YouPassword123"),
 * 			ResourceGroupId:     pulumi.String(example.Groups[0].Id),
 * 			Sid:                 pulumi.String("HXE"),
 * 			UseSsl:              pulumi.Bool(false),
 * 			UserName:            pulumi.String("admin"),
 * 			ValidateCertificate: pulumi.Bool(false),
 * 			VaultId:             exampleVault.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewHanaBackupPlan(ctx, "example", &hbr.HanaBackupPlanArgs{
 * 			BackupPrefix:    pulumi.String("DIFF_DATA_BACKUP"),
 * 			BackupType:      pulumi.String("COMPLETE"),
 * 			ClusterId:       exampleHanaInstance.HanaInstanceId,
 * 			DatabaseName:    pulumi.String("SYSTEMDB"),
 * 			PlanName:        pulumi.String("terraform-example"),
 * 			ResourceGroupId: pulumi.String(example.Groups[0].Id),
 * 			Schedule:        pulumi.String("I|1602673264|P1D"),
 * 			VaultId:         exampleHanaInstance.VaultId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.hbr.HanaInstance;
 * import com.pulumi.alicloud.hbr.HanaInstanceArgs;
 * import com.pulumi.alicloud.hbr.HanaBackupPlan;
 * import com.pulumi.alicloud.hbr.HanaBackupPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var exampleVault = new Vault("exampleVault", VaultArgs.builder()
 *             .vaultName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var exampleHanaInstance = new HanaInstance("exampleHanaInstance", HanaInstanceArgs.builder()
 *             .alertSetting("INHERITED")
 *             .hanaName(String.format("terraform-example-%s", default_.result()))
 *             .host("1.1.1.1")
 *             .instanceNumber(1)
 *             .password("YouPassword123")
 *             .resourceGroupId(example.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .sid("HXE")
 *             .useSsl(false)
 *             .userName("admin")
 *             .validateCertificate(false)
 *             .vaultId(exampleVault.id())
 *             .build());
 *         var exampleHanaBackupPlan = new HanaBackupPlan("exampleHanaBackupPlan", HanaBackupPlanArgs.builder()
 *             .backupPrefix("DIFF_DATA_BACKUP")
 *             .backupType("COMPLETE")
 *             .clusterId(exampleHanaInstance.hanaInstanceId())
 *             .databaseName("SYSTEMDB")
 *             .planName("terraform-example")
 *             .resourceGroupId(example.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .schedule("I|1602673264|P1D")
 *             .vaultId(exampleHanaInstance.vaultId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleVault:
 *     type: alicloud:hbr:Vault
 *     name: example
 *     properties:
 *       vaultName: terraform-example-${default.result}
 *   exampleHanaInstance:
 *     type: alicloud:hbr:HanaInstance
 *     name: example
 *     properties:
 *       alertSetting: INHERITED
 *       hanaName: terraform-example-${default.result}
 *       host: 1.1.1.1
 *       instanceNumber: 1
 *       password: YouPassword123
 *       resourceGroupId: ${example.groups[0].id}
 *       sid: HXE
 *       useSsl: false
 *       userName: admin
 *       validateCertificate: false
 *       vaultId: ${exampleVault.id}
 *   exampleHanaBackupPlan:
 *     type: alicloud:hbr:HanaBackupPlan
 *     name: example
 *     properties:
 *       backupPrefix: DIFF_DATA_BACKUP
 *       backupType: COMPLETE
 *       clusterId: ${exampleHanaInstance.hanaInstanceId}
 *       databaseName: SYSTEMDB
 *       planName: terraform-example
 *       resourceGroupId: ${example.groups[0].id}
 *       schedule: I|1602673264|P1D
 *       vaultId: ${exampleHanaInstance.vaultId}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Hybrid Backup Recovery (HBR) Hana Backup Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/hanaBackupPlan:HanaBackupPlan example <plan_id>:<vault_id>:<cluster_id>
 * ```
 * @property backupPrefix The backup prefix.
 * @property backupType The backup type. Valid values:
 * - `COMPLETE`: full backup.
 * - `INCREMENTAL`: incremental backup.
 * - `DIFFERENTIAL`: differential backup.
 * @property clusterId The ID of the SAP HANA instance.
 * @property databaseName The name of the database.
 * @property planName The name of the backup plan.
 * @property resourceGroupId The resource attribute field that represents the resource group ID.
 * @property schedule The backup policy. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is completed. For example, I|1631685600|P1D specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.
 * @property status The status of the resource. Valid values: `Enabled`, `Disabled`.
 * @property vaultId The ID of the backup vault.
 */
public data class HanaBackupPlanArgs(
    public val backupPrefix: Output<String>? = null,
    public val backupType: Output<String>? = null,
    public val clusterId: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val planName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val schedule: Output<String>? = null,
    public val status: Output<String>? = null,
    public val vaultId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.HanaBackupPlanArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.HanaBackupPlanArgs =
        com.pulumi.alicloud.hbr.HanaBackupPlanArgs.builder()
            .backupPrefix(backupPrefix?.applyValue({ args0 -> args0 }))
            .backupType(backupType?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .planName(planName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .vaultId(vaultId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HanaBackupPlanArgs].
 */
@PulumiTagMarker
public class HanaBackupPlanArgsBuilder internal constructor() {
    private var backupPrefix: Output<String>? = null

    private var backupType: Output<String>? = null

    private var clusterId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var planName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var schedule: Output<String>? = null

    private var status: Output<String>? = null

    private var vaultId: Output<String>? = null

    /**
     * @param value The backup prefix.
     */
    @JvmName("nbmyaasaclncrswx")
    public suspend fun backupPrefix(`value`: Output<String>) {
        this.backupPrefix = value
    }

    /**
     * @param value The backup type. Valid values:
     * - `COMPLETE`: full backup.
     * - `INCREMENTAL`: incremental backup.
     * - `DIFFERENTIAL`: differential backup.
     */
    @JvmName("grnwqfwxidgwqnvs")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value The ID of the SAP HANA instance.
     */
    @JvmName("fkkyerwlfwqqjxxi")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("oceystbjclgtgluo")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the backup plan.
     */
    @JvmName("lnfwkcjccwisyfbv")
    public suspend fun planName(`value`: Output<String>) {
        this.planName = value
    }

    /**
     * @param value The resource attribute field that represents the resource group ID.
     */
    @JvmName("dbqcxoyvpppswdou")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The backup policy. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is completed. For example, I|1631685600|P1D specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.
     */
    @JvmName("gbnvoqbodxkeokwy")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The status of the resource. Valid values: `Enabled`, `Disabled`.
     */
    @JvmName("cysspoglhlrykjyi")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of the backup vault.
     */
    @JvmName("qbudqmxwqmaumjcb")
    public suspend fun vaultId(`value`: Output<String>) {
        this.vaultId = value
    }

    /**
     * @param value The backup prefix.
     */
    @JvmName("cktljymivghobweq")
    public suspend fun backupPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPrefix = mapped
    }

    /**
     * @param value The backup type. Valid values:
     * - `COMPLETE`: full backup.
     * - `INCREMENTAL`: incremental backup.
     * - `DIFFERENTIAL`: differential backup.
     */
    @JvmName("mmmaqtgushtchbxx")
    public suspend fun backupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value The ID of the SAP HANA instance.
     */
    @JvmName("cirujhjppoqfgmqc")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("ylegrvwgfyntfwcp")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the backup plan.
     */
    @JvmName("ippduutexmqpinre")
    public suspend fun planName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planName = mapped
    }

    /**
     * @param value The resource attribute field that represents the resource group ID.
     */
    @JvmName("knhbdylmfephscad")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The backup policy. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is completed. For example, I|1631685600|P1D specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.
     */
    @JvmName("cwijlhacvscvfxed")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Enabled`, `Disabled`.
     */
    @JvmName("npeenigxpivvhmdp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The ID of the backup vault.
     */
    @JvmName("odauhdybtaupcgre")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultId = mapped
    }

    internal fun build(): HanaBackupPlanArgs = HanaBackupPlanArgs(
        backupPrefix = backupPrefix,
        backupType = backupType,
        clusterId = clusterId,
        databaseName = databaseName,
        planName = planName,
        resourceGroupId = resourceGroupId,
        schedule = schedule,
        status = status,
        vaultId = vaultId,
    )
}
