@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [HanaInstance].
 */
@PulumiTagMarker
public class HanaInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HanaInstanceArgs = HanaInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HanaInstanceArgsBuilder.() -> Unit) {
        val builder = HanaInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HanaInstance {
        val builtJavaResource = com.pulumi.alicloud.hbr.HanaInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HanaInstance(builtJavaResource)
    }
}

/**
 * Provides a Hybrid Backup Recovery (HBR) Hana Instance resource.
 * For information about Hybrid Backup Recovery (HBR) Hana Instance and how to use it, see [What is Hana Instance](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/api-hbr-2017-09-08-createhanainstance).
 * > **NOTE:** Available in v1.178.0+.
 * > **NOTE:** The `sid` attribute is required when destroying resources.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const example = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const exampleVault = new alicloud.hbr.Vault("example", {vaultName: `terraform-example-${_default.result}`});
 * const exampleHanaInstance = new alicloud.hbr.HanaInstance("example", {
 *     alertSetting: "INHERITED",
 *     hanaName: `terraform-example-${_default.result}`,
 *     host: "1.1.1.1",
 *     instanceNumber: 1,
 *     password: "YouPassword123",
 *     resourceGroupId: example.then(example => example.groups?.[0]?.id),
 *     sid: "HXE",
 *     useSsl: false,
 *     userName: "admin",
 *     validateCertificate: false,
 *     vaultId: exampleVault.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * example = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example_vault = alicloud.hbr.Vault("example", vault_name=f"terraform-example-{default['result']}")
 * example_hana_instance = alicloud.hbr.HanaInstance("example",
 *     alert_setting="INHERITED",
 *     hana_name=f"terraform-example-{default['result']}",
 *     host="1.1.1.1",
 *     instance_number=1,
 *     password="YouPassword123",
 *     resource_group_id=example.groups[0].id,
 *     sid="HXE",
 *     use_ssl=False,
 *     user_name="admin",
 *     validate_certificate=False,
 *     vault_id=example_vault.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var exampleVault = new AliCloud.Hbr.Vault("example", new()
 *     {
 *         VaultName = $"terraform-example-{@default.Result}",
 *     });
 *     var exampleHanaInstance = new AliCloud.Hbr.HanaInstance("example", new()
 *     {
 *         AlertSetting = "INHERITED",
 *         HanaName = $"terraform-example-{@default.Result}",
 *         Host = "1.1.1.1",
 *         InstanceNumber = 1,
 *         Password = "YouPassword123",
 *         ResourceGroupId = example.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *         Sid = "HXE",
 *         UseSsl = false,
 *         UserName = "admin",
 *         ValidateCertificate = false,
 *         VaultId = exampleVault.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVault, err := hbr.NewVault(ctx, "example", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewHanaInstance(ctx, "example", &hbr.HanaInstanceArgs{
 * 			AlertSetting:        pulumi.String("INHERITED"),
 * 			HanaName:            pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Host:                pulumi.String("1.1.1.1"),
 * 			InstanceNumber:      pulumi.Int(1),
 * 			Password:            pulumi.String("YouPassword123"),
 * 			ResourceGroupId:     pulumi.String(example.Groups[0].Id),
 * 			Sid:                 pulumi.String("HXE"),
 * 			UseSsl:              pulumi.Bool(false),
 * 			UserName:            pulumi.String("admin"),
 * 			ValidateCertificate: pulumi.Bool(false),
 * 			VaultId:             exampleVault.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.hbr.HanaInstance;
 * import com.pulumi.alicloud.hbr.HanaInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var exampleVault = new Vault("exampleVault", VaultArgs.builder()
 *             .vaultName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var exampleHanaInstance = new HanaInstance("exampleHanaInstance", HanaInstanceArgs.builder()
 *             .alertSetting("INHERITED")
 *             .hanaName(String.format("terraform-example-%s", default_.result()))
 *             .host("1.1.1.1")
 *             .instanceNumber(1)
 *             .password("YouPassword123")
 *             .resourceGroupId(example.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .sid("HXE")
 *             .useSsl(false)
 *             .userName("admin")
 *             .validateCertificate(false)
 *             .vaultId(exampleVault.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleVault:
 *     type: alicloud:hbr:Vault
 *     name: example
 *     properties:
 *       vaultName: terraform-example-${default.result}
 *   exampleHanaInstance:
 *     type: alicloud:hbr:HanaInstance
 *     name: example
 *     properties:
 *       alertSetting: INHERITED
 *       hanaName: terraform-example-${default.result}
 *       host: 1.1.1.1
 *       instanceNumber: 1
 *       password: YouPassword123
 *       resourceGroupId: ${example.groups[0].id}
 *       sid: HXE
 *       useSsl: false
 *       userName: admin
 *       validateCertificate: false
 *       vaultId: ${exampleVault.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Hybrid Backup Recovery (HBR) Hana Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/hanaInstance:HanaInstance example <vault_id>:<hana_instance_id>
 * ```
 */
public class HanaInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.hbr.HanaInstance,
) : KotlinCustomResource(javaResource, HanaInstanceMapper) {
    /**
     * The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
     */
    public val alertSetting: Output<String>
        get() = javaResource.alertSetting().applyValue({ args0 -> args0 })

    /**
     * The IDs of ECS instances that host the SAP HANA instance to be registered. HBR installs backup clients on the specified ECS instances.
     */
    public val ecsInstanceIds: Output<List<String>>?
        get() = javaResource.ecsInstanceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The id of the Hana Instance.
     */
    public val hanaInstanceId: Output<String>
        get() = javaResource.hanaInstanceId().applyValue({ args0 -> args0 })

    /**
     * The name of the SAP HANA instance.
     */
    public val hanaName: Output<String>?
        get() = javaResource.hanaName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
     */
    public val host: Output<String>?
        get() = javaResource.host().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The instance number of the SAP HANA system.
     */
    public val instanceNumber: Output<Int>?
        get() = javaResource.instanceNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password that is used to connect with the SAP HANA database.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The security identifier (SID) of the SAP HANA database.
     */
    public val sid: Output<String>?
        get() = javaResource.sid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to connect with the SAP HANA database over Secure Sockets Layer (SSL).
     */
    public val useSsl: Output<Boolean>?
        get() = javaResource.useSsl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The username of the SYSTEMDB database.
     */
    public val userName: Output<String>?
        get() = javaResource.userName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to verify the SSL certificate of the SAP HANA database.
     */
    public val validateCertificate: Output<Boolean>?
        get() = javaResource.validateCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the backup vault.
     */
    public val vaultId: Output<String>
        get() = javaResource.vaultId().applyValue({ args0 -> args0 })
}

public object HanaInstanceMapper : ResourceMapper<HanaInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.hbr.HanaInstance::class == javaResource::class

    override fun map(javaResource: Resource): HanaInstance = HanaInstance(
        javaResource as
            com.pulumi.alicloud.hbr.HanaInstance,
    )
}

/**
 * @see [HanaInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HanaInstance].
 */
public suspend fun hanaInstance(
    name: String,
    block: suspend HanaInstanceResourceBuilder.() -> Unit,
): HanaInstance {
    val builder = HanaInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HanaInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hanaInstance(name: String): HanaInstance {
    val builder = HanaInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
