@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.HanaInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Hybrid Backup Recovery (HBR) Hana Instance resource.
 * For information about Hybrid Backup Recovery (HBR) Hana Instance and how to use it, see [What is Hana Instance](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/api-hbr-2017-09-08-createhanainstance).
 * > **NOTE:** Available in v1.178.0+.
 * > **NOTE:** The `sid` attribute is required when destroying resources.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const example = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const exampleVault = new alicloud.hbr.Vault("example", {vaultName: `terraform-example-${_default.result}`});
 * const exampleHanaInstance = new alicloud.hbr.HanaInstance("example", {
 *     alertSetting: "INHERITED",
 *     hanaName: `terraform-example-${_default.result}`,
 *     host: "1.1.1.1",
 *     instanceNumber: 1,
 *     password: "YouPassword123",
 *     resourceGroupId: example.then(example => example.groups?.[0]?.id),
 *     sid: "HXE",
 *     useSsl: false,
 *     userName: "admin",
 *     validateCertificate: false,
 *     vaultId: exampleVault.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * example = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example_vault = alicloud.hbr.Vault("example", vault_name=f"terraform-example-{default['result']}")
 * example_hana_instance = alicloud.hbr.HanaInstance("example",
 *     alert_setting="INHERITED",
 *     hana_name=f"terraform-example-{default['result']}",
 *     host="1.1.1.1",
 *     instance_number=1,
 *     password="YouPassword123",
 *     resource_group_id=example.groups[0].id,
 *     sid="HXE",
 *     use_ssl=False,
 *     user_name="admin",
 *     validate_certificate=False,
 *     vault_id=example_vault.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var exampleVault = new AliCloud.Hbr.Vault("example", new()
 *     {
 *         VaultName = $"terraform-example-{@default.Result}",
 *     });
 *     var exampleHanaInstance = new AliCloud.Hbr.HanaInstance("example", new()
 *     {
 *         AlertSetting = "INHERITED",
 *         HanaName = $"terraform-example-{@default.Result}",
 *         Host = "1.1.1.1",
 *         InstanceNumber = 1,
 *         Password = "YouPassword123",
 *         ResourceGroupId = example.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *         Sid = "HXE",
 *         UseSsl = false,
 *         UserName = "admin",
 *         ValidateCertificate = false,
 *         VaultId = exampleVault.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVault, err := hbr.NewVault(ctx, "example", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewHanaInstance(ctx, "example", &hbr.HanaInstanceArgs{
 * 			AlertSetting:        pulumi.String("INHERITED"),
 * 			HanaName:            pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Host:                pulumi.String("1.1.1.1"),
 * 			InstanceNumber:      pulumi.Int(1),
 * 			Password:            pulumi.String("YouPassword123"),
 * 			ResourceGroupId:     pulumi.String(example.Groups[0].Id),
 * 			Sid:                 pulumi.String("HXE"),
 * 			UseSsl:              pulumi.Bool(false),
 * 			UserName:            pulumi.String("admin"),
 * 			ValidateCertificate: pulumi.Bool(false),
 * 			VaultId:             exampleVault.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.hbr.HanaInstance;
 * import com.pulumi.alicloud.hbr.HanaInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var exampleVault = new Vault("exampleVault", VaultArgs.builder()
 *             .vaultName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var exampleHanaInstance = new HanaInstance("exampleHanaInstance", HanaInstanceArgs.builder()
 *             .alertSetting("INHERITED")
 *             .hanaName(String.format("terraform-example-%s", default_.result()))
 *             .host("1.1.1.1")
 *             .instanceNumber(1)
 *             .password("YouPassword123")
 *             .resourceGroupId(example.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .sid("HXE")
 *             .useSsl(false)
 *             .userName("admin")
 *             .validateCertificate(false)
 *             .vaultId(exampleVault.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleVault:
 *     type: alicloud:hbr:Vault
 *     name: example
 *     properties:
 *       vaultName: terraform-example-${default.result}
 *   exampleHanaInstance:
 *     type: alicloud:hbr:HanaInstance
 *     name: example
 *     properties:
 *       alertSetting: INHERITED
 *       hanaName: terraform-example-${default.result}
 *       host: 1.1.1.1
 *       instanceNumber: 1
 *       password: YouPassword123
 *       resourceGroupId: ${example.groups[0].id}
 *       sid: HXE
 *       useSsl: false
 *       userName: admin
 *       validateCertificate: false
 *       vaultId: ${exampleVault.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Hybrid Backup Recovery (HBR) Hana Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/hanaInstance:HanaInstance example <vault_id>:<hana_instance_id>
 * ```
 * @property alertSetting The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
 * @property ecsInstanceIds The IDs of ECS instances that host the SAP HANA instance to be registered. HBR installs backup clients on the specified ECS instances.
 * @property hanaName The name of the SAP HANA instance.
 * @property host The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
 * @property instanceNumber The instance number of the SAP HANA system.
 * @property password The password that is used to connect with the SAP HANA database.
 * @property resourceGroupId The ID of the resource group.
 * @property sid The security identifier (SID) of the SAP HANA database.
 * @property useSsl Specifies whether to connect with the SAP HANA database over Secure Sockets Layer (SSL).
 * @property userName The username of the SYSTEMDB database.
 * @property validateCertificate Specifies whether to verify the SSL certificate of the SAP HANA database.
 * @property vaultId The ID of the backup vault.
 */
public data class HanaInstanceArgs(
    public val alertSetting: Output<String>? = null,
    public val ecsInstanceIds: Output<List<String>>? = null,
    public val hanaName: Output<String>? = null,
    public val host: Output<String>? = null,
    public val instanceNumber: Output<Int>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val sid: Output<String>? = null,
    public val useSsl: Output<Boolean>? = null,
    public val userName: Output<String>? = null,
    public val validateCertificate: Output<Boolean>? = null,
    public val vaultId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.HanaInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.HanaInstanceArgs =
        com.pulumi.alicloud.hbr.HanaInstanceArgs.builder()
            .alertSetting(alertSetting?.applyValue({ args0 -> args0 }))
            .ecsInstanceIds(ecsInstanceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .hanaName(hanaName?.applyValue({ args0 -> args0 }))
            .host(host?.applyValue({ args0 -> args0 }))
            .instanceNumber(instanceNumber?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .sid(sid?.applyValue({ args0 -> args0 }))
            .useSsl(useSsl?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .validateCertificate(validateCertificate?.applyValue({ args0 -> args0 }))
            .vaultId(vaultId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HanaInstanceArgs].
 */
@PulumiTagMarker
public class HanaInstanceArgsBuilder internal constructor() {
    private var alertSetting: Output<String>? = null

    private var ecsInstanceIds: Output<List<String>>? = null

    private var hanaName: Output<String>? = null

    private var host: Output<String>? = null

    private var instanceNumber: Output<Int>? = null

    private var password: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var sid: Output<String>? = null

    private var useSsl: Output<Boolean>? = null

    private var userName: Output<String>? = null

    private var validateCertificate: Output<Boolean>? = null

    private var vaultId: Output<String>? = null

    /**
     * @param value The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
     */
    @JvmName("dxuuxgkvphjpnsvd")
    public suspend fun alertSetting(`value`: Output<String>) {
        this.alertSetting = value
    }

    /**
     * @param value The IDs of ECS instances that host the SAP HANA instance to be registered. HBR installs backup clients on the specified ECS instances.
     */
    @JvmName("nppoiqelvfoayrxl")
    public suspend fun ecsInstanceIds(`value`: Output<List<String>>) {
        this.ecsInstanceIds = value
    }

    @JvmName("hlwdguphaipbwwrf")
    public suspend fun ecsInstanceIds(vararg values: Output<String>) {
        this.ecsInstanceIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of ECS instances that host the SAP HANA instance to be registered. HBR installs backup clients on the specified ECS instances.
     */
    @JvmName("vkigrgyfrysysnoq")
    public suspend fun ecsInstanceIds(values: List<Output<String>>) {
        this.ecsInstanceIds = Output.all(values)
    }

    /**
     * @param value The name of the SAP HANA instance.
     */
    @JvmName("opmgfabijkalsllv")
    public suspend fun hanaName(`value`: Output<String>) {
        this.hanaName = value
    }

    /**
     * @param value The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
     */
    @JvmName("fuitlajalfwkvpsy")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The instance number of the SAP HANA system.
     */
    @JvmName("kwucyspovnjkboha")
    public suspend fun instanceNumber(`value`: Output<Int>) {
        this.instanceNumber = value
    }

    /**
     * @param value The password that is used to connect with the SAP HANA database.
     */
    @JvmName("aykmdmguqewfxpqc")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("hlvilruvnebiayhx")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The security identifier (SID) of the SAP HANA database.
     */
    @JvmName("rnjdguafijpdsphn")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Specifies whether to connect with the SAP HANA database over Secure Sockets Layer (SSL).
     */
    @JvmName("mckgbclvjejsqlmk")
    public suspend fun useSsl(`value`: Output<Boolean>) {
        this.useSsl = value
    }

    /**
     * @param value The username of the SYSTEMDB database.
     */
    @JvmName("vvulyojnvlakolie")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Specifies whether to verify the SSL certificate of the SAP HANA database.
     */
    @JvmName("qaqxigpianfffubj")
    public suspend fun validateCertificate(`value`: Output<Boolean>) {
        this.validateCertificate = value
    }

    /**
     * @param value The ID of the backup vault.
     */
    @JvmName("vwejaphtecrlcste")
    public suspend fun vaultId(`value`: Output<String>) {
        this.vaultId = value
    }

    /**
     * @param value The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
     */
    @JvmName("kjgjvcfuiptspvaq")
    public suspend fun alertSetting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertSetting = mapped
    }

    /**
     * @param value The IDs of ECS instances that host the SAP HANA instance to be registered. HBR installs backup clients on the specified ECS instances.
     */
    @JvmName("vqtamwvgmsdjbdni")
    public suspend fun ecsInstanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsInstanceIds = mapped
    }

    /**
     * @param values The IDs of ECS instances that host the SAP HANA instance to be registered. HBR installs backup clients on the specified ECS instances.
     */
    @JvmName("ijhjabopccelehci")
    public suspend fun ecsInstanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ecsInstanceIds = mapped
    }

    /**
     * @param value The name of the SAP HANA instance.
     */
    @JvmName("ubmccefyxtdwlswo")
    public suspend fun hanaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hanaName = mapped
    }

    /**
     * @param value The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
     */
    @JvmName("apxjrpvijfraevcr")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The instance number of the SAP HANA system.
     */
    @JvmName("fuklcvkintxpybat")
    public suspend fun instanceNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceNumber = mapped
    }

    /**
     * @param value The password that is used to connect with the SAP HANA database.
     */
    @JvmName("uaqfobosslnlllmk")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("elorsucesvxgbceg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The security identifier (SID) of the SAP HANA database.
     */
    @JvmName("hpcxfswwoydfykrs")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Specifies whether to connect with the SAP HANA database over Secure Sockets Layer (SSL).
     */
    @JvmName("uabcxoxkltspjtek")
    public suspend fun useSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSsl = mapped
    }

    /**
     * @param value The username of the SYSTEMDB database.
     */
    @JvmName("wvreowbsmeskywvl")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value Specifies whether to verify the SSL certificate of the SAP HANA database.
     */
    @JvmName("nglbpnyhdjlqbihu")
    public suspend fun validateCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateCertificate = mapped
    }

    /**
     * @param value The ID of the backup vault.
     */
    @JvmName("ijkqntsbcpsjedys")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultId = mapped
    }

    internal fun build(): HanaInstanceArgs = HanaInstanceArgs(
        alertSetting = alertSetting,
        ecsInstanceIds = ecsInstanceIds,
        hanaName = hanaName,
        host = host,
        instanceNumber = instanceNumber,
        password = password,
        resourceGroupId = resourceGroupId,
        sid = sid,
        useSsl = useSsl,
        userName = userName,
        validateCertificate = validateCertificate,
        vaultId = vaultId,
    )
}
