@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.HbrFunctions.getBackupJobsPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getEcsBackupClientsPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getEcsBackupPlansPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getHanaBackupClientsPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getHanaBackupPlansPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getHanaInstancesPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getNasBackupPlansPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getOssBackupPlansPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getOtsBackupPlansPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getOtsSnapshotsPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getReplicationVaultRegionsPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getRestoreJobsPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getServerBackupPlansPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getServicePlain
import com.pulumi.alicloud.hbr.HbrFunctions.getSnapshotsPlain
import com.pulumi.alicloud.hbr.HbrFunctions.getVaultsPlain
import com.pulumi.alicloud.hbr.kotlin.inputs.GetBackupJobsFilter
import com.pulumi.alicloud.hbr.kotlin.inputs.GetBackupJobsPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetBackupJobsPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetEcsBackupClientsPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetEcsBackupClientsPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetEcsBackupPlansPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetEcsBackupPlansPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetHanaBackupClientsPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetHanaBackupClientsPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetHanaBackupPlansPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetHanaBackupPlansPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetHanaInstancesPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetHanaInstancesPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetNasBackupPlansPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetNasBackupPlansPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetOssBackupPlansPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetOssBackupPlansPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetOtsBackupPlansPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetOtsBackupPlansPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetOtsSnapshotsPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetOtsSnapshotsPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetReplicationVaultRegionsPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetReplicationVaultRegionsPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetRestoreJobsPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetRestoreJobsPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetServerBackupPlansFilter
import com.pulumi.alicloud.hbr.kotlin.inputs.GetServerBackupPlansPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetServerBackupPlansPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetSnapshotsPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetSnapshotsPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.GetVaultsPlainArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.GetVaultsPlainArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.outputs.GetBackupJobsResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetEcsBackupClientsResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetEcsBackupPlansResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetHanaBackupClientsResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetHanaBackupPlansResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetHanaInstancesResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetNasBackupPlansResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetOssBackupPlansResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetOtsBackupPlansResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetOtsSnapshotsResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetReplicationVaultRegionsResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetRestoreJobsResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetServerBackupPlansResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetSnapshotsResult
import com.pulumi.alicloud.hbr.kotlin.outputs.GetVaultsResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.hbr.kotlin.outputs.GetBackupJobsResult.Companion.toKotlin as getBackupJobsResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetEcsBackupClientsResult.Companion.toKotlin as getEcsBackupClientsResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetEcsBackupPlansResult.Companion.toKotlin as getEcsBackupPlansResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetHanaBackupClientsResult.Companion.toKotlin as getHanaBackupClientsResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetHanaBackupPlansResult.Companion.toKotlin as getHanaBackupPlansResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetHanaInstancesResult.Companion.toKotlin as getHanaInstancesResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetNasBackupPlansResult.Companion.toKotlin as getNasBackupPlansResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetOssBackupPlansResult.Companion.toKotlin as getOssBackupPlansResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetOtsBackupPlansResult.Companion.toKotlin as getOtsBackupPlansResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetOtsSnapshotsResult.Companion.toKotlin as getOtsSnapshotsResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetReplicationVaultRegionsResult.Companion.toKotlin as getReplicationVaultRegionsResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetRestoreJobsResult.Companion.toKotlin as getRestoreJobsResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetServerBackupPlansResult.Companion.toKotlin as getServerBackupPlansResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetSnapshotsResult.Companion.toKotlin as getSnapshotsResultToKotlin
import com.pulumi.alicloud.hbr.kotlin.outputs.GetVaultsResult.Companion.toKotlin as getVaultsResultToKotlin

public object HbrFunctions {
    /**
     * This data source provides the Hbr Backup Jobs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.138.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.hbr.getEcsBackupPlans({
     *     nameRegex: "plan-name",
     * });
     * const defaultGetBackupJobs = Promise.all([_default, _default])&#46;then(([_default, _default1]) => alicloud.hbr.getBackupJobs({
     *     sourceType: "ECS_FILE",
     *     filters: [
     *         {
     *             key: "VaultId",
     *             operator: "IN",
     *             values: [_default&#46;plans?&#46;[0]?&#46;vaultId],
     *         },
     *         {
     *             key: "InstanceId",
     *             operator: "IN",
     *             values: [_default1&#46;plans?&#46;[0]?&#46;instanceId],
     *         },
     *         {
     *             key: "CompleteTime",
     *             operator: "BETWEEN",
     *             values: [
     *                 "2021-08-23T14:17:15CST",
     *                 "2021-08-24T14:17:15CST",
     *             ],
     *         },
     *     ],
     * }));
     * const example = Promise.all([_default, _default])&#46;then(([_default, _default1]) => alicloud.hbr.getBackupJobs({
     *     sourceType: "ECS_FILE",
     *     status: "COMPLETE",
     *     filters: [
     *         {
     *             key: "VaultId",
     *             operator: "IN",
     *             values: [_default&#46;plans?&#46;[0]?&#46;vaultId],
     *         },
     *         {
     *             key: "InstanceId",
     *             operator: "IN",
     *             values: [_default1&#46;plans?&#46;[0]?&#46;instanceId],
     *         },
     *         {
     *             key: "CompleteTime",
     *             operator: "LESS_THAN",
     *             values: ["2021-10-20T20:20:20CST"],
     *         },
     *     ],
     * }));
     * export const alicloudHbrBackupJobsDefault1 = defaultGetBackupJobs.then(defaultGetBackupJobs => defaultGetBackupJobs.jobs?.[0]?.id);
     * export const alicloudHbrBackupJobsExample1 = example.then(example => example.jobs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-name")
     * default_get_backup_jobs = alicloud.hbr.get_backup_jobs(source_type="ECS_FILE",
     *     filters=[
     *         {
     *             "key": "VaultId",
     *             "operator": "IN",
     *             "values": [default&#46;plans[0]&#46;vault_id],
     *         },
     *         {
     *             "key": "InstanceId",
     *             "operator": "IN",
     *             "values": [default&#46;plans[0]&#46;instance_id],
     *         },
     *         {
     *             "key": "CompleteTime",
     *             "operator": "BETWEEN",
     *             "values": [
     *                 "2021-08-23T14:17:15CST",
     *                 "2021-08-24T14:17:15CST",
     *             ],
     *         },
     *     ])
     * example = alicloud.hbr.get_backup_jobs(source_type="ECS_FILE",
     *     status="COMPLETE",
     *     filters=[
     *         {
     *             "key": "VaultId",
     *             "operator": "IN",
     *             "values": [default&#46;plans[0]&#46;vault_id],
     *         },
     *         {
     *             "key": "InstanceId",
     *             "operator": "IN",
     *             "values": [default&#46;plans[0]&#46;instance_id],
     *         },
     *         {
     *             "key": "CompleteTime",
     *             "operator": "LESS_THAN",
     *             "values": ["2021-10-20T20:20:20CST"],
     *         },
     *     ])
     * pulumi.export("alicloudHbrBackupJobsDefault1", default_get_backup_jobs.jobs[0].id)
     * pulumi.export("alicloudHbrBackupJobsExample1", example.jobs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Hbr.GetEcsBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "plan-name",
     *     });
     *     var defaultGetBackupJobs = AliCloud.Hbr.GetBackupJobs.Invoke(new()
     *     {
     *         SourceType = "ECS_FILE",
     *         Filters = new[]
     *         {
     *             new AliCloud.Hbr.Inputs.GetBackupJobsFilterInputArgs
     *             {
     *                 Key = "VaultId",
     *                 Operator = "IN",
     *                 Values = new[]
     *                 {
     *                     @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.VaultId),
     *                 },
     *             },
     *             new AliCloud.Hbr.Inputs.GetBackupJobsFilterInputArgs
     *             {
     *                 Key = "InstanceId",
     *                 Operator = "IN",
     *                 Values = new[]
     *                 {
     *                     @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.InstanceId),
     *                 },
     *             },
     *             new AliCloud.Hbr.Inputs.GetBackupJobsFilterInputArgs
     *             {
     *                 Key = "CompleteTime",
     *                 Operator = "BETWEEN",
     *                 Values = new[]
     *                 {
     *                     "2021-08-23T14:17:15CST",
     *                     "2021-08-24T14:17:15CST",
     *                 },
     *             },
     *         },
     *     });
     *     var example = AliCloud.Hbr.GetBackupJobs.Invoke(new()
     *     {
     *         SourceType = "ECS_FILE",
     *         Status = "COMPLETE",
     *         Filters = new[]
     *         {
     *             new AliCloud.Hbr.Inputs.GetBackupJobsFilterInputArgs
     *             {
     *                 Key = "VaultId",
     *                 Operator = "IN",
     *                 Values = new[]
     *                 {
     *                     @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.VaultId),
     *                 },
     *             },
     *             new AliCloud.Hbr.Inputs.GetBackupJobsFilterInputArgs
     *             {
     *                 Key = "InstanceId",
     *                 Operator = "IN",
     *                 Values = new[]
     *                 {
     *                     @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.InstanceId),
     *                 },
     *             },
     *             new AliCloud.Hbr.Inputs.GetBackupJobsFilterInputArgs
     *             {
     *                 Key = "CompleteTime",
     *                 Operator = "LESS_THAN",
     *                 Values = new[]
     *                 {
     *                     "2021-10-20T20:20:20CST",
     *                 },
     *             },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudHbrBackupJobsDefault1"] = defaultGetBackupJobs&#46;Apply(getBackupJobsResult => getBackupJobsResult&#46;Jobs[0]?.Id),
     *         ["alicloudHbrBackupJobsExample1"] = example&#46;Apply(getBackupJobsResult => getBackupJobsResult&#46;Jobs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := hbr.GetEcsBackupPlans(ctx, &hbr.GetEcsBackupPlansArgs{
     * NameRegex: pulumi.StringRef("plan-name"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * defaultGetBackupJobs, err := hbr.GetBackupJobs(ctx, &hbr.GetBackupJobsArgs{
     * SourceType: "ECS_FILE",
     * Filters: []hbr.GetBackupJobsFilter{
     * {
     * Key: pulumi.StringRef("VaultId"),
     * Operator: pulumi.StringRef("IN"),
     * Values: interface{}{
     * _default.Plans[0].VaultId,
     * },
     * },
     * {
     * Key: pulumi.StringRef("InstanceId"),
     * Operator: pulumi.StringRef("IN"),
     * Values: interface{}{
     * _default.Plans[0].InstanceId,
     * },
     * },
     * {
     * Key: pulumi.StringRef("CompleteTime"),
     * Operator: pulumi.StringRef("BETWEEN"),
     * Values: []string{
     * "2021-08-23T14:17:15CST",
     * "2021-08-24T14:17:15CST",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * example, err := hbr.GetBackupJobs(ctx, &hbr.GetBackupJobsArgs{
     * SourceType: "ECS_FILE",
     * Status: pulumi.StringRef("COMPLETE"),
     * Filters: []hbr.GetBackupJobsFilter{
     * {
     * Key: pulumi.StringRef("VaultId"),
     * Operator: pulumi.StringRef("IN"),
     * Values: interface{}{
     * _default.Plans[0].VaultId,
     * },
     * },
     * {
     * Key: pulumi.StringRef("InstanceId"),
     * Operator: pulumi.StringRef("IN"),
     * Values: interface{}{
     * _default.Plans[0].InstanceId,
     * },
     * },
     * {
     * Key: pulumi.StringRef("CompleteTime"),
     * Operator: pulumi.StringRef("LESS_THAN"),
     * Values: []string{
     * "2021-10-20T20:20:20CST",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudHbrBackupJobsDefault1", defaultGetBackupJobs.Jobs[0].Id)
     * ctx.Export("alicloudHbrBackupJobsExample1", example.Jobs[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansArgs;
     * import com.pulumi.alicloud.hbr.inputs.GetBackupJobsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = HbrFunctions.getEcsBackupPlans(GetEcsBackupPlansArgs.builder()
     *             .nameRegex("plan-name")
     *             .build());
     *         final var defaultGetBackupJobs = HbrFunctions.getBackupJobs(GetBackupJobsArgs.builder()
     *             .sourceType("ECS_FILE")
     *             .filters(
     *                 GetBackupJobsFilterArgs.builder()
     *                     .key("VaultId")
     *                     .operator("IN")
     *                     .values(default_.plans()[0].vaultId())
     *                     .build(),
     *                 GetBackupJobsFilterArgs.builder()
     *                     .key("InstanceId")
     *                     .operator("IN")
     *                     .values(default_.plans()[0].instanceId())
     *                     .build(),
     *                 GetBackupJobsFilterArgs.builder()
     *                     .key("CompleteTime")
     *                     .operator("BETWEEN")
     *                     .values(
     *                         "2021-08-23T14:17:15CST",
     *                         "2021-08-24T14:17:15CST")
     *                     .build())
     *             .build());
     *         final var example = HbrFunctions.getBackupJobs(GetBackupJobsArgs.builder()
     *             .sourceType("ECS_FILE")
     *             .status("COMPLETE")
     *             .filters(
     *                 GetBackupJobsFilterArgs.builder()
     *                     .key("VaultId")
     *                     .operator("IN")
     *                     .values(default_.plans()[0].vaultId())
     *                     .build(),
     *                 GetBackupJobsFilterArgs.builder()
     *                     .key("InstanceId")
     *                     .operator("IN")
     *                     .values(default_.plans()[0].instanceId())
     *                     .build(),
     *                 GetBackupJobsFilterArgs.builder()
     *                     .key("CompleteTime")
     *                     .operator("LESS_THAN")
     *                     .values("2021-10-20T20:20:20CST")
     *                     .build())
     *             .build());
     *         ctx.export("alicloudHbrBackupJobsDefault1", defaultGetBackupJobs.applyValue(getBackupJobsResult -> getBackupJobsResult.jobs()[0].id()));
     *         ctx.export("alicloudHbrBackupJobsExample1", example.applyValue(getBackupJobsResult -> getBackupJobsResult.jobs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:hbr:getEcsBackupPlans
     *       Arguments:
     *         nameRegex: plan-name
     *   defaultGetBackupJobs:
     *     fn::invoke:
     *       Function: alicloud:hbr:getBackupJobs
     *       Arguments:
     *         sourceType: ECS_FILE
     *         filters:
     *           - key: VaultId
     *             operator: IN
     *             values:
     *               - ${default.plans[0].vaultId}
     *           - key: InstanceId
     *             operator: IN
     *             values:
     *               - ${default.plans[0].instanceId}
     *           - key: CompleteTime
     *             operator: BETWEEN
     *             values:
     *               - 2021-08-23T14:17:15CST
     *               - 2021-08-24T14:17:15CST
     *   example:
     *     fn::invoke:
     *       Function: alicloud:hbr:getBackupJobs
     *       Arguments:
     *         sourceType: ECS_FILE
     *         status: COMPLETE
     *         filters:
     *           - key: VaultId
     *             operator: IN
     *             values:
     *               - ${default.plans[0].vaultId}
     *           - key: InstanceId
     *             operator: IN
     *             values:
     *               - ${default.plans[0].instanceId}
     *           - key: CompleteTime
     *             operator: LESS_THAN
     *             values:
     *               - 2021-10-20T20:20:20CST
     * outputs:
     *   alicloudHbrBackupJobsDefault1: ${defaultGetBackupJobs.jobs[0].id}
     *   alicloudHbrBackupJobsExample1: ${example.jobs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBackupJobs.
     * @return A collection of values returned by getBackupJobs.
     */
    public suspend fun getBackupJobs(argument: GetBackupJobsPlainArgs): GetBackupJobsResult =
        getBackupJobsResultToKotlin(getBackupJobsPlain(argument.toJava()).await())

    /**
     * @see [getBackupJobs].
     * @param filters
     * @param ids A list of Backup Job IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param sortDirection The sort direction, sort results by ascending or descending order based on the value jobs id. Valid values: `ASCEND`, `DESCEND`.
     * @param sourceType The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS`, `UDM_ECS`, `UDM_ECS_DISK`.
     * @param status The status of backup job. Valid values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`, `UNAVAILABLE`.
     * @return A collection of values returned by getBackupJobs.
     */
    public suspend fun getBackupJobs(
        filters: List<GetBackupJobsFilter>? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        sortDirection: String? = null,
        sourceType: String,
        status: String? = null,
    ): GetBackupJobsResult {
        val argument = GetBackupJobsPlainArgs(
            filters = filters,
            ids = ids,
            outputFile = outputFile,
            sortDirection = sortDirection,
            sourceType = sourceType,
            status = status,
        )
        return getBackupJobsResultToKotlin(getBackupJobsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupJobs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetBackupJobsPlainArgs].
     * @return A collection of values returned by getBackupJobs.
     */
    public suspend fun getBackupJobs(argument: suspend GetBackupJobsPlainArgsBuilder.() -> Unit): GetBackupJobsResult {
        val builder = GetBackupJobsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupJobsResultToKotlin(getBackupJobsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr Ecs File Backup Clients of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ecs.getInstances({
     *     nameRegex: "ecs_instance_name",
     *     status: "Running",
     * });
     * const ids = alicloud.hbr.getEcsBackupClients({
     *     ids: [defaultAlicloudHbrEcsBackupClient&#46;id],
     *     instanceIds: [defaultAlicloudHbrEcsBackupClient&#46;instanceId],
     * });
     * export const hbrEcsBackupClientId1 = ids.then(ids => ids.clients?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ecs.get_instances(name_regex="ecs_instance_name",
     *     status="Running")
     * ids = alicloud.hbr.get_ecs_backup_clients(ids=[default_alicloud_hbr_ecs_backup_client["id"]],
     *     instance_ids=[default_alicloud_hbr_ecs_backup_client["instanceId"]])
     * pulumi.export("hbrEcsBackupClientId1", ids.clients[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ecs.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "ecs_instance_name",
     *         Status = "Running",
     *     });
     *     var ids = AliCloud.Hbr.GetEcsBackupClients.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudHbrEcsBackupClient.Id,
     *         },
     *         InstanceIds = new[]
     *         {
     *             defaultAlicloudHbrEcsBackupClient.InstanceId,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrEcsBackupClientId1"] = ids&#46;Apply(getEcsBackupClientsResult => getEcsBackupClientsResult&#46;Clients[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := ecs.GetInstances(ctx, &ecs.GetInstancesArgs{
     * NameRegex: pulumi.StringRef("ecs_instance_name"),
     * Status: pulumi.StringRef("Running"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ids, err := hbr.GetEcsBackupClients(ctx, &hbr.GetEcsBackupClientsArgs{
     * Ids: interface{}{
     * defaultAlicloudHbrEcsBackupClient.Id,
     * },
     * InstanceIds: interface{}{
     * defaultAlicloudHbrEcsBackupClient.InstanceId,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("hbrEcsBackupClientId1", ids.Clients[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetEcsBackupClientsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EcsFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("ecs_instance_name")
     *             .status("Running")
     *             .build());
     *         final var ids = HbrFunctions.getEcsBackupClients(GetEcsBackupClientsArgs.builder()
     *             .ids(defaultAlicloudHbrEcsBackupClient.id())
     *             .instanceIds(defaultAlicloudHbrEcsBackupClient.instanceId())
     *             .build());
     *         ctx.export("hbrEcsBackupClientId1", ids.applyValue(getEcsBackupClientsResult -> getEcsBackupClientsResult.clients()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ecs:getInstances
     *       Arguments:
     *         nameRegex: ecs_instance_name
     *         status: Running
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getEcsBackupClients
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudHbrEcsBackupClient.id}
     *         instanceIds:
     *           - ${defaultAlicloudHbrEcsBackupClient.instanceId}
     * outputs:
     *   hbrEcsBackupClientId1: ${ids.clients[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsBackupClients.
     * @return A collection of values returned by getEcsBackupClients.
     */
    public suspend fun getEcsBackupClients(argument: GetEcsBackupClientsPlainArgs): GetEcsBackupClientsResult =
        getEcsBackupClientsResultToKotlin(getEcsBackupClientsPlain(argument.toJava()).await())

    /**
     * @see [getEcsBackupClients].
     * @param ids A list of Ecs Backup Client IDs.
     * @param instanceIds A list of ECS Instance IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `REGISTERED`, `STOPPED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `UNKNOWN`, `UPGRADE_FAILED`, `UPGRADING`.
     * @return A collection of values returned by getEcsBackupClients.
     */
    public suspend fun getEcsBackupClients(
        ids: List<String>? = null,
        instanceIds: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetEcsBackupClientsResult {
        val argument = GetEcsBackupClientsPlainArgs(
            ids = ids,
            instanceIds = instanceIds,
            outputFile = outputFile,
            status = status,
        )
        return getEcsBackupClientsResultToKotlin(getEcsBackupClientsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsBackupClients].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetEcsBackupClientsPlainArgs].
     * @return A collection of values returned by getEcsBackupClients.
     */
    public suspend fun getEcsBackupClients(argument: suspend GetEcsBackupClientsPlainArgsBuilder.() -> Unit): GetEcsBackupClientsResult {
        val builder = GetEcsBackupClientsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsBackupClientsResultToKotlin(getEcsBackupClientsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr EcsBackupPlans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.hbr.getEcsBackupPlans({
     *     nameRegex: "plan-name",
     * });
     * export const hbrEcsBackupPlanId = ids.then(ids => ids.plans?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-name")
     * pulumi.export("hbrEcsBackupPlanId", ids.plans[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Hbr.GetEcsBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "plan-name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrEcsBackupPlanId"] = ids&#46;Apply(getEcsBackupPlansResult => getEcsBackupPlansResult&#46;Plans[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := hbr.GetEcsBackupPlans(ctx, &hbr.GetEcsBackupPlansArgs{
     * 			NameRegex: pulumi.StringRef("plan-name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrEcsBackupPlanId", ids.Plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = HbrFunctions.getEcsBackupPlans(GetEcsBackupPlansArgs.builder()
     *             .nameRegex("plan-name")
     *             .build());
     *         ctx.export("hbrEcsBackupPlanId", ids.applyValue(getEcsBackupPlansResult -> getEcsBackupPlansResult.plans()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getEcsBackupPlans
     *       Arguments:
     *         nameRegex: plan-name
     * outputs:
     *   hbrEcsBackupPlanId: ${ids.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEcsBackupPlans.
     * @return A collection of values returned by getEcsBackupPlans.
     */
    public suspend fun getEcsBackupPlans(argument: GetEcsBackupPlansPlainArgs): GetEcsBackupPlansResult =
        getEcsBackupPlansResultToKotlin(getEcsBackupPlansPlain(argument.toJava()).await())

    /**
     * @see [getEcsBackupPlans].
     * @param ids A list of EcsBackupPlan IDs.
     * @param instanceId The ECS instance ID of the EcsBackupPlan used.
     * @param nameRegex A regex string to filter results by EcsBackupPlan name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param vaultId The Vault ID of the EcsBackupPlan used.
     * @return A collection of values returned by getEcsBackupPlans.
     */
    public suspend fun getEcsBackupPlans(
        ids: List<String>? = null,
        instanceId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        vaultId: String? = null,
    ): GetEcsBackupPlansResult {
        val argument = GetEcsBackupPlansPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            vaultId = vaultId,
        )
        return getEcsBackupPlansResultToKotlin(getEcsBackupPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getEcsBackupPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetEcsBackupPlansPlainArgs].
     * @return A collection of values returned by getEcsBackupPlans.
     */
    public suspend fun getEcsBackupPlans(argument: suspend GetEcsBackupPlansPlainArgsBuilder.() -> Unit): GetEcsBackupPlansResult {
        val builder = GetEcsBackupPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEcsBackupPlansResultToKotlin(getEcsBackupPlansPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hybrid Backup Recovery (HBR) Hana Backup Clients of the current Alibaba Cloud user.
     * > **NOTE:** Available in 1.198.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.hbr.getHanaBackupClients({
     *     ids: ["example_id"],
     *     vaultId: "your_vault_id",
     * });
     * export const hbrHanaBackupClientsId1 = ids.then(ids => ids.hanaBackupClients?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.hbr.get_hana_backup_clients(ids=["example_id"],
     *     vault_id="your_vault_id")
     * pulumi.export("hbrHanaBackupClientsId1", ids.hana_backup_clients[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Hbr.GetHanaBackupClients.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         VaultId = "your_vault_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrHanaBackupClientsId1"] = ids&#46;Apply(getHanaBackupClientsResult => getHanaBackupClientsResult&#46;HanaBackupClients[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := hbr.GetHanaBackupClients(ctx, &hbr.GetHanaBackupClientsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			VaultId: "your_vault_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrHanaBackupClientsId1", ids.HanaBackupClients[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetHanaBackupClientsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = HbrFunctions.getHanaBackupClients(GetHanaBackupClientsArgs.builder()
     *             .ids("example_id")
     *             .vaultId("your_vault_id")
     *             .build());
     *         ctx.export("hbrHanaBackupClientsId1", ids.applyValue(getHanaBackupClientsResult -> getHanaBackupClientsResult.hanaBackupClients()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getHanaBackupClients
     *       Arguments:
     *         ids:
     *           - example_id
     *         vaultId: your_vault_id
     * outputs:
     *   hbrHanaBackupClientsId1: ${ids.hanaBackupClients[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHanaBackupClients.
     * @return A collection of values returned by getHanaBackupClients.
     */
    public suspend fun getHanaBackupClients(argument: GetHanaBackupClientsPlainArgs): GetHanaBackupClientsResult =
        getHanaBackupClientsResultToKotlin(getHanaBackupClientsPlain(argument.toJava()).await())

    /**
     * @see [getHanaBackupClients].
     * @param clientId The ID of the backup client.
     * @param clusterId The ID of the SAP HANA instance.
     * @param ids A list of Hana Backup Client IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
     * @param vaultId The ID of the backup vault.
     * @return A collection of values returned by getHanaBackupClients.
     */
    public suspend fun getHanaBackupClients(
        clientId: String? = null,
        clusterId: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
        vaultId: String,
    ): GetHanaBackupClientsResult {
        val argument = GetHanaBackupClientsPlainArgs(
            clientId = clientId,
            clusterId = clusterId,
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
            vaultId = vaultId,
        )
        return getHanaBackupClientsResultToKotlin(getHanaBackupClientsPlain(argument.toJava()).await())
    }

    /**
     * @see [getHanaBackupClients].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetHanaBackupClientsPlainArgs].
     * @return A collection of values returned by getHanaBackupClients.
     */
    public suspend fun getHanaBackupClients(argument: suspend GetHanaBackupClientsPlainArgsBuilder.() -> Unit): GetHanaBackupClientsResult {
        val builder = GetHanaBackupClientsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHanaBackupClientsResultToKotlin(getHanaBackupClientsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr Hana Backup Plans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.179.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.hbr.getHanaBackupPlans({
     *     clusterId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const hbrHanaBackupPlanId1 = ids.then(ids => ids.plans?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.hbr.get_hana_backup_plans(cluster_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("hbrHanaBackupPlanId1", ids.plans[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Hbr.GetHanaBackupPlans.Invoke(new()
     *     {
     *         ClusterId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrHanaBackupPlanId1"] = ids&#46;Apply(getHanaBackupPlansResult => getHanaBackupPlansResult&#46;Plans[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := hbr.GetHanaBackupPlans(ctx, &hbr.GetHanaBackupPlansArgs{
     * 			ClusterId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrHanaBackupPlanId1", ids.Plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetHanaBackupPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = HbrFunctions.getHanaBackupPlans(GetHanaBackupPlansArgs.builder()
     *             .clusterId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("hbrHanaBackupPlanId1", ids.applyValue(getHanaBackupPlansResult -> getHanaBackupPlansResult.plans()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getHanaBackupPlans
     *       Arguments:
     *         clusterId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   hbrHanaBackupPlanId1: ${ids.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHanaBackupPlans.
     * @return A collection of values returned by getHanaBackupPlans.
     */
    public suspend fun getHanaBackupPlans(argument: GetHanaBackupPlansPlainArgs): GetHanaBackupPlansResult =
        getHanaBackupPlansResultToKotlin(getHanaBackupPlansPlain(argument.toJava()).await())

    /**
     * @see [getHanaBackupPlans].
     * @param clusterId
     * @param databaseName The name of the database.
     * @param ids A list of Hana Backup Plan IDs.
     * @param nameRegex A regex string to filter results by Hana Backup Plan name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param vaultId The id of the vault.
     * @return A collection of values returned by getHanaBackupPlans.
     */
    public suspend fun getHanaBackupPlans(
        clusterId: String,
        databaseName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        vaultId: String? = null,
    ): GetHanaBackupPlansResult {
        val argument = GetHanaBackupPlansPlainArgs(
            clusterId = clusterId,
            databaseName = databaseName,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            vaultId = vaultId,
        )
        return getHanaBackupPlansResultToKotlin(getHanaBackupPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getHanaBackupPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetHanaBackupPlansPlainArgs].
     * @return A collection of values returned by getHanaBackupPlans.
     */
    public suspend fun getHanaBackupPlans(argument: suspend GetHanaBackupPlansPlainArgsBuilder.() -> Unit): GetHanaBackupPlansResult {
        val builder = GetHanaBackupPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHanaBackupPlansResultToKotlin(getHanaBackupPlansPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr Hana Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.178.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.hbr.getHanaInstances({
     *     ids: ["example_id"],
     * });
     * export const hbrHanaInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.hbr.get_hana_instances(ids=["example_id"])
     * pulumi.export("hbrHanaInstanceId1", ids.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Hbr.GetHanaInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrHanaInstanceId1"] = ids&#46;Apply(getHanaInstancesResult => getHanaInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := hbr.GetHanaInstances(ctx, &hbr.GetHanaInstancesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrHanaInstanceId1", ids.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetHanaInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = HbrFunctions.getHanaInstances(GetHanaInstancesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("hbrHanaInstanceId1", ids.applyValue(getHanaInstancesResult -> getHanaInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getHanaInstances
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   hbrHanaInstanceId1: ${ids.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHanaInstances.
     * @return A collection of values returned by getHanaInstances.
     */
    public suspend fun getHanaInstances(argument: GetHanaInstancesPlainArgs): GetHanaInstancesResult =
        getHanaInstancesResultToKotlin(getHanaInstancesPlain(argument.toJava()).await())

    /**
     * @see [getHanaInstances].
     * @param ids A list of Hana Instance IDs.
     * @param nameRegex A regex string to filter results by Hana Instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the SAP HANA instance. Valid values:
     * - `INITIALIZING`: The instance is being initialized.
     * - `INITIALIZED`: The instance is registered.
     * - `INVALID_HANA_NODE`: The instance is invalid.
     * - `INITIALIZE_FAILED`: The client fails to be installed on the instance.
     * @param vaultId The id of the vault.
     * @return A collection of values returned by getHanaInstances.
     */
    public suspend fun getHanaInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
        vaultId: String? = null,
    ): GetHanaInstancesResult {
        val argument = GetHanaInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
            vaultId = vaultId,
        )
        return getHanaInstancesResultToKotlin(getHanaInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getHanaInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetHanaInstancesPlainArgs].
     * @return A collection of values returned by getHanaInstances.
     */
    public suspend fun getHanaInstances(argument: suspend GetHanaInstancesPlainArgsBuilder.() -> Unit): GetHanaInstancesResult {
        val builder = GetHanaInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHanaInstancesResultToKotlin(getHanaInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr NasBackupPlans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.hbr.getNasBackupPlans({
     *     nameRegex: "^my-NasBackupPlan",
     * });
     * export const hbrNasBackupPlanId = ids.then(ids => ids.plans?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.hbr.get_nas_backup_plans(name_regex="^my-NasBackupPlan")
     * pulumi.export("hbrNasBackupPlanId", ids.plans[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Hbr.GetNasBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "^my-NasBackupPlan",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrNasBackupPlanId"] = ids&#46;Apply(getNasBackupPlansResult => getNasBackupPlansResult&#46;Plans[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := hbr.GetNasBackupPlans(ctx, &hbr.GetNasBackupPlansArgs{
     * 			NameRegex: pulumi.StringRef("^my-NasBackupPlan"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrNasBackupPlanId", ids.Plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetNasBackupPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = HbrFunctions.getNasBackupPlans(GetNasBackupPlansArgs.builder()
     *             .nameRegex("^my-NasBackupPlan")
     *             .build());
     *         ctx.export("hbrNasBackupPlanId", ids.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getNasBackupPlans
     *       Arguments:
     *         nameRegex: ^my-NasBackupPlan
     * outputs:
     *   hbrNasBackupPlanId: ${ids.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNasBackupPlans.
     * @return A collection of values returned by getNasBackupPlans.
     */
    public suspend fun getNasBackupPlans(argument: GetNasBackupPlansPlainArgs): GetNasBackupPlansResult =
        getNasBackupPlansResultToKotlin(getNasBackupPlansPlain(argument.toJava()).await())

    /**
     * @see [getNasBackupPlans].
     * @param fileSystemId The Nas fileSystem instance ID of the EcsBackupPlan used.
     * @param ids A list of NasBackupPlan IDs.
     * @param nameRegex A regex string to filter results by NasBackupPlan name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param vaultId The backup vault ID of the NasBackupPlan used.
     * @return A collection of values returned by getNasBackupPlans.
     */
    public suspend fun getNasBackupPlans(
        fileSystemId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        vaultId: String? = null,
    ): GetNasBackupPlansResult {
        val argument = GetNasBackupPlansPlainArgs(
            fileSystemId = fileSystemId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            vaultId = vaultId,
        )
        return getNasBackupPlansResultToKotlin(getNasBackupPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getNasBackupPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetNasBackupPlansPlainArgs].
     * @return A collection of values returned by getNasBackupPlans.
     */
    public suspend fun getNasBackupPlans(argument: suspend GetNasBackupPlansPlainArgsBuilder.() -> Unit): GetNasBackupPlansResult {
        val builder = GetNasBackupPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNasBackupPlansResultToKotlin(getNasBackupPlansPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr OssBackupPlans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.131.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.hbr.getOssBackupPlans({
     *     nameRegex: "^my-OssBackupPlan",
     * });
     * export const hbrOssBackupPlanId = ids.then(ids => ids.plans?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.hbr.get_oss_backup_plans(name_regex="^my-OssBackupPlan")
     * pulumi.export("hbrOssBackupPlanId", ids.plans[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Hbr.GetOssBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "^my-OssBackupPlan",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrOssBackupPlanId"] = ids&#46;Apply(getOssBackupPlansResult => getOssBackupPlansResult&#46;Plans[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := hbr.GetOssBackupPlans(ctx, &hbr.GetOssBackupPlansArgs{
     * 			NameRegex: pulumi.StringRef("^my-OssBackupPlan"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrOssBackupPlanId", ids.Plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetOssBackupPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = HbrFunctions.getOssBackupPlans(GetOssBackupPlansArgs.builder()
     *             .nameRegex("^my-OssBackupPlan")
     *             .build());
     *         ctx.export("hbrOssBackupPlanId", ids.applyValue(getOssBackupPlansResult -> getOssBackupPlansResult.plans()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getOssBackupPlans
     *       Arguments:
     *         nameRegex: ^my-OssBackupPlan
     * outputs:
     *   hbrOssBackupPlanId: ${ids.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOssBackupPlans.
     * @return A collection of values returned by getOssBackupPlans.
     */
    public suspend fun getOssBackupPlans(argument: GetOssBackupPlansPlainArgs): GetOssBackupPlansResult =
        getOssBackupPlansResultToKotlin(getOssBackupPlansPlain(argument.toJava()).await())

    /**
     * @see [getOssBackupPlans].
     * @param bucket The name of OSS bucket.
     * @param ids A list of OssBackupPlan IDs.
     * @param nameRegex A regex string to filter results by OssBackupPlan name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param vaultId The ID of backup vault the OssBackupPlan used.
     * @return A collection of values returned by getOssBackupPlans.
     */
    public suspend fun getOssBackupPlans(
        bucket: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        vaultId: String? = null,
    ): GetOssBackupPlansResult {
        val argument = GetOssBackupPlansPlainArgs(
            bucket = bucket,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            vaultId = vaultId,
        )
        return getOssBackupPlansResultToKotlin(getOssBackupPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getOssBackupPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetOssBackupPlansPlainArgs].
     * @return A collection of values returned by getOssBackupPlans.
     */
    public suspend fun getOssBackupPlans(argument: suspend GetOssBackupPlansPlainArgsBuilder.() -> Unit): GetOssBackupPlansResult {
        val builder = GetOssBackupPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOssBackupPlansResultToKotlin(getOssBackupPlansPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr OtsBackupPlans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.163.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.hbr.getOtsBackupPlans({
     *     nameRegex: "^my-otsBackupPlan",
     * });
     * export const hbrOtsBackupPlanId = plans[0].id;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.hbr.get_ots_backup_plans(name_regex="^my-otsBackupPlan")
     * pulumi.export("hbrOtsBackupPlanId", plans[0]["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Hbr.GetOtsBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "^my-otsBackupPlan",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrOtsBackupPlanId"] = plans[0].Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := hbr.GetOtsBackupPlans(ctx, &hbr.GetOtsBackupPlansArgs{
     * 			NameRegex: pulumi.StringRef("^my-otsBackupPlan"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrOtsBackupPlanId", plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetOtsBackupPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = HbrFunctions.getOtsBackupPlans(GetOtsBackupPlansArgs.builder()
     *             .nameRegex("^my-otsBackupPlan")
     *             .build());
     *         ctx.export("hbrOtsBackupPlanId", plans[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getOtsBackupPlans
     *       Arguments:
     *         nameRegex: ^my-otsBackupPlan
     * outputs:
     *   hbrOtsBackupPlanId: ${plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOtsBackupPlans.
     * @return A collection of values returned by getOtsBackupPlans.
     */
    public suspend fun getOtsBackupPlans(argument: GetOtsBackupPlansPlainArgs): GetOtsBackupPlansResult =
        getOtsBackupPlansResultToKotlin(getOtsBackupPlansPlain(argument.toJava()).await())

    /**
     * @see [getOtsBackupPlans].
     * @param ids A list of OtsBackupPlan IDs.
     * @param nameRegex A regex string to filter results by OtsBackupPlan name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param planId The ID of the backup plan.
     * @param planName The ID of the backup plan.
     * @param vaultId The ID of backup vault the OtsBackupPlan used.
     * @return A collection of values returned by getOtsBackupPlans.
     */
    public suspend fun getOtsBackupPlans(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        planId: String? = null,
        planName: String? = null,
        vaultId: String? = null,
    ): GetOtsBackupPlansResult {
        val argument = GetOtsBackupPlansPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            planId = planId,
            planName = planName,
            vaultId = vaultId,
        )
        return getOtsBackupPlansResultToKotlin(getOtsBackupPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getOtsBackupPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetOtsBackupPlansPlainArgs].
     * @return A collection of values returned by getOtsBackupPlans.
     */
    public suspend fun getOtsBackupPlans(argument: suspend GetOtsBackupPlansPlainArgsBuilder.() -> Unit): GetOtsBackupPlansResult {
        val builder = GetOtsBackupPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOtsBackupPlansResultToKotlin(getOtsBackupPlansPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr Ots Snapshots of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.164.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const snapshots = alicloud.hbr.getOtsSnapshots({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * snapshots = alicloud.hbr.get_ots_snapshots()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var snapshots = AliCloud.Hbr.GetOtsSnapshots.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := hbr.GetOtsSnapshots(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetOtsSnapshotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var snapshots = HbrFunctions.getOtsSnapshots();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   snapshots:
     *     fn::invoke:
     *       Function: alicloud:hbr:getOtsSnapshots
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOtsSnapshots.
     * @return A collection of values returned by getOtsSnapshots.
     */
    public suspend fun getOtsSnapshots(argument: GetOtsSnapshotsPlainArgs): GetOtsSnapshotsResult =
        getOtsSnapshotsResultToKotlin(getOtsSnapshotsPlain(argument.toJava()).await())

    /**
     * @see [getOtsSnapshots].
     * @param endTime The end time of the backup. This value must be a UNIX timestamp. Unit: milliseconds
     * @param ids
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param startTime The start time of the backup. This value must be a UNIX timestamp. Unit: milliseconds.
     * @return A collection of values returned by getOtsSnapshots.
     */
    public suspend fun getOtsSnapshots(
        endTime: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        startTime: String? = null,
    ): GetOtsSnapshotsResult {
        val argument = GetOtsSnapshotsPlainArgs(
            endTime = endTime,
            ids = ids,
            outputFile = outputFile,
            startTime = startTime,
        )
        return getOtsSnapshotsResultToKotlin(getOtsSnapshotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOtsSnapshots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetOtsSnapshotsPlainArgs].
     * @return A collection of values returned by getOtsSnapshots.
     */
    public suspend fun getOtsSnapshots(argument: suspend GetOtsSnapshotsPlainArgsBuilder.() -> Unit): GetOtsSnapshotsResult {
        val builder = GetOtsSnapshotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOtsSnapshotsResultToKotlin(getOtsSnapshotsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the HBR Replication Vault Regions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.152.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.hbr.getReplicationVaultRegions({});
     * export const hbrReplicationVaultRegionRegionId1 = _default.then(_default => _default.regions?.[0]?.replicationRegionId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.hbr.get_replication_vault_regions()
     * pulumi.export("hbrReplicationVaultRegionRegionId1", default.regions[0].replication_region_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Hbr.GetReplicationVaultRegions.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrReplicationVaultRegionRegionId1"] = @default&#46;Apply(@default => @default&#46;Apply(getReplicationVaultRegionsResult => getReplicationVaultRegionsResult&#46;Regions[0]?.ReplicationRegionId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := hbr.GetReplicationVaultRegions(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrReplicationVaultRegionRegionId1", _default.Regions[0].ReplicationRegionId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetReplicationVaultRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = HbrFunctions.getReplicationVaultRegions();
     *         ctx.export("hbrReplicationVaultRegionRegionId1", default_.regions()[0].replicationRegionId());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:hbr:getReplicationVaultRegions
     *       Arguments: {}
     * outputs:
     *   hbrReplicationVaultRegionRegionId1: ${default.regions[0].replicationRegionId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getReplicationVaultRegions.
     * @return A collection of values returned by getReplicationVaultRegions.
     */
    public suspend fun getReplicationVaultRegions(argument: GetReplicationVaultRegionsPlainArgs): GetReplicationVaultRegionsResult =
        getReplicationVaultRegionsResultToKotlin(getReplicationVaultRegionsPlain(argument.toJava()).await())

    /**
     * @see [getReplicationVaultRegions].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getReplicationVaultRegions.
     */
    public suspend fun getReplicationVaultRegions(outputFile: String? = null): GetReplicationVaultRegionsResult {
        val argument = GetReplicationVaultRegionsPlainArgs(
            outputFile = outputFile,
        )
        return getReplicationVaultRegionsResultToKotlin(getReplicationVaultRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationVaultRegions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetReplicationVaultRegionsPlainArgs].
     * @return A collection of values returned by getReplicationVaultRegions.
     */
    public suspend fun getReplicationVaultRegions(argument: suspend GetReplicationVaultRegionsPlainArgsBuilder.() -> Unit): GetReplicationVaultRegionsResult {
        val builder = GetReplicationVaultRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationVaultRegionsResultToKotlin(getReplicationVaultRegionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr Restore Jobs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.hbr.getEcsBackupPlans({
     *     nameRegex: "plan-name",
     * });
     * const defaultGetRestoreJobs = Promise.all([_default, _default])&#46;then(([_default, _default1]) => alicloud.hbr.getRestoreJobs({
     *     restoreType: "ECS_FILE",
     *     vaultIds: [_default&#46;plans?&#46;[0]?&#46;vaultId],
     *     targetInstanceIds: [_default1&#46;plans?&#46;[0]?&#46;instanceId],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-name")
     * default_get_restore_jobs = alicloud.hbr.get_restore_jobs(restore_type="ECS_FILE",
     *     vault_ids=[default&#46;plans[0]&#46;vault_id],
     *     target_instance_ids=[default&#46;plans[0]&#46;instance_id])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Hbr.GetEcsBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "plan-name",
     *     });
     *     var defaultGetRestoreJobs = AliCloud.Hbr.GetRestoreJobs.Invoke(new()
     *     {
     *         RestoreType = "ECS_FILE",
     *         VaultIds = new[]
     *         {
     *             @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.VaultId),
     *         },
     *         TargetInstanceIds = new[]
     *         {
     *             @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.InstanceId),
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := hbr.GetEcsBackupPlans(ctx, &hbr.GetEcsBackupPlansArgs{
     * NameRegex: pulumi.StringRef("plan-name"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * _, err = hbr.GetRestoreJobs(ctx, &hbr.GetRestoreJobsArgs{
     * RestoreType: "ECS_FILE",
     * VaultIds: interface{}{
     * _default.Plans[0].VaultId,
     * },
     * TargetInstanceIds: interface{}{
     * _default.Plans[0].InstanceId,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansArgs;
     * import com.pulumi.alicloud.hbr.inputs.GetRestoreJobsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = HbrFunctions.getEcsBackupPlans(GetEcsBackupPlansArgs.builder()
     *             .nameRegex("plan-name")
     *             .build());
     *         final var defaultGetRestoreJobs = HbrFunctions.getRestoreJobs(GetRestoreJobsArgs.builder()
     *             .restoreType("ECS_FILE")
     *             .vaultIds(default_.plans()[0].vaultId())
     *             .targetInstanceIds(default_.plans()[0].instanceId())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:hbr:getEcsBackupPlans
     *       Arguments:
     *         nameRegex: plan-name
     *   defaultGetRestoreJobs:
     *     fn::invoke:
     *       Function: alicloud:hbr:getRestoreJobs
     *       Arguments:
     *         restoreType: ECS_FILE
     *         vaultIds:
     *           - ${default.plans[0].vaultId}
     *         targetInstanceIds:
     *           - ${default.plans[0].instanceId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRestoreJobs.
     * @return A collection of values returned by getRestoreJobs.
     */
    public suspend fun getRestoreJobs(argument: GetRestoreJobsPlainArgs): GetRestoreJobsResult =
        getRestoreJobsResultToKotlin(getRestoreJobsPlain(argument.toJava()).await())

    /**
     * @see [getRestoreJobs].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param restoreIds The list of restore job IDs.
     * @param restoreType The Recovery Destination Types. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`, `UDM_ECS_ROLLBACK`.
     * @param sourceTypes The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
     * @param status The status of restore job. Valid values: `CANCELED`, `CANCELING`, `COMPLETE`, `CREATED`, `EXPIRED`, `FAILED`, `PARTIAL_COMPLETE`, `QUEUED`, `RUNNING`.
     * @param targetBuckets The name of target OSS bucket.
     * @param targetFileSystemIds Valid while source_type equals `NAS`. The list of destination File System IDs.
     * @param targetInstanceIds The ID of target ECS instance.
     * @param vaultIds The list of backup vault IDs.
     * @return A collection of values returned by getRestoreJobs.
     */
    public suspend fun getRestoreJobs(
        outputFile: String? = null,
        restoreIds: List<String>? = null,
        restoreType: String,
        sourceTypes: List<String>? = null,
        status: String? = null,
        targetBuckets: List<String>? = null,
        targetFileSystemIds: List<String>? = null,
        targetInstanceIds: List<String>? = null,
        vaultIds: List<String>? = null,
    ): GetRestoreJobsResult {
        val argument = GetRestoreJobsPlainArgs(
            outputFile = outputFile,
            restoreIds = restoreIds,
            restoreType = restoreType,
            sourceTypes = sourceTypes,
            status = status,
            targetBuckets = targetBuckets,
            targetFileSystemIds = targetFileSystemIds,
            targetInstanceIds = targetInstanceIds,
            vaultIds = vaultIds,
        )
        return getRestoreJobsResultToKotlin(getRestoreJobsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRestoreJobs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetRestoreJobsPlainArgs].
     * @return A collection of values returned by getRestoreJobs.
     */
    public suspend fun getRestoreJobs(argument: suspend GetRestoreJobsPlainArgsBuilder.() -> Unit): GetRestoreJobsResult {
        val builder = GetRestoreJobsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRestoreJobsResultToKotlin(getRestoreJobsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr Server Backup Plans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.142.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.ecs.getInstances({
     *     nameRegex: "no-deleteing-hbr-ecs-server-backup-plan",
     *     status: "Running",
     * });
     * const ids = _default.then(_default => alicloud.hbr.getServerBackupPlans({
     *     filters: [{
     *         key: "instanceId",
     *         values: [_default&#46;instances?&#46;[0]?&#46;id],
     *     }],
     * }));
     * export const hbrServerBackupPlanId1 = ids.then(ids => ids.plans?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.ecs.get_instances(name_regex="no-deleteing-hbr-ecs-server-backup-plan",
     *     status="Running")
     * ids = alicloud.hbr.get_server_backup_plans(filters=[{
     *     "key": "instanceId",
     *     "values": [default&#46;instances[0]&#46;id],
     * }])
     * pulumi.export("hbrServerBackupPlanId1", ids.plans[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Ecs.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "no-deleteing-hbr-ecs-server-backup-plan",
     *         Status = "Running",
     *     });
     *     var ids = AliCloud.Hbr.GetServerBackupPlans.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new AliCloud.Hbr.Inputs.GetServerBackupPlansFilterInputArgs
     *             {
     *                 Key = "instanceId",
     *                 Values = new[]
     *                 {
     *                     @default.Apply(getInstancesResult => getInstancesResult.Instances[0]?.Id),
     *                 },
     *             },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrServerBackupPlanId1"] = ids&#46;Apply(getServerBackupPlansResult => getServerBackupPlansResult&#46;Plans[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := ecs.GetInstances(ctx, &ecs.GetInstancesArgs{
     * NameRegex: pulumi.StringRef("no-deleteing-hbr-ecs-server-backup-plan"),
     * Status: pulumi.StringRef("Running"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ids, err := hbr.GetServerBackupPlans(ctx, &hbr.GetServerBackupPlansArgs{
     * Filters: []hbr.GetServerBackupPlansFilter{
     * {
     * Key: pulumi.StringRef("instanceId"),
     * Values: interface{}{
     * _default.Instances[0].Id,
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("hbrServerBackupPlanId1", ids.Plans[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ecs.EcsFunctions;
     * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetServerBackupPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EcsFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("no-deleteing-hbr-ecs-server-backup-plan")
     *             .status("Running")
     *             .build());
     *         final var ids = HbrFunctions.getServerBackupPlans(GetServerBackupPlansArgs.builder()
     *             .filters(GetServerBackupPlansFilterArgs.builder()
     *                 .key("instanceId")
     *                 .values(default_.instances()[0].id())
     *                 .build())
     *             .build());
     *         ctx.export("hbrServerBackupPlanId1", ids.applyValue(getServerBackupPlansResult -> getServerBackupPlansResult.plans()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:ecs:getInstances
     *       Arguments:
     *         nameRegex: no-deleteing-hbr-ecs-server-backup-plan
     *         status: Running
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getServerBackupPlans
     *       Arguments:
     *         filters:
     *           - key: instanceId
     *             values:
     *               - ${default.instances[0].id}
     * outputs:
     *   hbrServerBackupPlanId1: ${ids.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerBackupPlans.
     * @return A collection of values returned by getServerBackupPlans.
     */
    public suspend fun getServerBackupPlans(argument: GetServerBackupPlansPlainArgs): GetServerBackupPlansResult =
        getServerBackupPlansResultToKotlin(getServerBackupPlansPlain(argument.toJava()).await())

    /**
     * @see [getServerBackupPlans].
     * @param filters The filters.
     * @param ids A list of Server Backup Plan IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getServerBackupPlans.
     */
    public suspend fun getServerBackupPlans(
        filters: List<GetServerBackupPlansFilter>? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
    ): GetServerBackupPlansResult {
        val argument = GetServerBackupPlansPlainArgs(
            filters = filters,
            ids = ids,
            outputFile = outputFile,
        )
        return getServerBackupPlansResultToKotlin(getServerBackupPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerBackupPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetServerBackupPlansPlainArgs].
     * @return A collection of values returned by getServerBackupPlans.
     */
    public suspend fun getServerBackupPlans(argument: suspend GetServerBackupPlansPlainArgsBuilder.() -> Unit): GetServerBackupPlansResult {
        val builder = GetServerBackupPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerBackupPlansResultToKotlin(getServerBackupPlansPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open HBR service automatically. If the service has been opened, it will return opened.
     * For information about HBR and how to use it, see [What is HBR](https://www.alibabacloud.com/help/en/hybrid-backup-recovery).
     * > **NOTE:** Available since v1.184.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.hbr.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.hbr.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Hbr.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := hbr.GetService(ctx, &hbr.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = HbrFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:hbr:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the HBR service that means you have read and agreed the [HBR Terms of Service](https://help.aliyun.com/document_detail/62906.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr Snapshots of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.hbr.getEcsBackupPlans({
     *     nameRegex: "plan-tf-used-dont-delete",
     * });
     * const defaultGetOssBackupPlans = alicloud.hbr.getOssBackupPlans({
     *     nameRegex: "plan-tf-used-dont-delete",
     * });
     * const defaultGetNasBackupPlans = alicloud.hbr.getNasBackupPlans({
     *     nameRegex: "plan-tf-used-dont-delete",
     * });
     * const ecsSnapshots = Promise.all([_default, _default])&#46;then(([_default, _default1]) => alicloud.hbr.getSnapshots({
     *     sourceType: "ECS_FILE",
     *     vaultId: _default.plans?.[0]?.vaultId,
     *     instanceId: _default1.plans?.[0]?.instanceId,
     * }));
     * const ossSnapshots = Promise.all([defaultGetOssBackupPlans, defaultGetOssBackupPlans])&#46;then(([defaultGetOssBackupPlans, defaultGetOssBackupPlans1]) => alicloud.hbr.getSnapshots({
     *     sourceType: "OSS",
     *     vaultId: defaultGetOssBackupPlans.plans?.[0]?.vaultId,
     *     bucket: defaultGetOssBackupPlans1.plans?.[0]?.bucket,
     *     completeTime: "2021-07-20T14:17:15CST,2021-07-24T14:17:15CST",
     *     completeTimeChecker: "BETWEEN",
     * }));
     * const nasSnapshots = Promise.all([defaultGetNasBackupPlans, defaultGetNasBackupPlans, defaultGetNasBackupPlans])&#46;then(([defaultGetNasBackupPlans, defaultGetNasBackupPlans1, defaultGetNasBackupPlans2]) => alicloud.hbr.getSnapshots({
     *     sourceType: "NAS",
     *     vaultId: defaultGetNasBackupPlans.plans?.[0]?.vaultId,
     *     fileSystemId: defaultGetNasBackupPlans1.plans?.[0]?.fileSystemId,
     *     createTime: defaultGetNasBackupPlans2.plans?.[0]?.createTime,
     *     completeTime: "2021-08-23T14:17:15CST",
     *     completeTimeChecker: "GREATER_THAN_OR_EQUAL",
     * }));
     * export const hbrSnapshotId1 = nasSnapshots.then(nasSnapshots => nasSnapshots.snapshots?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-tf-used-dont-delete")
     * default_get_oss_backup_plans = alicloud.hbr.get_oss_backup_plans(name_regex="plan-tf-used-dont-delete")
     * default_get_nas_backup_plans = alicloud.hbr.get_nas_backup_plans(name_regex="plan-tf-used-dont-delete")
     * ecs_snapshots = alicloud.hbr.get_snapshots(source_type="ECS_FILE",
     *     vault_id=default.plans[0].vault_id,
     *     instance_id=default.plans[0].instance_id)
     * oss_snapshots = alicloud.hbr.get_snapshots(source_type="OSS",
     *     vault_id=default_get_oss_backup_plans.plans[0].vault_id,
     *     bucket=default_get_oss_backup_plans.plans[0].bucket,
     *     complete_time="2021-07-20T14:17:15CST,2021-07-24T14:17:15CST",
     *     complete_time_checker="BETWEEN")
     * nas_snapshots = alicloud.hbr.get_snapshots(source_type="NAS",
     *     vault_id=default_get_nas_backup_plans.plans[0].vault_id,
     *     file_system_id=default_get_nas_backup_plans.plans[0].file_system_id,
     *     create_time=default_get_nas_backup_plans.plans[0].create_time,
     *     complete_time="2021-08-23T14:17:15CST",
     *     complete_time_checker="GREATER_THAN_OR_EQUAL")
     * pulumi.export("hbrSnapshotId1", nas_snapshots.snapshots[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Hbr.GetEcsBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "plan-tf-used-dont-delete",
     *     });
     *     var defaultGetOssBackupPlans = AliCloud.Hbr.GetOssBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "plan-tf-used-dont-delete",
     *     });
     *     var defaultGetNasBackupPlans = AliCloud.Hbr.GetNasBackupPlans.Invoke(new()
     *     {
     *         NameRegex = "plan-tf-used-dont-delete",
     *     });
     *     var ecsSnapshots = AliCloud.Hbr.GetSnapshots.Invoke(new()
     *     {
     *         SourceType = "ECS_FILE",
     *         VaultId = @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.VaultId),
     *         InstanceId = @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.InstanceId),
     *     });
     *     var ossSnapshots = AliCloud.Hbr.GetSnapshots.Invoke(new()
     *     {
     *         SourceType = "OSS",
     *         VaultId = defaultGetOssBackupPlans.Apply(getOssBackupPlansResult => getOssBackupPlansResult.Plans[0]?.VaultId),
     *         Bucket = defaultGetOssBackupPlans.Apply(getOssBackupPlansResult => getOssBackupPlansResult.Plans[0]?.Bucket),
     *         CompleteTime = "2021-07-20T14:17:15CST,2021-07-24T14:17:15CST",
     *         CompleteTimeChecker = "BETWEEN",
     *     });
     *     var nasSnapshots = AliCloud.Hbr.GetSnapshots.Invoke(new()
     *     {
     *         SourceType = "NAS",
     *         VaultId = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.VaultId),
     *         FileSystemId = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.FileSystemId),
     *         CreateTime = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.CreateTime),
     *         CompleteTime = "2021-08-23T14:17:15CST",
     *         CompleteTimeChecker = "GREATER_THAN_OR_EQUAL",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrSnapshotId1"] = nasSnapshots&#46;Apply(getSnapshotsResult => getSnapshotsResult&#46;Snapshots[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := hbr.GetEcsBackupPlans(ctx, &hbr.GetEcsBackupPlansArgs{
     * 			NameRegex: pulumi.StringRef("plan-tf-used-dont-delete"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetOssBackupPlans, err := hbr.GetOssBackupPlans(ctx, &hbr.GetOssBackupPlansArgs{
     * 			NameRegex: pulumi.StringRef("plan-tf-used-dont-delete"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetNasBackupPlans, err := hbr.GetNasBackupPlans(ctx, &hbr.GetNasBackupPlansArgs{
     * 			NameRegex: pulumi.StringRef("plan-tf-used-dont-delete"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = hbr.GetSnapshots(ctx, &hbr.GetSnapshotsArgs{
     * 			SourceType: "ECS_FILE",
     * 			VaultId:    _default.Plans[0].VaultId,
     * 			InstanceId: pulumi.StringRef(_default.Plans[0].InstanceId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = hbr.GetSnapshots(ctx, &hbr.GetSnapshotsArgs{
     * 			SourceType:          "OSS",
     * 			VaultId:             defaultGetOssBackupPlans.Plans[0].VaultId,
     * 			Bucket:              pulumi.StringRef(defaultGetOssBackupPlans.Plans[0].Bucket),
     * 			CompleteTime:        pulumi.StringRef("2021-07-20T14:17:15CST,2021-07-24T14:17:15CST"),
     * 			CompleteTimeChecker: pulumi.StringRef("BETWEEN"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		nasSnapshots, err := hbr.GetSnapshots(ctx, &hbr.GetSnapshotsArgs{
     * 			SourceType:          "NAS",
     * 			VaultId:             defaultGetNasBackupPlans.Plans[0].VaultId,
     * 			FileSystemId:        pulumi.StringRef(defaultGetNasBackupPlans.Plans[0].FileSystemId),
     * 			CreateTime:          pulumi.StringRef(defaultGetNasBackupPlans.Plans[0].CreateTime),
     * 			CompleteTime:        pulumi.StringRef("2021-08-23T14:17:15CST"),
     * 			CompleteTimeChecker: pulumi.StringRef("GREATER_THAN_OR_EQUAL"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrSnapshotId1", nasSnapshots.Snapshots[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansArgs;
     * import com.pulumi.alicloud.hbr.inputs.GetOssBackupPlansArgs;
     * import com.pulumi.alicloud.hbr.inputs.GetNasBackupPlansArgs;
     * import com.pulumi.alicloud.hbr.inputs.GetSnapshotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = HbrFunctions.getEcsBackupPlans(GetEcsBackupPlansArgs.builder()
     *             .nameRegex("plan-tf-used-dont-delete")
     *             .build());
     *         final var defaultGetOssBackupPlans = HbrFunctions.getOssBackupPlans(GetOssBackupPlansArgs.builder()
     *             .nameRegex("plan-tf-used-dont-delete")
     *             .build());
     *         final var defaultGetNasBackupPlans = HbrFunctions.getNasBackupPlans(GetNasBackupPlansArgs.builder()
     *             .nameRegex("plan-tf-used-dont-delete")
     *             .build());
     *         final var ecsSnapshots = HbrFunctions.getSnapshots(GetSnapshotsArgs.builder()
     *             .sourceType("ECS_FILE")
     *             .vaultId(default_.plans()[0].vaultId())
     *             .instanceId(default_.plans()[0].instanceId())
     *             .build());
     *         final var ossSnapshots = HbrFunctions.getSnapshots(GetSnapshotsArgs.builder()
     *             .sourceType("OSS")
     *             .vaultId(defaultGetOssBackupPlans.applyValue(getOssBackupPlansResult -> getOssBackupPlansResult.plans()[0].vaultId()))
     *             .bucket(defaultGetOssBackupPlans.applyValue(getOssBackupPlansResult -> getOssBackupPlansResult.plans()[0].bucket()))
     *             .completeTime("2021-07-20T14:17:15CST,2021-07-24T14:17:15CST")
     *             .completeTimeChecker("BETWEEN")
     *             .build());
     *         final var nasSnapshots = HbrFunctions.getSnapshots(GetSnapshotsArgs.builder()
     *             .sourceType("NAS")
     *             .vaultId(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].vaultId()))
     *             .fileSystemId(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].fileSystemId()))
     *             .createTime(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].createTime()))
     *             .completeTime("2021-08-23T14:17:15CST")
     *             .completeTimeChecker("GREATER_THAN_OR_EQUAL")
     *             .build());
     *         ctx.export("hbrSnapshotId1", nasSnapshots.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:hbr:getEcsBackupPlans
     *       Arguments:
     *         nameRegex: plan-tf-used-dont-delete
     *   defaultGetOssBackupPlans:
     *     fn::invoke:
     *       Function: alicloud:hbr:getOssBackupPlans
     *       Arguments:
     *         nameRegex: plan-tf-used-dont-delete
     *   defaultGetNasBackupPlans:
     *     fn::invoke:
     *       Function: alicloud:hbr:getNasBackupPlans
     *       Arguments:
     *         nameRegex: plan-tf-used-dont-delete
     *   ecsSnapshots:
     *     fn::invoke:
     *       Function: alicloud:hbr:getSnapshots
     *       Arguments:
     *         sourceType: ECS_FILE
     *         vaultId: ${default.plans[0].vaultId}
     *         instanceId: ${default.plans[0].instanceId}
     *   ossSnapshots:
     *     fn::invoke:
     *       Function: alicloud:hbr:getSnapshots
     *       Arguments:
     *         sourceType: OSS
     *         vaultId: ${defaultGetOssBackupPlans.plans[0].vaultId}
     *         bucket: ${defaultGetOssBackupPlans.plans[0].bucket}
     *         completeTime: 2021-07-20T14:17:15CST,2021-07-24T14:17:15CST
     *         completeTimeChecker: BETWEEN
     *   nasSnapshots:
     *     fn::invoke:
     *       Function: alicloud:hbr:getSnapshots
     *       Arguments:
     *         sourceType: NAS
     *         vaultId: ${defaultGetNasBackupPlans.plans[0].vaultId}
     *         fileSystemId: ${defaultGetNasBackupPlans.plans[0].fileSystemId}
     *         createTime: ${defaultGetNasBackupPlans.plans[0].createTime}
     *         completeTime: 2021-08-23T14:17:15CST
     *         completeTimeChecker: GREATER_THAN_OR_EQUAL
     * outputs:
     *   hbrSnapshotId1: ${nasSnapshots.snapshots[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnapshots.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: GetSnapshotsPlainArgs): GetSnapshotsResult =
        getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())

    /**
     * @see [getSnapshots].
     * @param bucket The bucket name of OSS. While source_type equals `OSS`, this parameter must be set.
     * @param completeTime Timestamp of Snapshot completion. Note The time format of the API adopts the ISO 8601 format, such as 2021-07-09T15:45:30CST or 2021-07-09T07:45:30Z. **Note**: While `complete_time_checker` equals `BETWEEN`, this field should be formatted such as `"2021-08-20T14:17:15CST,2021-08-26T14:17:15CST"`, The first part of this string is the start time, the second part is the end time, and the two parts should be separated by commas.
     * @param completeTimeChecker Complete time filter operator. Optional values: `MATCH_TERM`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`.
     * @param createTime File system creation timestamp of Nas. While source_type equals `NAS`, this parameter must be set. **Note** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
     * @param fileSystemId The File System ID of Nas. While source_type equals `NAS`, this parameter must be set.
     * @param ids A list of Snapshot IDs.
     * @param instanceId The ID of ECS instance. The ecs backup client must have been installed on the host. While source_type equals `ECS_FILE`, this parameter must be set.
     * @param limit
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param query
     * @param sourceType Data source type, valid values: `ECS_FILE`, `OSS`, `NAS`.
     * @param status The status of snapshot, valid values: `COMPLETE`, `PARTIAL_COMPLETE`.
     * @param vaultId The ID of Vault.
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(
        bucket: String? = null,
        completeTime: String? = null,
        completeTimeChecker: String? = null,
        createTime: String? = null,
        fileSystemId: String? = null,
        ids: List<String>? = null,
        instanceId: String? = null,
        limit: Int? = null,
        outputFile: String? = null,
        query: String? = null,
        sourceType: String,
        status: String? = null,
        vaultId: String,
    ): GetSnapshotsResult {
        val argument = GetSnapshotsPlainArgs(
            bucket = bucket,
            completeTime = completeTime,
            completeTimeChecker = completeTimeChecker,
            createTime = createTime,
            fileSystemId = fileSystemId,
            ids = ids,
            instanceId = instanceId,
            limit = limit,
            outputFile = outputFile,
            query = query,
            sourceType = sourceType,
            status = status,
            vaultId = vaultId,
        )
        return getSnapshotsResultToKotlin(getSnapshotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetSnapshotsPlainArgs].
     * @return A collection of values returned by getSnapshots.
     */
    public suspend fun getSnapshots(argument: suspend GetSnapshotsPlainArgsBuilder.() -> Unit): GetSnapshotsResult {
        val builder = GetSnapshotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotsResultToKotlin(getSnapshotsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Hbr Vaults of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.129.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.hbr.getVaults({
     *     nameRegex: "^my-Vault",
     * });
     * export const hbrVaultId1 = ids.then(ids => ids.vaults?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.hbr.get_vaults(name_regex="^my-Vault")
     * pulumi.export("hbrVaultId1", ids.vaults[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Hbr.GetVaults.Invoke(new()
     *     {
     *         NameRegex = "^my-Vault",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["hbrVaultId1"] = ids&#46;Apply(getVaultsResult => getVaultsResult&#46;Vaults[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := hbr.GetVaults(ctx, &hbr.GetVaultsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Vault"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("hbrVaultId1", ids.Vaults[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.hbr.HbrFunctions;
     * import com.pulumi.alicloud.hbr.inputs.GetVaultsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = HbrFunctions.getVaults(GetVaultsArgs.builder()
     *             .nameRegex("^my-Vault")
     *             .build());
     *         ctx.export("hbrVaultId1", ids.applyValue(getVaultsResult -> getVaultsResult.vaults()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:hbr:getVaults
     *       Arguments:
     *         nameRegex: ^my-Vault
     * outputs:
     *   hbrVaultId1: ${ids.vaults[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVaults.
     * @return A collection of values returned by getVaults.
     */
    public suspend fun getVaults(argument: GetVaultsPlainArgs): GetVaultsResult =
        getVaultsResultToKotlin(getVaultsPlain(argument.toJava()).await())

    /**
     * @see [getVaults].
     * @param ids A list of Vault IDs.
     * @param nameRegex A regex string to filter results by Vault name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of Vault. Valid values: `CREATED`, `ERROR`, `UNKNOWN`.
     * @param vaultType VaultType. Valid values: `STANDARD`,`OTS_BACKUP`.
     * - `STANDARD` - used in OSS, NAS and ECS File backup.
     * - `OTS_BACKUP` -  used in OTS backup.
     * @return A collection of values returned by getVaults.
     */
    public suspend fun getVaults(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        vaultType: String? = null,
    ): GetVaultsResult {
        val argument = GetVaultsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            vaultType = vaultType,
        )
        return getVaultsResultToKotlin(getVaultsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVaults].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;hbr&#46;kotlin&#46;inputs&#46;GetVaultsPlainArgs].
     * @return A collection of values returned by getVaults.
     */
    public suspend fun getVaults(argument: suspend GetVaultsPlainArgsBuilder.() -> Unit): GetVaultsResult {
        val builder = GetVaultsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVaultsResultToKotlin(getVaultsPlain(builtArgument.toJava()).await())
    }
}
