@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.NasBackupPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a HBR Nas Backup Plan resource.
 * For information about HBR Nas Backup Plan and how to use it, see [What is Nas Backup Plan](https://www.alibabacloud.com/help/doc-detail/132248.htm).
 * > **NOTE:** Available in v1.132.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultVault = new alicloud.hbr.Vault("default", {vaultName: `terraform-example-${_default.result}`});
 * const defaultFileSystem = new alicloud.nas.FileSystem("default", {
 *     protocolType: "NFS",
 *     storageType: "Performance",
 *     description: "terraform-example",
 *     encryptType: 1,
 * });
 * const defaultNasBackupPlan = new alicloud.hbr.NasBackupPlan("default", {
 *     nasBackupPlanName: "terraform-example",
 *     fileSystemId: defaultFileSystem.id,
 *     schedule: "I|1602673264|PT2H",
 *     backupType: "COMPLETE",
 *     vaultId: defaultVault.id,
 *     retention: "2",
 *     paths: ["/"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_vault = alicloud.hbr.Vault("default", vault_name=f"terraform-example-{default['result']}")
 * default_file_system = alicloud.nas.FileSystem("default",
 *     protocol_type="NFS",
 *     storage_type="Performance",
 *     description="terraform-example",
 *     encrypt_type=1)
 * default_nas_backup_plan = alicloud.hbr.NasBackupPlan("default",
 *     nas_backup_plan_name="terraform-example",
 *     file_system_id=default_file_system.id,
 *     schedule="I|1602673264|PT2H",
 *     backup_type="COMPLETE",
 *     vault_id=default_vault.id,
 *     retention="2",
 *     paths=["/"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultVault = new AliCloud.Hbr.Vault("default", new()
 *     {
 *         VaultName = $"terraform-example-{@default.Result}",
 *     });
 *     var defaultFileSystem = new AliCloud.Nas.FileSystem("default", new()
 *     {
 *         ProtocolType = "NFS",
 *         StorageType = "Performance",
 *         Description = "terraform-example",
 *         EncryptType = 1,
 *     });
 *     var defaultNasBackupPlan = new AliCloud.Hbr.NasBackupPlan("default", new()
 *     {
 *         NasBackupPlanName = "terraform-example",
 *         FileSystemId = defaultFileSystem.Id,
 *         Schedule = "I|1602673264|PT2H",
 *         BackupType = "COMPLETE",
 *         VaultId = defaultVault.Id,
 *         Retention = "2",
 *         Paths = new[]
 *         {
 *             "/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/nas"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVault, err := hbr.NewVault(ctx, "default", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultFileSystem, err := nas.NewFileSystem(ctx, "default", &nas.FileSystemArgs{
 * 			ProtocolType: pulumi.String("NFS"),
 * 			StorageType:  pulumi.String("Performance"),
 * 			Description:  pulumi.String("terraform-example"),
 * 			EncryptType:  pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewNasBackupPlan(ctx, "default", &hbr.NasBackupPlanArgs{
 * 			NasBackupPlanName: pulumi.String("terraform-example"),
 * 			FileSystemId:      defaultFileSystem.ID(),
 * 			Schedule:          pulumi.String("I|1602673264|PT2H"),
 * 			BackupType:        pulumi.String("COMPLETE"),
 * 			VaultId:           defaultVault.ID(),
 * 			Retention:         pulumi.String("2"),
 * 			Paths: pulumi.StringArray{
 * 				pulumi.String("/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.nas.FileSystem;
 * import com.pulumi.alicloud.nas.FileSystemArgs;
 * import com.pulumi.alicloud.hbr.NasBackupPlan;
 * import com.pulumi.alicloud.hbr.NasBackupPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultVault = new Vault("defaultVault", VaultArgs.builder()
 *             .vaultName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .protocolType("NFS")
 *             .storageType("Performance")
 *             .description("terraform-example")
 *             .encryptType("1")
 *             .build());
 *         var defaultNasBackupPlan = new NasBackupPlan("defaultNasBackupPlan", NasBackupPlanArgs.builder()
 *             .nasBackupPlanName("terraform-example")
 *             .fileSystemId(defaultFileSystem.id())
 *             .schedule("I|1602673264|PT2H")
 *             .backupType("COMPLETE")
 *             .vaultId(defaultVault.id())
 *             .retention("2")
 *             .paths("/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultVault:
 *     type: alicloud:hbr:Vault
 *     name: default
 *     properties:
 *       vaultName: terraform-example-${default.result}
 *   defaultFileSystem:
 *     type: alicloud:nas:FileSystem
 *     name: default
 *     properties:
 *       protocolType: NFS
 *       storageType: Performance
 *       description: terraform-example
 *       encryptType: '1'
 *   defaultNasBackupPlan:
 *     type: alicloud:hbr:NasBackupPlan
 *     name: default
 *     properties:
 *       nasBackupPlanName: terraform-example
 *       fileSystemId: ${defaultFileSystem.id}
 *       schedule: I|1602673264|PT2H
 *       backupType: COMPLETE
 *       vaultId: ${defaultVault.id}
 *       retention: '2'
 *       paths:
 *         - /
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * HBR Nas Backup Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/nasBackupPlan:NasBackupPlan example <id>
 * ```
 * @property backupType Backup type. Valid values: `COMPLETE`.
 * @property createTime This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
 * @property crossAccountRoleName The role name created in the original account RAM backup by the cross account managed by the current account.
 * > **Note** `alicloud.hbr.NasBackupPlan` depends on the `alicloud.nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
 * @property crossAccountType The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
 * @property crossAccountUserId The original account ID of the cross account backup managed by the current account.
 * @property disabled Whether to disable the backup task. Valid values: `true`, `false`.
 * @property fileSystemId The File System ID of Nas.
 * @property nasBackupPlanName The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
 * @property options This parameter specifies whether to use Windows VSS to define a backup path.
 * @property paths List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
 * @property retention Backup retention days, the minimum is 1.
 * @property schedule Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
 * * `startTime` Backup start time, UNIX time seconds.
 * @property vaultId The ID of Backup vault.
 */
public data class NasBackupPlanArgs(
    public val backupType: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'create_time' has been deprecated from provider version 1.153.0.
  """,
    )
    public val createTime: Output<String>? = null,
    public val crossAccountRoleName: Output<String>? = null,
    public val crossAccountType: Output<String>? = null,
    public val crossAccountUserId: Output<Int>? = null,
    public val disabled: Output<Boolean>? = null,
    public val fileSystemId: Output<String>? = null,
    public val nasBackupPlanName: Output<String>? = null,
    public val options: Output<String>? = null,
    public val paths: Output<List<String>>? = null,
    public val retention: Output<String>? = null,
    public val schedule: Output<String>? = null,
    public val vaultId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.NasBackupPlanArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.NasBackupPlanArgs =
        com.pulumi.alicloud.hbr.NasBackupPlanArgs.builder()
            .backupType(backupType?.applyValue({ args0 -> args0 }))
            .createTime(createTime?.applyValue({ args0 -> args0 }))
            .crossAccountRoleName(crossAccountRoleName?.applyValue({ args0 -> args0 }))
            .crossAccountType(crossAccountType?.applyValue({ args0 -> args0 }))
            .crossAccountUserId(crossAccountUserId?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .nasBackupPlanName(nasBackupPlanName?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0 }))
            .paths(paths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .retention(retention?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .vaultId(vaultId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NasBackupPlanArgs].
 */
@PulumiTagMarker
public class NasBackupPlanArgsBuilder internal constructor() {
    private var backupType: Output<String>? = null

    private var createTime: Output<String>? = null

    private var crossAccountRoleName: Output<String>? = null

    private var crossAccountType: Output<String>? = null

    private var crossAccountUserId: Output<Int>? = null

    private var disabled: Output<Boolean>? = null

    private var fileSystemId: Output<String>? = null

    private var nasBackupPlanName: Output<String>? = null

    private var options: Output<String>? = null

    private var paths: Output<List<String>>? = null

    private var retention: Output<String>? = null

    private var schedule: Output<String>? = null

    private var vaultId: Output<String>? = null

    /**
     * @param value Backup type. Valid values: `COMPLETE`.
     */
    @JvmName("icfpouoknilwsmyn")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
     */
    @Deprecated(
        message = """
  Field 'create_time' has been deprecated from provider version 1.153.0.
  """,
    )
    @JvmName("palitjlyymdaejvs")
    public suspend fun createTime(`value`: Output<String>) {
        this.createTime = value
    }

    /**
     * @param value The role name created in the original account RAM backup by the cross account managed by the current account.
     * > **Note** `alicloud.hbr.NasBackupPlan` depends on the `alicloud.nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
     */
    @JvmName("fbqytifpdismoqxc")
    public suspend fun crossAccountRoleName(`value`: Output<String>) {
        this.crossAccountRoleName = value
    }

    /**
     * @param value The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    @JvmName("htjtfmtfqyaljavg")
    public suspend fun crossAccountType(`value`: Output<String>) {
        this.crossAccountType = value
    }

    /**
     * @param value The original account ID of the cross account backup managed by the current account.
     */
    @JvmName("rernmpjvepftvloq")
    public suspend fun crossAccountUserId(`value`: Output<Int>) {
        this.crossAccountUserId = value
    }

    /**
     * @param value Whether to disable the backup task. Valid values: `true`, `false`.
     */
    @JvmName("dxkeynfxagnbngoe")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The File System ID of Nas.
     */
    @JvmName("kdfgassmjvmppyjr")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
     */
    @JvmName("oqgfcabomffxpgcb")
    public suspend fun nasBackupPlanName(`value`: Output<String>) {
        this.nasBackupPlanName = value
    }

    /**
     * @param value This parameter specifies whether to use Windows VSS to define a backup path.
     */
    @JvmName("ranmueqnkwtsohjs")
    public suspend fun options(`value`: Output<String>) {
        this.options = value
    }

    /**
     * @param value List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
     */
    @JvmName("bawgvjggrkrqdyhs")
    public suspend fun paths(`value`: Output<List<String>>) {
        this.paths = value
    }

    @JvmName("fyypspknljlpqovi")
    public suspend fun paths(vararg values: Output<String>) {
        this.paths = Output.all(values.asList())
    }

    /**
     * @param values List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
     */
    @JvmName("tpdafcxhxeilnepe")
    public suspend fun paths(values: List<Output<String>>) {
        this.paths = Output.all(values)
    }

    /**
     * @param value Backup retention days, the minimum is 1.
     */
    @JvmName("koqurityuxnaekfa")
    public suspend fun retention(`value`: Output<String>) {
        this.retention = value
    }

    /**
     * @param value Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * * `startTime` Backup start time, UNIX time seconds.
     */
    @JvmName("iwptxolaliigonre")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The ID of Backup vault.
     */
    @JvmName("qrarevrshkbrovif")
    public suspend fun vaultId(`value`: Output<String>) {
        this.vaultId = value
    }

    /**
     * @param value Backup type. Valid values: `COMPLETE`.
     */
    @JvmName("pirffdebjmhyscob")
    public suspend fun backupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
     */
    @Deprecated(
        message = """
  Field 'create_time' has been deprecated from provider version 1.153.0.
  """,
    )
    @JvmName("mfdumlxxtrwdccaf")
    public suspend fun createTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createTime = mapped
    }

    /**
     * @param value The role name created in the original account RAM backup by the cross account managed by the current account.
     * > **Note** `alicloud.hbr.NasBackupPlan` depends on the `alicloud.nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
     */
    @JvmName("golbayqymkyjmooc")
    public suspend fun crossAccountRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountRoleName = mapped
    }

    /**
     * @param value The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    @JvmName("oxryiphyfqkytham")
    public suspend fun crossAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountType = mapped
    }

    /**
     * @param value The original account ID of the cross account backup managed by the current account.
     */
    @JvmName("ckshjnotolbjkgar")
    public suspend fun crossAccountUserId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountUserId = mapped
    }

    /**
     * @param value Whether to disable the backup task. Valid values: `true`, `false`.
     */
    @JvmName("kohjvtogxwpnmlje")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value The File System ID of Nas.
     */
    @JvmName("vpytwejurdykwsay")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
     */
    @JvmName("yffcrtkottetjqlt")
    public suspend fun nasBackupPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nasBackupPlanName = mapped
    }

    /**
     * @param value This parameter specifies whether to use Windows VSS to define a backup path.
     */
    @JvmName("yumwccvbffxckqih")
    public suspend fun options(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
     */
    @JvmName("ocpqyetqsxwrwhgg")
    public suspend fun paths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param values List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
     */
    @JvmName("lkjpioymxusrfeuo")
    public suspend fun paths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param value Backup retention days, the minimum is 1.
     */
    @JvmName("wxjqqrnkvldgagot")
    public suspend fun retention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    /**
     * @param value Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * * `startTime` Backup start time, UNIX time seconds.
     */
    @JvmName("bgkkfatkvdgcdfqw")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The ID of Backup vault.
     */
    @JvmName("tifpjbymifvxudsf")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultId = mapped
    }

    internal fun build(): NasBackupPlanArgs = NasBackupPlanArgs(
        backupType = backupType,
        createTime = createTime,
        crossAccountRoleName = crossAccountRoleName,
        crossAccountType = crossAccountType,
        crossAccountUserId = crossAccountUserId,
        disabled = disabled,
        fileSystemId = fileSystemId,
        nasBackupPlanName = nasBackupPlanName,
        options = options,
        paths = paths,
        retention = retention,
        schedule = schedule,
        vaultId = vaultId,
    )
}
