@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OssBackupPlan].
 */
@PulumiTagMarker
public class OssBackupPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OssBackupPlanArgs = OssBackupPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OssBackupPlanArgsBuilder.() -> Unit) {
        val builder = OssBackupPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OssBackupPlan {
        val builtJavaResource = com.pulumi.alicloud.hbr.OssBackupPlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OssBackupPlan(builtJavaResource)
    }
}

/**
 * Provides a HBR Oss Backup Plan resource.
 * For information about HBR Oss Backup Plan and how to use it, see [What is Oss Backup Plan](https://www.alibabacloud.com/help/doc-detail/130040.htm).
 * > **NOTE:** Available since v1.131.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultVault = new alicloud.hbr.Vault("default", {vaultName: `terraform-example-${_default.result}`});
 * const defaultBucket = new alicloud.oss.Bucket("default", {bucket: `terraform-example-${_default.result}`});
 * const defaultOssBackupPlan = new alicloud.hbr.OssBackupPlan("default", {
 *     ossBackupPlanName: "terraform-example",
 *     prefix: "/example",
 *     bucket: defaultBucket.bucket,
 *     vaultId: defaultVault.id,
 *     schedule: "I|1602673264|PT2H",
 *     backupType: "COMPLETE",
 *     retention: "2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_vault = alicloud.hbr.Vault("default", vault_name=f"terraform-example-{default['result']}")
 * default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default['result']}")
 * default_oss_backup_plan = alicloud.hbr.OssBackupPlan("default",
 *     oss_backup_plan_name="terraform-example",
 *     prefix="/example",
 *     bucket=default_bucket.bucket,
 *     vault_id=default_vault.id,
 *     schedule="I|1602673264|PT2H",
 *     backup_type="COMPLETE",
 *     retention="2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultVault = new AliCloud.Hbr.Vault("default", new()
 *     {
 *         VaultName = $"terraform-example-{@default.Result}",
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{@default.Result}",
 *     });
 *     var defaultOssBackupPlan = new AliCloud.Hbr.OssBackupPlan("default", new()
 *     {
 *         OssBackupPlanName = "terraform-example",
 *         Prefix = "/example",
 *         Bucket = defaultBucket.BucketName,
 *         VaultId = defaultVault.Id,
 *         Schedule = "I|1602673264|PT2H",
 *         BackupType = "COMPLETE",
 *         Retention = "2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVault, err := hbr.NewVault(ctx, "default", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewOssBackupPlan(ctx, "default", &hbr.OssBackupPlanArgs{
 * 			OssBackupPlanName: pulumi.String("terraform-example"),
 * 			Prefix:            pulumi.String("/example"),
 * 			Bucket:            defaultBucket.Bucket,
 * 			VaultId:           defaultVault.ID(),
 * 			Schedule:          pulumi.String("I|1602673264|PT2H"),
 * 			BackupType:        pulumi.String("COMPLETE"),
 * 			Retention:         pulumi.String("2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.hbr.OssBackupPlan;
 * import com.pulumi.alicloud.hbr.OssBackupPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultVault = new Vault("defaultVault", VaultArgs.builder()
 *             .vaultName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var defaultOssBackupPlan = new OssBackupPlan("defaultOssBackupPlan", OssBackupPlanArgs.builder()
 *             .ossBackupPlanName("terraform-example")
 *             .prefix("/example")
 *             .bucket(defaultBucket.bucket())
 *             .vaultId(defaultVault.id())
 *             .schedule("I|1602673264|PT2H")
 *             .backupType("COMPLETE")
 *             .retention("2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultVault:
 *     type: alicloud:hbr:Vault
 *     name: default
 *     properties:
 *       vaultName: terraform-example-${default.result}
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${default.result}
 *   defaultOssBackupPlan:
 *     type: alicloud:hbr:OssBackupPlan
 *     name: default
 *     properties:
 *       ossBackupPlanName: terraform-example
 *       prefix: /example
 *       bucket: ${defaultBucket.bucket}
 *       vaultId: ${defaultVault.id}
 *       schedule: I|1602673264|PT2H
 *       backupType: COMPLETE
 *       retention: '2'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * HBR Oss Backup Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/ossBackupPlan:OssBackupPlan example <id>
 * ```
 */
public class OssBackupPlan internal constructor(
    override val javaResource: com.pulumi.alicloud.hbr.OssBackupPlan,
) : KotlinCustomResource(javaResource, OssBackupPlanMapper) {
    /**
     * Backup type. Valid values: `COMPLETE`.
     */
    public val backupType: Output<String>
        get() = javaResource.backupType().applyValue({ args0 -> args0 })

    /**
     * The name of OSS bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * The role name created in the original account RAM backup by the cross account managed by the current account.
     */
    public val crossAccountRoleName: Output<String>?
        get() = javaResource.crossAccountRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    public val crossAccountType: Output<String>
        get() = javaResource.crossAccountType().applyValue({ args0 -> args0 })

    /**
     * The original account ID of the cross account backup managed by the current account.
     */
    public val crossAccountUserId: Output<Int>?
        get() = javaResource.crossAccountUserId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to disable the backup task. Valid values: `true`, `false`.
     */
    public val disabled: Output<Boolean>
        get() = javaResource.disabled().applyValue({ args0 -> args0 })

    /**
     * The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
     */
    public val ossBackupPlanName: Output<String>
        get() = javaResource.ossBackupPlanName().applyValue({ args0 -> args0 })

    /**
     * Backup prefix. Once specified, only objects with matching prefixes will be backed up.
     */
    public val prefix: Output<String>?
        get() = javaResource.prefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Backup retention days, the minimum is 1.
     */
    public val retention: Output<String>
        get() = javaResource.retention().applyValue({ args0 -> args0 })

    /**
     * Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * * `startTime` Backup start time, UNIX time seconds.
     */
    public val schedule: Output<String>
        get() = javaResource.schedule().applyValue({ args0 -> args0 })

    /**
     * The ID of backup vault.
     */
    public val vaultId: Output<String>
        get() = javaResource.vaultId().applyValue({ args0 -> args0 })
}

public object OssBackupPlanMapper : ResourceMapper<OssBackupPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.hbr.OssBackupPlan::class == javaResource::class

    override fun map(javaResource: Resource): OssBackupPlan = OssBackupPlan(
        javaResource as
            com.pulumi.alicloud.hbr.OssBackupPlan,
    )
}

/**
 * @see [OssBackupPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OssBackupPlan].
 */
public suspend fun ossBackupPlan(
    name: String,
    block: suspend OssBackupPlanResourceBuilder.() -> Unit,
): OssBackupPlan {
    val builder = OssBackupPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OssBackupPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ossBackupPlan(name: String): OssBackupPlan {
    val builder = OssBackupPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
