@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.OssBackupPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a HBR Oss Backup Plan resource.
 * For information about HBR Oss Backup Plan and how to use it, see [What is Oss Backup Plan](https://www.alibabacloud.com/help/doc-detail/130040.htm).
 * > **NOTE:** Available since v1.131.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultVault = new alicloud.hbr.Vault("default", {vaultName: `terraform-example-${_default.result}`});
 * const defaultBucket = new alicloud.oss.Bucket("default", {bucket: `terraform-example-${_default.result}`});
 * const defaultOssBackupPlan = new alicloud.hbr.OssBackupPlan("default", {
 *     ossBackupPlanName: "terraform-example",
 *     prefix: "/example",
 *     bucket: defaultBucket.bucket,
 *     vaultId: defaultVault.id,
 *     schedule: "I|1602673264|PT2H",
 *     backupType: "COMPLETE",
 *     retention: "2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_vault = alicloud.hbr.Vault("default", vault_name=f"terraform-example-{default['result']}")
 * default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default['result']}")
 * default_oss_backup_plan = alicloud.hbr.OssBackupPlan("default",
 *     oss_backup_plan_name="terraform-example",
 *     prefix="/example",
 *     bucket=default_bucket.bucket,
 *     vault_id=default_vault.id,
 *     schedule="I|1602673264|PT2H",
 *     backup_type="COMPLETE",
 *     retention="2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultVault = new AliCloud.Hbr.Vault("default", new()
 *     {
 *         VaultName = $"terraform-example-{@default.Result}",
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{@default.Result}",
 *     });
 *     var defaultOssBackupPlan = new AliCloud.Hbr.OssBackupPlan("default", new()
 *     {
 *         OssBackupPlanName = "terraform-example",
 *         Prefix = "/example",
 *         Bucket = defaultBucket.BucketName,
 *         VaultId = defaultVault.Id,
 *         Schedule = "I|1602673264|PT2H",
 *         BackupType = "COMPLETE",
 *         Retention = "2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVault, err := hbr.NewVault(ctx, "default", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewOssBackupPlan(ctx, "default", &hbr.OssBackupPlanArgs{
 * 			OssBackupPlanName: pulumi.String("terraform-example"),
 * 			Prefix:            pulumi.String("/example"),
 * 			Bucket:            defaultBucket.Bucket,
 * 			VaultId:           defaultVault.ID(),
 * 			Schedule:          pulumi.String("I|1602673264|PT2H"),
 * 			BackupType:        pulumi.String("COMPLETE"),
 * 			Retention:         pulumi.String("2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.hbr.OssBackupPlan;
 * import com.pulumi.alicloud.hbr.OssBackupPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultVault = new Vault("defaultVault", VaultArgs.builder()
 *             .vaultName(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", default_.result()))
 *             .build());
 *         var defaultOssBackupPlan = new OssBackupPlan("defaultOssBackupPlan", OssBackupPlanArgs.builder()
 *             .ossBackupPlanName("terraform-example")
 *             .prefix("/example")
 *             .bucket(defaultBucket.bucket())
 *             .vaultId(defaultVault.id())
 *             .schedule("I|1602673264|PT2H")
 *             .backupType("COMPLETE")
 *             .retention("2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultVault:
 *     type: alicloud:hbr:Vault
 *     name: default
 *     properties:
 *       vaultName: terraform-example-${default.result}
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${default.result}
 *   defaultOssBackupPlan:
 *     type: alicloud:hbr:OssBackupPlan
 *     name: default
 *     properties:
 *       ossBackupPlanName: terraform-example
 *       prefix: /example
 *       bucket: ${defaultBucket.bucket}
 *       vaultId: ${defaultVault.id}
 *       schedule: I|1602673264|PT2H
 *       backupType: COMPLETE
 *       retention: '2'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * HBR Oss Backup Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/ossBackupPlan:OssBackupPlan example <id>
 * ```
 * @property backupType Backup type. Valid values: `COMPLETE`.
 * @property bucket The name of OSS bucket.
 * @property crossAccountRoleName The role name created in the original account RAM backup by the cross account managed by the current account.
 * @property crossAccountType The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
 * @property crossAccountUserId The original account ID of the cross account backup managed by the current account.
 * @property disabled Whether to disable the backup task. Valid values: `true`, `false`.
 * @property ossBackupPlanName The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
 * @property prefix Backup prefix. Once specified, only objects with matching prefixes will be backed up.
 * @property retention Backup retention days, the minimum is 1.
 * @property schedule Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
 * * `startTime` Backup start time, UNIX time seconds.
 * @property vaultId The ID of backup vault.
 */
public data class OssBackupPlanArgs(
    public val backupType: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val crossAccountRoleName: Output<String>? = null,
    public val crossAccountType: Output<String>? = null,
    public val crossAccountUserId: Output<Int>? = null,
    public val disabled: Output<Boolean>? = null,
    public val ossBackupPlanName: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val retention: Output<String>? = null,
    public val schedule: Output<String>? = null,
    public val vaultId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.OssBackupPlanArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.OssBackupPlanArgs =
        com.pulumi.alicloud.hbr.OssBackupPlanArgs.builder()
            .backupType(backupType?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .crossAccountRoleName(crossAccountRoleName?.applyValue({ args0 -> args0 }))
            .crossAccountType(crossAccountType?.applyValue({ args0 -> args0 }))
            .crossAccountUserId(crossAccountUserId?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .ossBackupPlanName(ossBackupPlanName?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .retention(retention?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .vaultId(vaultId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OssBackupPlanArgs].
 */
@PulumiTagMarker
public class OssBackupPlanArgsBuilder internal constructor() {
    private var backupType: Output<String>? = null

    private var bucket: Output<String>? = null

    private var crossAccountRoleName: Output<String>? = null

    private var crossAccountType: Output<String>? = null

    private var crossAccountUserId: Output<Int>? = null

    private var disabled: Output<Boolean>? = null

    private var ossBackupPlanName: Output<String>? = null

    private var prefix: Output<String>? = null

    private var retention: Output<String>? = null

    private var schedule: Output<String>? = null

    private var vaultId: Output<String>? = null

    /**
     * @param value Backup type. Valid values: `COMPLETE`.
     */
    @JvmName("dpykqbxhxgxdnwat")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value The name of OSS bucket.
     */
    @JvmName("qxneaxswhaqsshwp")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The role name created in the original account RAM backup by the cross account managed by the current account.
     */
    @JvmName("jexxtsvskepelppy")
    public suspend fun crossAccountRoleName(`value`: Output<String>) {
        this.crossAccountRoleName = value
    }

    /**
     * @param value The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    @JvmName("dqwiayxrrmsfixna")
    public suspend fun crossAccountType(`value`: Output<String>) {
        this.crossAccountType = value
    }

    /**
     * @param value The original account ID of the cross account backup managed by the current account.
     */
    @JvmName("cqiyjicweojhcner")
    public suspend fun crossAccountUserId(`value`: Output<Int>) {
        this.crossAccountUserId = value
    }

    /**
     * @param value Whether to disable the backup task. Valid values: `true`, `false`.
     */
    @JvmName("yvheljfncwhevdsw")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
     */
    @JvmName("qlcyryjbjkeyxkfu")
    public suspend fun ossBackupPlanName(`value`: Output<String>) {
        this.ossBackupPlanName = value
    }

    /**
     * @param value Backup prefix. Once specified, only objects with matching prefixes will be backed up.
     */
    @JvmName("rarfkjjyblpxcyom")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Backup retention days, the minimum is 1.
     */
    @JvmName("rodcgthgsejafafh")
    public suspend fun retention(`value`: Output<String>) {
        this.retention = value
    }

    /**
     * @param value Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * * `startTime` Backup start time, UNIX time seconds.
     */
    @JvmName("kaagxusggimqrsqc")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The ID of backup vault.
     */
    @JvmName("qnnxbsvynqfsaxml")
    public suspend fun vaultId(`value`: Output<String>) {
        this.vaultId = value
    }

    /**
     * @param value Backup type. Valid values: `COMPLETE`.
     */
    @JvmName("pqhdteakkgeqxibx")
    public suspend fun backupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value The name of OSS bucket.
     */
    @JvmName("niosiaovjrpaouvp")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The role name created in the original account RAM backup by the cross account managed by the current account.
     */
    @JvmName("cerwqucrvqlpcvqe")
    public suspend fun crossAccountRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountRoleName = mapped
    }

    /**
     * @param value The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    @JvmName("dnvppyqkllejlipm")
    public suspend fun crossAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountType = mapped
    }

    /**
     * @param value The original account ID of the cross account backup managed by the current account.
     */
    @JvmName("yenumxwoxuvrvkck")
    public suspend fun crossAccountUserId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountUserId = mapped
    }

    /**
     * @param value Whether to disable the backup task. Valid values: `true`, `false`.
     */
    @JvmName("faaksebevukeudat")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
     */
    @JvmName("avvlrpmsfpirhucy")
    public suspend fun ossBackupPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBackupPlanName = mapped
    }

    /**
     * @param value Backup prefix. Once specified, only objects with matching prefixes will be backed up.
     */
    @JvmName("xrwpsxgnlulwmcmy")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Backup retention days, the minimum is 1.
     */
    @JvmName("krmgwbxupbhrajkb")
    public suspend fun retention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    /**
     * @param value Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * * `startTime` Backup start time, UNIX time seconds.
     */
    @JvmName("twcvhhvnojexxncs")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The ID of backup vault.
     */
    @JvmName("nmbtktoboyhkrghu")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultId = mapped
    }

    internal fun build(): OssBackupPlanArgs = OssBackupPlanArgs(
        backupType = backupType,
        bucket = bucket,
        crossAccountRoleName = crossAccountRoleName,
        crossAccountType = crossAccountType,
        crossAccountUserId = crossAccountUserId,
        disabled = disabled,
        ossBackupPlanName = ossBackupPlanName,
        prefix = prefix,
        retention = retention,
        schedule = schedule,
        vaultId = vaultId,
    )
}
