@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.OtsBackupPlanArgs.builder
import com.pulumi.alicloud.hbr.kotlin.inputs.OtsBackupPlanOtsDetailArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.OtsBackupPlanOtsDetailArgsBuilder
import com.pulumi.alicloud.hbr.kotlin.inputs.OtsBackupPlanRuleArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.OtsBackupPlanRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a HBR Ots Backup Plan resource.
 * For information about HBR Ots Backup Plan and how to use it, see [What is Ots Backup Plan](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/overview).
 * > **NOTE:** Available in v1.163.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const defaultInteger = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultVault = new alicloud.hbr.Vault("default", {
 *     vaultName: `terraform-example-${defaultInteger.result}`,
 *     vaultType: "OTS_BACKUP",
 * });
 * const defaultInstance = new alicloud.ots.Instance("default", {
 *     name: `Example-${defaultInteger.result}`,
 *     description: "terraform-example",
 *     accessedBy: "Any",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultTable = new alicloud.ots.Table("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: "terraform_example",
 *     primaryKeys: [{
 *         name: "pk1",
 *         type: "Integer",
 *     }],
 *     timeToLive: -1,
 *     maxVersion: 1,
 *     deviationCellVersionInSec: "1",
 * });
 * const defaultRole = new alicloud.ram.Role("default", {
 *     name: "hbrexamplerole",
 *     document: `\x09\x09{
 * \x09\x09\x09"Statement": [
 * \x09\x09\x09{
 * \x09\x09\x09\x09"Action": "sts:AssumeRole",
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Principal": {
 * \x09\x09\x09\x09\x09"Service": [
 * \x09\x09\x09\x09\x09\x09"crossbackup.hbr.aliyuncs.com"
 * \x09\x09\x09\x09\x09]
 * \x09\x09\x09\x09}
 * \x09\x09\x09}
 * \x09\x09\x09],
 *   \x09\x09\x09"Version": "1"
 * \x09\x09}
 * `,
 *     force: true,
 * });
 * const default = alicloud.getAccount({});
 * const example = new alicloud.hbr.OtsBackupPlan("example", {
 *     otsBackupPlanName: `terraform-example-${defaultInteger.result}`,
 *     vaultId: defaultVault.id,
 *     backupType: "COMPLETE",
 *     retention: "1",
 *     instanceName: defaultInstance.name,
 *     crossAccountType: "SELF_ACCOUNT",
 *     crossAccountUserId: _default.then(_default => _default.id),
 *     crossAccountRoleName: defaultRole.id,
 *     otsDetails: [{
 *         tableNames: [defaultTable&#46;tableName],
 *     }],
 *     rules: [{
 *         schedule: "I|1602673264|PT2H",
 *         retention: "1",
 *         disabled: false,
 *         ruleName: "terraform-example",
 *         backupType: "COMPLETE",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default_integer = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_vault = alicloud.hbr.Vault("default",
 *     vault_name=f"terraform-example-{default_integer['result']}",
 *     vault_type="OTS_BACKUP")
 * default_instance = alicloud.ots.Instance("default",
 *     name=f"Example-{default_integer['result']}",
 *     description="terraform-example",
 *     accessed_by="Any",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_table = alicloud.ots.Table("default",
 *     instance_name=default_instance.name,
 *     table_name="terraform_example",
 *     primary_keys=[{
 *         "name": "pk1",
 *         "type": "Integer",
 *     }],
 *     time_to_live=-1,
 *     max_version=1,
 *     deviation_cell_version_in_sec="1")
 * default_role = alicloud.ram.Role("default",
 *     name="hbrexamplerole",
 *     document="""\x09\x09{
 * \x09\x09\x09"Statement": [
 * \x09\x09\x09{
 * \x09\x09\x09\x09"Action": "sts:AssumeRole",
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Principal": {
 * \x09\x09\x09\x09\x09"Service": [
 * \x09\x09\x09\x09\x09\x09"crossbackup.hbr.aliyuncs.com"
 * \x09\x09\x09\x09\x09]
 * \x09\x09\x09\x09}
 * \x09\x09\x09}
 * \x09\x09\x09],
 *   \x09\x09\x09"Version": "1"
 * \x09\x09}
 * """,
 *     force=True)
 * default = alicloud.get_account()
 * example = alicloud.hbr.OtsBackupPlan("example",
 *     ots_backup_plan_name=f"terraform-example-{default_integer['result']}",
 *     vault_id=default_vault.id,
 *     backup_type="COMPLETE",
 *     retention="1",
 *     instance_name=default_instance.name,
 *     cross_account_type="SELF_ACCOUNT",
 *     cross_account_user_id=default.id,
 *     cross_account_role_name=default_role.id,
 *     ots_details=[{
 *         "table_names": [default_table&#46;table_name],
 *     }],
 *     rules=[{
 *         "schedule": "I|1602673264|PT2H",
 *         "retention": "1",
 *         "disabled": False,
 *         "rule_name": "terraform-example",
 *         "backup_type": "COMPLETE",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultVault = new AliCloud.Hbr.Vault("default", new()
 *     {
 *         VaultName = $"terraform-example-{defaultInteger.Result}",
 *         VaultType = "OTS_BACKUP",
 *     });
 *     var defaultInstance = new AliCloud.Ots.Instance("default", new()
 *     {
 *         Name = $"Example-{defaultInteger.Result}",
 *         Description = "terraform-example",
 *         AccessedBy = "Any",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultTable = new AliCloud.Ots.Table("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = "terraform_example",
 *         PrimaryKeys = new[]
 *         {
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk1",
 *                 Type = "Integer",
 *             },
 *         },
 *         TimeToLive = -1,
 *         MaxVersion = 1,
 *         DeviationCellVersionInSec = "1",
 *     });
 *     var defaultRole = new AliCloud.Ram.Role("default", new()
 *     {
 *         Name = "hbrexamplerole",
 *         Document = @"		{
 * 			""Statement"": [
 * 			{
 * 				""Action"": ""sts:AssumeRole"",
 * 				""Effect"": ""Allow"",
 * 				""Principal"": {
 * 					""Service"": [
 * 						""crossbackup.hbr.aliyuncs.com""
 * 					]
 * 				}
 * 			}
 * 			],
 *   			""Version"": ""1""
 * 		}
 * ",
 *         Force = true,
 *     });
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var example = new AliCloud.Hbr.OtsBackupPlan("example", new()
 *     {
 *         OtsBackupPlanName = $"terraform-example-{defaultInteger.Result}",
 *         VaultId = defaultVault.Id,
 *         BackupType = "COMPLETE",
 *         Retention = "1",
 *         InstanceName = defaultInstance.Name,
 *         CrossAccountType = "SELF_ACCOUNT",
 *         CrossAccountUserId = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *         CrossAccountRoleName = defaultRole.Id,
 *         OtsDetails = new[]
 *         {
 *             new AliCloud.Hbr.Inputs.OtsBackupPlanOtsDetailArgs
 *             {
 *                 TableNames = new[]
 *                 {
 *                     defaultTable.TableName,
 *                 },
 *             },
 *         },
 *         Rules = new[]
 *         {
 *             new AliCloud.Hbr.Inputs.OtsBackupPlanRuleArgs
 *             {
 *                 Schedule = "I|1602673264|PT2H",
 *                 Retention = "1",
 *                 Disabled = false,
 *                 RuleName = "terraform-example",
 *                 BackupType = "COMPLETE",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVault, err := hbr.NewVault(ctx, "default", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 			VaultType: pulumi.String("OTS_BACKUP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ots.NewInstance(ctx, "default", &ots.InstanceArgs{
 * 			Name:        pulumi.Sprintf("Example-%v", defaultInteger.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 			AccessedBy:  pulumi.String("Any"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTable, err := ots.NewTable(ctx, "default", &ots.TableArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    pulumi.String("terraform_example"),
 * 			PrimaryKeys: ots.TablePrimaryKeyArray{
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk1"),
 * 					Type: pulumi.String("Integer"),
 * 				},
 * 			},
 * 			TimeToLive:                int(-1),
 * 			MaxVersion:                pulumi.Int(1),
 * 			DeviationCellVersionInSec: pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRole, err := ram.NewRole(ctx, "default", &ram.RoleArgs{
 * 			Name: pulumi.String("hbrexamplerole"),
 * 			Document: pulumi.String(`		{
 * 			"Statement": [
 * 			{
 * 				"Action": "sts:AssumeRole",
 * 				"Effect": "Allow",
 * 				"Principal": {
 * 					"Service": [
 * 						"crossbackup.hbr.aliyuncs.com"
 * 					]
 * 				}
 * 			}
 * 			],
 *   			"Version": "1"
 * 		}
 * `),
 * 			Force: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewOtsBackupPlan(ctx, "example", &hbr.OtsBackupPlanArgs{
 * 			OtsBackupPlanName:    pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 			VaultId:              defaultVault.ID(),
 * 			BackupType:           pulumi.String("COMPLETE"),
 * 			Retention:            pulumi.String("1"),
 * 			InstanceName:         defaultInstance.Name,
 * 			CrossAccountType:     pulumi.String("SELF_ACCOUNT"),
 * 			CrossAccountUserId:   pulumi.String(_default.Id),
 * 			CrossAccountRoleName: defaultRole.ID(),
 * 			OtsDetails: hbr.OtsBackupPlanOtsDetailArray{
 * 				&hbr.OtsBackupPlanOtsDetailArgs{
 * 					TableNames: pulumi.StringArray{
 * 						defaultTable.TableName,
 * 					},
 * 				},
 * 			},
 * 			Rules: hbr.OtsBackupPlanRuleArray{
 * 				&hbr.OtsBackupPlanRuleArgs{
 * 					Schedule:   pulumi.String("I|1602673264|PT2H"),
 * 					Retention:  pulumi.String("1"),
 * 					Disabled:   pulumi.Bool(false),
 * 					RuleName:   pulumi.String("terraform-example"),
 * 					BackupType: pulumi.String("COMPLETE"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultVault:
 *     type: alicloud:hbr:Vault
 *     name: default
 *     properties:
 *       vaultName: terraform-example-${defaultInteger.result}
 *       vaultType: OTS_BACKUP
 *   defaultInstance:
 *     type: alicloud:ots:Instance
 *     name: default
 *     properties:
 *       name: Example-${defaultInteger.result}
 *       description: terraform-example
 *       accessedBy: Any
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultTable:
 *     type: alicloud:ots:Table
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: terraform_example
 *       primaryKeys:
 *         - name: pk1
 *           type: Integer
 *       timeToLive: -1
 *       maxVersion: 1
 *       deviationCellVersionInSec: 1
 *   defaultRole:
 *     type: alicloud:ram:Role
 *     name: default
 *     properties:
 *       name: hbrexamplerole
 *       document: |
 *         		{
 *         			"Statement": [
 *         			{
 *         				"Action": "sts:AssumeRole",
 *         				"Effect": "Allow",
 *         				"Principal": {
 *         					"Service": [
 *         						"crossbackup.hbr.aliyuncs.com"
 *         					]
 *         				}
 *         			}
 *         			],
 *           			"Version": "1"
 *         		}
 *       force: true
 *   example:
 *     type: alicloud:hbr:OtsBackupPlan
 *     properties:
 *       otsBackupPlanName: terraform-example-${defaultInteger.result}
 *       vaultId: ${defaultVault.id}
 *       backupType: COMPLETE
 *       retention: '1'
 *       instanceName: ${defaultInstance.name}
 *       crossAccountType: SELF_ACCOUNT
 *       crossAccountUserId: ${default.id}
 *       crossAccountRoleName: ${defaultRole.id}
 *       otsDetails:
 *         - tableNames:
 *             - ${defaultTable.tableName}
 *       rules:
 *         - schedule: I|1602673264|PT2H
 *           retention: '1'
 *           disabled: 'false'
 *           ruleName: terraform-example
 *           backupType: COMPLETE
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * HBR Ots Backup Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/otsBackupPlan:OtsBackupPlan example <id>
 * ```
 * @property backupType Backup type. Valid values: `COMPLETE`.
 * @property crossAccountRoleName The role name created in the original account RAM backup by the cross account managed by the current account.
 * @property crossAccountType The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
 * @property crossAccountUserId The original account ID of the cross account backup managed by the current account.
 * @property disabled Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
 * @property instanceName The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
 * @property otsBackupPlanName The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
 * @property otsDetails The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
 * @property retention Backup retention days, the minimum is 1.
 * @property rules The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
 * @property schedule Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
 * - `startTime` Backup start time, UNIX time seconds.
 * @property vaultId The ID of backup vault.
 */
public data class OtsBackupPlanArgs(
    public val backupType: Output<String>? = null,
    public val crossAccountRoleName: Output<String>? = null,
    public val crossAccountType: Output<String>? = null,
    public val crossAccountUserId: Output<Int>? = null,
    public val disabled: Output<Boolean>? = null,
    public val instanceName: Output<String>? = null,
    public val otsBackupPlanName: Output<String>? = null,
    public val otsDetails: Output<List<OtsBackupPlanOtsDetailArgs>>? = null,
    public val retention: Output<String>? = null,
    public val rules: Output<List<OtsBackupPlanRuleArgs>>? = null,
    @Deprecated(
        message = """
  Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.
  """,
    )
    public val schedule: Output<String>? = null,
    public val vaultId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.OtsBackupPlanArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.OtsBackupPlanArgs =
        com.pulumi.alicloud.hbr.OtsBackupPlanArgs.builder()
            .backupType(backupType?.applyValue({ args0 -> args0 }))
            .crossAccountRoleName(crossAccountRoleName?.applyValue({ args0 -> args0 }))
            .crossAccountType(crossAccountType?.applyValue({ args0 -> args0 }))
            .crossAccountUserId(crossAccountUserId?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .otsBackupPlanName(otsBackupPlanName?.applyValue({ args0 -> args0 }))
            .otsDetails(
                otsDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .retention(retention?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .vaultId(vaultId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OtsBackupPlanArgs].
 */
@PulumiTagMarker
public class OtsBackupPlanArgsBuilder internal constructor() {
    private var backupType: Output<String>? = null

    private var crossAccountRoleName: Output<String>? = null

    private var crossAccountType: Output<String>? = null

    private var crossAccountUserId: Output<Int>? = null

    private var disabled: Output<Boolean>? = null

    private var instanceName: Output<String>? = null

    private var otsBackupPlanName: Output<String>? = null

    private var otsDetails: Output<List<OtsBackupPlanOtsDetailArgs>>? = null

    private var retention: Output<String>? = null

    private var rules: Output<List<OtsBackupPlanRuleArgs>>? = null

    private var schedule: Output<String>? = null

    private var vaultId: Output<String>? = null

    /**
     * @param value Backup type. Valid values: `COMPLETE`.
     */
    @JvmName("tcprpfaormaknhrn")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value The role name created in the original account RAM backup by the cross account managed by the current account.
     */
    @JvmName("nbxwfrhdstkyiacn")
    public suspend fun crossAccountRoleName(`value`: Output<String>) {
        this.crossAccountRoleName = value
    }

    /**
     * @param value The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    @JvmName("mtbjqskacthkryul")
    public suspend fun crossAccountType(`value`: Output<String>) {
        this.crossAccountType = value
    }

    /**
     * @param value The original account ID of the cross account backup managed by the current account.
     */
    @JvmName("lysxvlbonurfeufp")
    public suspend fun crossAccountUserId(`value`: Output<Int>) {
        this.crossAccountUserId = value
    }

    /**
     * @param value Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
     */
    @JvmName("emjwhvlivlmyephi")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("ukcmjibnhndypnid")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
     */
    @JvmName("jpdycwelrxnvrifd")
    public suspend fun otsBackupPlanName(`value`: Output<String>) {
        this.otsBackupPlanName = value
    }

    /**
     * @param value The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("ifyovmrrxvyjgmaw")
    public suspend fun otsDetails(`value`: Output<List<OtsBackupPlanOtsDetailArgs>>) {
        this.otsDetails = value
    }

    @JvmName("wdfkmrokbypscwua")
    public suspend fun otsDetails(vararg values: Output<OtsBackupPlanOtsDetailArgs>) {
        this.otsDetails = Output.all(values.asList())
    }

    /**
     * @param values The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("frhdxdlvxprnkrgw")
    public suspend fun otsDetails(values: List<Output<OtsBackupPlanOtsDetailArgs>>) {
        this.otsDetails = Output.all(values)
    }

    /**
     * @param value Backup retention days, the minimum is 1.
     */
    @JvmName("moarkeccljoqsvlq")
    public suspend fun retention(`value`: Output<String>) {
        this.retention = value
    }

    /**
     * @param value The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("ivcnllleglskgdnp")
    public suspend fun rules(`value`: Output<List<OtsBackupPlanRuleArgs>>) {
        this.rules = value
    }

    @JvmName("vlmiibedgmddiffv")
    public suspend fun rules(vararg values: Output<OtsBackupPlanRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("shkbrecyhdxxmonp")
    public suspend fun rules(values: List<Output<OtsBackupPlanRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * - `startTime` Backup start time, UNIX time seconds.
     */
    @Deprecated(
        message = """
  Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.
  """,
    )
    @JvmName("yiuaephddujfddov")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The ID of backup vault.
     */
    @JvmName("cktaenbvbsdoihyn")
    public suspend fun vaultId(`value`: Output<String>) {
        this.vaultId = value
    }

    /**
     * @param value Backup type. Valid values: `COMPLETE`.
     */
    @JvmName("idgfqojryaoftkuo")
    public suspend fun backupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value The role name created in the original account RAM backup by the cross account managed by the current account.
     */
    @JvmName("hxsisahiwacwmhsj")
    public suspend fun crossAccountRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountRoleName = mapped
    }

    /**
     * @param value The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    @JvmName("vghmgodrgpqnlxik")
    public suspend fun crossAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountType = mapped
    }

    /**
     * @param value The original account ID of the cross account backup managed by the current account.
     */
    @JvmName("fxjjysrnpcdgnxcb")
    public suspend fun crossAccountUserId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountUserId = mapped
    }

    /**
     * @param value Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
     */
    @JvmName("vvlysfaxnjnhwdad")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value The name of the Table store instance. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("gsqpreqcvrdttyxo")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
     */
    @JvmName("qleabmevindhnwiy")
    public suspend fun otsBackupPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.otsBackupPlanName = mapped
    }

    /**
     * @param value The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("qjkhunypjxwmstch")
    public suspend fun otsDetails(`value`: List<OtsBackupPlanOtsDetailArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.otsDetails = mapped
    }

    /**
     * @param argument The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("aocjwfhivvtpepwf")
    public suspend fun otsDetails(argument: List<suspend OtsBackupPlanOtsDetailArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OtsBackupPlanOtsDetailArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.otsDetails = mapped
    }

    /**
     * @param argument The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("oddbtjxgtbnfrixy")
    public suspend fun otsDetails(vararg argument: suspend OtsBackupPlanOtsDetailArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OtsBackupPlanOtsDetailArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.otsDetails = mapped
    }

    /**
     * @param argument The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("pbanoxkuucjpfxjl")
    public suspend fun otsDetails(argument: suspend OtsBackupPlanOtsDetailArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OtsBackupPlanOtsDetailArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.otsDetails = mapped
    }

    /**
     * @param values The details about the Table store instance. See the following `Block ots_detail`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("hjiinjqlieodxnos")
    public suspend fun otsDetails(vararg values: OtsBackupPlanOtsDetailArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.otsDetails = mapped
    }

    /**
     * @param value Backup retention days, the minimum is 1.
     */
    @JvmName("kbimxsjcvttdedra")
    public suspend fun retention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    /**
     * @param value The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("nrtlablywfykvkfs")
    public suspend fun rules(`value`: List<OtsBackupPlanRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("mmhrnaeolqnsliqx")
    public suspend fun rules(argument: List<suspend OtsBackupPlanRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OtsBackupPlanRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("luavpxtifbmvcjpx")
    public suspend fun rules(vararg argument: suspend OtsBackupPlanRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OtsBackupPlanRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("unobbxupndgavpew")
    public suspend fun rules(argument: suspend OtsBackupPlanRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OtsBackupPlanRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The backup plan rule. See the following `Block rules`. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("ftqtgyrinhsynnkn")
    public suspend fun rules(vararg values: OtsBackupPlanRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * - `startTime` Backup start time, UNIX time seconds.
     */
    @Deprecated(
        message = """
  Field 'schedule' has been deprecated from version 1.163.0. Use 'rules' instead.
  """,
    )
    @JvmName("dcekyoaxjhdedcfj")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The ID of backup vault.
     */
    @JvmName("suchkgosbrxkjond")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultId = mapped
    }

    internal fun build(): OtsBackupPlanArgs = OtsBackupPlanArgs(
        backupType = backupType,
        crossAccountRoleName = crossAccountRoleName,
        crossAccountType = crossAccountType,
        crossAccountUserId = crossAccountUserId,
        disabled = disabled,
        instanceName = instanceName,
        otsBackupPlanName = otsBackupPlanName,
        otsDetails = otsDetails,
        retention = retention,
        rules = rules,
        schedule = schedule,
        vaultId = vaultId,
    )
}
