@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.kotlin.outputs.PolicyRule
import com.pulumi.alicloud.hbr.kotlin.outputs.PolicyRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.alicloud.hbr.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Provides a HBR Policy resource.
 * For information about HBR Policy and how to use it, see [What is Policy](https://www.alibabacloud.com/help/en/cloud-backup/developer-reference/api-hbr-2017-09-08-createpolicyv2).
 * > **NOTE:** Available since v1.221.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultyk84Hc = new alicloud.hbr.Vault("defaultyk84Hc", {
 *     vaultType: "STANDARD",
 *     vaultName: `example-value-${_default.result}`,
 * });
 * const defaultoqWvHQ = new alicloud.hbr.Policy("defaultoqWvHQ", {
 *     policyName: `example-value-${_default.result}`,
 *     rules: [{
 *         ruleType: "BACKUP",
 *         backupType: "COMPLETE",
 *         schedule: "I|1631685600|P1D",
 *         retention: 7,
 *         archiveDays: 0,
 *         vaultId: defaultyk84Hc.id,
 *     }],
 *     policyDescription: "policy example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * defaultyk84_hc = alicloud.hbr.Vault("defaultyk84Hc",
 *     vault_type="STANDARD",
 *     vault_name=f"example-value-{default['result']}")
 * defaultoq_wv_hq = alicloud.hbr.Policy("defaultoqWvHQ",
 *     policy_name=f"example-value-{default['result']}",
 *     rules=[{
 *         "rule_type": "BACKUP",
 *         "backup_type": "COMPLETE",
 *         "schedule": "I|1631685600|P1D",
 *         "retention": 7,
 *         "archive_days": 0,
 *         "vault_id": defaultyk84_hc.id,
 *     }],
 *     policy_description="policy example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultyk84Hc = new AliCloud.Hbr.Vault("defaultyk84Hc", new()
 *     {
 *         VaultType = "STANDARD",
 *         VaultName = $"example-value-{@default.Result}",
 *     });
 *     var defaultoqWvHQ = new AliCloud.Hbr.Policy("defaultoqWvHQ", new()
 *     {
 *         PolicyName = $"example-value-{@default.Result}",
 *         Rules = new[]
 *         {
 *             new AliCloud.Hbr.Inputs.PolicyRuleArgs
 *             {
 *                 RuleType = "BACKUP",
 *                 BackupType = "COMPLETE",
 *                 Schedule = "I|1631685600|P1D",
 *                 Retention = 7,
 *                 ArchiveDays = 0,
 *                 VaultId = defaultyk84Hc.Id,
 *             },
 *         },
 *         PolicyDescription = "policy example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultyk84Hc, err := hbr.NewVault(ctx, "defaultyk84Hc", &hbr.VaultArgs{
 * 			VaultType: pulumi.String("STANDARD"),
 * 			VaultName: pulumi.Sprintf("example-value-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewPolicy(ctx, "defaultoqWvHQ", &hbr.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Rules: hbr.PolicyRuleArray{
 * 				&hbr.PolicyRuleArgs{
 * 					RuleType:    pulumi.String("BACKUP"),
 * 					BackupType:  pulumi.String("COMPLETE"),
 * 					Schedule:    pulumi.String("I|1631685600|P1D"),
 * 					Retention:   pulumi.Int(7),
 * 					ArchiveDays: pulumi.Int(0),
 * 					VaultId:     defaultyk84Hc.ID(),
 * 				},
 * 			},
 * 			PolicyDescription: pulumi.String("policy example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.hbr.Policy;
 * import com.pulumi.alicloud.hbr.PolicyArgs;
 * import com.pulumi.alicloud.hbr.inputs.PolicyRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultyk84Hc = new Vault("defaultyk84Hc", VaultArgs.builder()
 *             .vaultType("STANDARD")
 *             .vaultName(String.format("example-value-%s", default_.result()))
 *             .build());
 *         var defaultoqWvHQ = new Policy("defaultoqWvHQ", PolicyArgs.builder()
 *             .policyName(String.format("example-value-%s", default_.result()))
 *             .rules(PolicyRuleArgs.builder()
 *                 .ruleType("BACKUP")
 *                 .backupType("COMPLETE")
 *                 .schedule("I|1631685600|P1D")
 *                 .retention("7")
 *                 .archiveDays("0")
 *                 .vaultId(defaultyk84Hc.id())
 *                 .build())
 *             .policyDescription("policy example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultyk84Hc:
 *     type: alicloud:hbr:Vault
 *     properties:
 *       vaultType: STANDARD
 *       vaultName: example-value-${default.result}
 *   defaultoqWvHQ:
 *     type: alicloud:hbr:Policy
 *     properties:
 *       policyName: example-value-${default.result}
 *       rules:
 *         - ruleType: BACKUP
 *           backupType: COMPLETE
 *           schedule: I|1631685600|P1D
 *           retention: '7'
 *           archiveDays: '0'
 *           vaultId: ${defaultyk84Hc.id}
 *       policyDescription: policy example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * HBR Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/policy:Policy example <id>
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.alicloud.hbr.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * Policy creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The policy description.
     */
    public val policyDescription: Output<String>?
        get() = javaResource.policyDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Policy Name.
     */
    public val policyName: Output<String>?
        get() = javaResource.policyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of policy rules. See `rules` below.
     */
    public val rules: Output<List<PolicyRule>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.hbr.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.alicloud.hbr.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
