@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.kotlin.outputs.PolicyBindingAdvancedOptions
import com.pulumi.alicloud.hbr.kotlin.outputs.PolicyBindingAdvancedOptions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyBinding].
 */
@PulumiTagMarker
public class PolicyBindingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyBindingArgs = PolicyBindingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyBindingArgsBuilder.() -> Unit) {
        val builder = PolicyBindingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyBinding {
        val builtJavaResource = com.pulumi.alicloud.hbr.PolicyBinding(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PolicyBinding(builtJavaResource)
    }
}

/**
 * Provides a HBR Policy Binding resource. A policy binding relationship consists of a data source, a policy, and binding options.
 * For information about HBR Policy Binding and how to use it, see [What is Policy Binding](https://www.alibabacloud.com/help/en/cloud-backup/developer-reference/api-hbr-2017-09-08-createpolicybindings).
 * > **NOTE:** Available since v1.221.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultyk84Hc = new alicloud.hbr.Vault("defaultyk84Hc", {
 *     vaultType: "STANDARD",
 *     vaultName: `example-value-${_default.result}`,
 * });
 * const defaultoqWvHQ = new alicloud.hbr.Policy("defaultoqWvHQ", {
 *     policyName: `example-value-${_default.result}`,
 *     rules: [{
 *         ruleType: "BACKUP",
 *         backupType: "COMPLETE",
 *         schedule: "I|1631685600|P1D",
 *         retention: 7,
 *         archiveDays: 0,
 *         vaultId: defaultyk84Hc.id,
 *     }],
 *     policyDescription: "policy example",
 * });
 * const defaultKtt2XY = new alicloud.oss.Bucket("defaultKtt2XY", {
 *     storageClass: "Standard",
 *     bucket: `example-value-${_default.result}`,
 * });
 * const defaultPolicyBinding = new alicloud.hbr.PolicyBinding("default", {
 *     sourceType: "OSS",
 *     disabled: false,
 *     policyId: defaultoqWvHQ.id,
 *     dataSourceId: defaultKtt2XY.bucket,
 *     policyBindingDescription: "policy binding example (update)",
 *     source: "prefix-example-update/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * defaultyk84_hc = alicloud.hbr.Vault("defaultyk84Hc",
 *     vault_type="STANDARD",
 *     vault_name=f"example-value-{default['result']}")
 * defaultoq_wv_hq = alicloud.hbr.Policy("defaultoqWvHQ",
 *     policy_name=f"example-value-{default['result']}",
 *     rules=[{
 *         "rule_type": "BACKUP",
 *         "backup_type": "COMPLETE",
 *         "schedule": "I|1631685600|P1D",
 *         "retention": 7,
 *         "archive_days": 0,
 *         "vault_id": defaultyk84_hc.id,
 *     }],
 *     policy_description="policy example")
 * default_ktt2_xy = alicloud.oss.Bucket("defaultKtt2XY",
 *     storage_class="Standard",
 *     bucket=f"example-value-{default['result']}")
 * default_policy_binding = alicloud.hbr.PolicyBinding("default",
 *     source_type="OSS",
 *     disabled=False,
 *     policy_id=defaultoq_wv_hq.id,
 *     data_source_id=default_ktt2_xy.bucket,
 *     policy_binding_description="policy binding example (update)",
 *     source="prefix-example-update/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultyk84Hc = new AliCloud.Hbr.Vault("defaultyk84Hc", new()
 *     {
 *         VaultType = "STANDARD",
 *         VaultName = $"example-value-{@default.Result}",
 *     });
 *     var defaultoqWvHQ = new AliCloud.Hbr.Policy("defaultoqWvHQ", new()
 *     {
 *         PolicyName = $"example-value-{@default.Result}",
 *         Rules = new[]
 *         {
 *             new AliCloud.Hbr.Inputs.PolicyRuleArgs
 *             {
 *                 RuleType = "BACKUP",
 *                 BackupType = "COMPLETE",
 *                 Schedule = "I|1631685600|P1D",
 *                 Retention = 7,
 *                 ArchiveDays = 0,
 *                 VaultId = defaultyk84Hc.Id,
 *             },
 *         },
 *         PolicyDescription = "policy example",
 *     });
 *     var defaultKtt2XY = new AliCloud.Oss.Bucket("defaultKtt2XY", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"example-value-{@default.Result}",
 *     });
 *     var defaultPolicyBinding = new AliCloud.Hbr.PolicyBinding("default", new()
 *     {
 *         SourceType = "OSS",
 *         Disabled = false,
 *         PolicyId = defaultoqWvHQ.Id,
 *         DataSourceId = defaultKtt2XY.BucketName,
 *         PolicyBindingDescription = "policy binding example (update)",
 *         Source = "prefix-example-update/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultyk84Hc, err := hbr.NewVault(ctx, "defaultyk84Hc", &hbr.VaultArgs{
 * 			VaultType: pulumi.String("STANDARD"),
 * 			VaultName: pulumi.Sprintf("example-value-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultoqWvHQ, err := hbr.NewPolicy(ctx, "defaultoqWvHQ", &hbr.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Rules: hbr.PolicyRuleArray{
 * 				&hbr.PolicyRuleArgs{
 * 					RuleType:    pulumi.String("BACKUP"),
 * 					BackupType:  pulumi.String("COMPLETE"),
 * 					Schedule:    pulumi.String("I|1631685600|P1D"),
 * 					Retention:   pulumi.Int(7),
 * 					ArchiveDays: pulumi.Int(0),
 * 					VaultId:     defaultyk84Hc.ID(),
 * 				},
 * 			},
 * 			PolicyDescription: pulumi.String("policy example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultKtt2XY, err := oss.NewBucket(ctx, "defaultKtt2XY", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("example-value-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewPolicyBinding(ctx, "default", &hbr.PolicyBindingArgs{
 * 			SourceType:               pulumi.String("OSS"),
 * 			Disabled:                 pulumi.Bool(false),
 * 			PolicyId:                 defaultoqWvHQ.ID(),
 * 			DataSourceId:             defaultKtt2XY.Bucket,
 * 			PolicyBindingDescription: pulumi.String("policy binding example (update)"),
 * 			Source:                   pulumi.String("prefix-example-update/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.hbr.Policy;
 * import com.pulumi.alicloud.hbr.PolicyArgs;
 * import com.pulumi.alicloud.hbr.inputs.PolicyRuleArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.hbr.PolicyBinding;
 * import com.pulumi.alicloud.hbr.PolicyBindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultyk84Hc = new Vault("defaultyk84Hc", VaultArgs.builder()
 *             .vaultType("STANDARD")
 *             .vaultName(String.format("example-value-%s", default_.result()))
 *             .build());
 *         var defaultoqWvHQ = new Policy("defaultoqWvHQ", PolicyArgs.builder()
 *             .policyName(String.format("example-value-%s", default_.result()))
 *             .rules(PolicyRuleArgs.builder()
 *                 .ruleType("BACKUP")
 *                 .backupType("COMPLETE")
 *                 .schedule("I|1631685600|P1D")
 *                 .retention("7")
 *                 .archiveDays("0")
 *                 .vaultId(defaultyk84Hc.id())
 *                 .build())
 *             .policyDescription("policy example")
 *             .build());
 *         var defaultKtt2XY = new Bucket("defaultKtt2XY", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .build());
 *         var defaultPolicyBinding = new PolicyBinding("defaultPolicyBinding", PolicyBindingArgs.builder()
 *             .sourceType("OSS")
 *             .disabled("false")
 *             .policyId(defaultoqWvHQ.id())
 *             .dataSourceId(defaultKtt2XY.bucket())
 *             .policyBindingDescription("policy binding example (update)")
 *             .source("prefix-example-update/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultyk84Hc:
 *     type: alicloud:hbr:Vault
 *     properties:
 *       vaultType: STANDARD
 *       vaultName: example-value-${default.result}
 *   defaultoqWvHQ:
 *     type: alicloud:hbr:Policy
 *     properties:
 *       policyName: example-value-${default.result}
 *       rules:
 *         - ruleType: BACKUP
 *           backupType: COMPLETE
 *           schedule: I|1631685600|P1D
 *           retention: '7'
 *           archiveDays: '0'
 *           vaultId: ${defaultyk84Hc.id}
 *       policyDescription: policy example
 *   defaultKtt2XY:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       storageClass: Standard
 *       bucket: example-value-${default.result}
 *   defaultPolicyBinding:
 *     type: alicloud:hbr:PolicyBinding
 *     name: default
 *     properties:
 *       sourceType: OSS
 *       disabled: 'false'
 *       policyId: ${defaultoqWvHQ.id}
 *       dataSourceId: ${defaultKtt2XY.bucket}
 *       policyBindingDescription: policy binding example (update)
 *       source: prefix-example-update/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * HBR Policy Binding can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/policyBinding:PolicyBinding example <policy_id>:<source_type>:<data_source_id>
 * ```
 */
public class PolicyBinding internal constructor(
    override val javaResource: com.pulumi.alicloud.hbr.PolicyBinding,
) : KotlinCustomResource(javaResource, PolicyBindingMapper) {
    /**
     * Backup Advanced Options. See `advanced_options` below.
     */
    public val advancedOptions: Output<PolicyBindingAdvancedOptions>
        get() = javaResource.advancedOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The data source ID.
     */
    public val dataSourceId: Output<String>
        get() = javaResource.dataSourceId().applyValue({ args0 -> args0 })

    /**
     * Whether the policy is effective for the data source.
     * - true: Pause
     * - false: not paused.
     */
    public val disabled: Output<Boolean>?
        get() = javaResource.disabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
     */
    public val exclude: Output<String>?
        get() = javaResource.exclude().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
     */
    public val include: Output<String>?
        get() = javaResource.include().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Description.
     */
    public val policyBindingDescription: Output<String>?
        get() = javaResource.policyBindingDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy ID.
     */
    public val policyId: Output<String>
        get() = javaResource.policyId().applyValue({ args0 -> args0 })

    /**
     * When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
     */
    public val source: Output<String>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Data source type, value range:
     * - **UDM_ECS**: indicates the ECS instance backup.
     * - **OSS**: indicates an OSS backup.
     * - **NAS**: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
     * - **ECS_FILE**: indicates that the ECS file is backed up.
     * - **File**: indicates a local File backup.
     */
    public val sourceType: Output<String>
        get() = javaResource.sourceType().applyValue({ args0 -> args0 })

    /**
     * This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
     */
    public val speedLimit: Output<String>?
        get() = javaResource.speedLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object PolicyBindingMapper : ResourceMapper<PolicyBinding> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.hbr.PolicyBinding::class == javaResource::class

    override fun map(javaResource: Resource): PolicyBinding = PolicyBinding(
        javaResource as
            com.pulumi.alicloud.hbr.PolicyBinding,
    )
}

/**
 * @see [PolicyBinding].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyBinding].
 */
public suspend fun policyBinding(
    name: String,
    block: suspend PolicyBindingResourceBuilder.() -> Unit,
): PolicyBinding {
    val builder = PolicyBindingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyBinding].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyBinding(name: String): PolicyBinding {
    val builder = PolicyBindingResourceBuilder()
    builder.name(name)
    return builder.build()
}
