@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.PolicyBindingArgs.builder
import com.pulumi.alicloud.hbr.kotlin.inputs.PolicyBindingAdvancedOptionsArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.PolicyBindingAdvancedOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a HBR Policy Binding resource. A policy binding relationship consists of a data source, a policy, and binding options.
 * For information about HBR Policy Binding and how to use it, see [What is Policy Binding](https://www.alibabacloud.com/help/en/cloud-backup/developer-reference/api-hbr-2017-09-08-createpolicybindings).
 * > **NOTE:** Available since v1.221.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultyk84Hc = new alicloud.hbr.Vault("defaultyk84Hc", {
 *     vaultType: "STANDARD",
 *     vaultName: `example-value-${_default.result}`,
 * });
 * const defaultoqWvHQ = new alicloud.hbr.Policy("defaultoqWvHQ", {
 *     policyName: `example-value-${_default.result}`,
 *     rules: [{
 *         ruleType: "BACKUP",
 *         backupType: "COMPLETE",
 *         schedule: "I|1631685600|P1D",
 *         retention: 7,
 *         archiveDays: 0,
 *         vaultId: defaultyk84Hc.id,
 *     }],
 *     policyDescription: "policy example",
 * });
 * const defaultKtt2XY = new alicloud.oss.Bucket("defaultKtt2XY", {
 *     storageClass: "Standard",
 *     bucket: `example-value-${_default.result}`,
 * });
 * const defaultPolicyBinding = new alicloud.hbr.PolicyBinding("default", {
 *     sourceType: "OSS",
 *     disabled: false,
 *     policyId: defaultoqWvHQ.id,
 *     dataSourceId: defaultKtt2XY.bucket,
 *     policyBindingDescription: "policy binding example (update)",
 *     source: "prefix-example-update/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * defaultyk84_hc = alicloud.hbr.Vault("defaultyk84Hc",
 *     vault_type="STANDARD",
 *     vault_name=f"example-value-{default['result']}")
 * defaultoq_wv_hq = alicloud.hbr.Policy("defaultoqWvHQ",
 *     policy_name=f"example-value-{default['result']}",
 *     rules=[{
 *         "rule_type": "BACKUP",
 *         "backup_type": "COMPLETE",
 *         "schedule": "I|1631685600|P1D",
 *         "retention": 7,
 *         "archive_days": 0,
 *         "vault_id": defaultyk84_hc.id,
 *     }],
 *     policy_description="policy example")
 * default_ktt2_xy = alicloud.oss.Bucket("defaultKtt2XY",
 *     storage_class="Standard",
 *     bucket=f"example-value-{default['result']}")
 * default_policy_binding = alicloud.hbr.PolicyBinding("default",
 *     source_type="OSS",
 *     disabled=False,
 *     policy_id=defaultoq_wv_hq.id,
 *     data_source_id=default_ktt2_xy.bucket,
 *     policy_binding_description="policy binding example (update)",
 *     source="prefix-example-update/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultyk84Hc = new AliCloud.Hbr.Vault("defaultyk84Hc", new()
 *     {
 *         VaultType = "STANDARD",
 *         VaultName = $"example-value-{@default.Result}",
 *     });
 *     var defaultoqWvHQ = new AliCloud.Hbr.Policy("defaultoqWvHQ", new()
 *     {
 *         PolicyName = $"example-value-{@default.Result}",
 *         Rules = new[]
 *         {
 *             new AliCloud.Hbr.Inputs.PolicyRuleArgs
 *             {
 *                 RuleType = "BACKUP",
 *                 BackupType = "COMPLETE",
 *                 Schedule = "I|1631685600|P1D",
 *                 Retention = 7,
 *                 ArchiveDays = 0,
 *                 VaultId = defaultyk84Hc.Id,
 *             },
 *         },
 *         PolicyDescription = "policy example",
 *     });
 *     var defaultKtt2XY = new AliCloud.Oss.Bucket("defaultKtt2XY", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"example-value-{@default.Result}",
 *     });
 *     var defaultPolicyBinding = new AliCloud.Hbr.PolicyBinding("default", new()
 *     {
 *         SourceType = "OSS",
 *         Disabled = false,
 *         PolicyId = defaultoqWvHQ.Id,
 *         DataSourceId = defaultKtt2XY.BucketName,
 *         PolicyBindingDescription = "policy binding example (update)",
 *         Source = "prefix-example-update/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultyk84Hc, err := hbr.NewVault(ctx, "defaultyk84Hc", &hbr.VaultArgs{
 * 			VaultType: pulumi.String("STANDARD"),
 * 			VaultName: pulumi.Sprintf("example-value-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultoqWvHQ, err := hbr.NewPolicy(ctx, "defaultoqWvHQ", &hbr.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Rules: hbr.PolicyRuleArray{
 * 				&hbr.PolicyRuleArgs{
 * 					RuleType:    pulumi.String("BACKUP"),
 * 					BackupType:  pulumi.String("COMPLETE"),
 * 					Schedule:    pulumi.String("I|1631685600|P1D"),
 * 					Retention:   pulumi.Int(7),
 * 					ArchiveDays: pulumi.Int(0),
 * 					VaultId:     defaultyk84Hc.ID(),
 * 				},
 * 			},
 * 			PolicyDescription: pulumi.String("policy example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultKtt2XY, err := oss.NewBucket(ctx, "defaultKtt2XY", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("example-value-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewPolicyBinding(ctx, "default", &hbr.PolicyBindingArgs{
 * 			SourceType:               pulumi.String("OSS"),
 * 			Disabled:                 pulumi.Bool(false),
 * 			PolicyId:                 defaultoqWvHQ.ID(),
 * 			DataSourceId:             defaultKtt2XY.Bucket,
 * 			PolicyBindingDescription: pulumi.String("policy binding example (update)"),
 * 			Source:                   pulumi.String("prefix-example-update/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.hbr.Policy;
 * import com.pulumi.alicloud.hbr.PolicyArgs;
 * import com.pulumi.alicloud.hbr.inputs.PolicyRuleArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.hbr.PolicyBinding;
 * import com.pulumi.alicloud.hbr.PolicyBindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultyk84Hc = new Vault("defaultyk84Hc", VaultArgs.builder()
 *             .vaultType("STANDARD")
 *             .vaultName(String.format("example-value-%s", default_.result()))
 *             .build());
 *         var defaultoqWvHQ = new Policy("defaultoqWvHQ", PolicyArgs.builder()
 *             .policyName(String.format("example-value-%s", default_.result()))
 *             .rules(PolicyRuleArgs.builder()
 *                 .ruleType("BACKUP")
 *                 .backupType("COMPLETE")
 *                 .schedule("I|1631685600|P1D")
 *                 .retention("7")
 *                 .archiveDays("0")
 *                 .vaultId(defaultyk84Hc.id())
 *                 .build())
 *             .policyDescription("policy example")
 *             .build());
 *         var defaultKtt2XY = new Bucket("defaultKtt2XY", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .build());
 *         var defaultPolicyBinding = new PolicyBinding("defaultPolicyBinding", PolicyBindingArgs.builder()
 *             .sourceType("OSS")
 *             .disabled("false")
 *             .policyId(defaultoqWvHQ.id())
 *             .dataSourceId(defaultKtt2XY.bucket())
 *             .policyBindingDescription("policy binding example (update)")
 *             .source("prefix-example-update/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultyk84Hc:
 *     type: alicloud:hbr:Vault
 *     properties:
 *       vaultType: STANDARD
 *       vaultName: example-value-${default.result}
 *   defaultoqWvHQ:
 *     type: alicloud:hbr:Policy
 *     properties:
 *       policyName: example-value-${default.result}
 *       rules:
 *         - ruleType: BACKUP
 *           backupType: COMPLETE
 *           schedule: I|1631685600|P1D
 *           retention: '7'
 *           archiveDays: '0'
 *           vaultId: ${defaultyk84Hc.id}
 *       policyDescription: policy example
 *   defaultKtt2XY:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       storageClass: Standard
 *       bucket: example-value-${default.result}
 *   defaultPolicyBinding:
 *     type: alicloud:hbr:PolicyBinding
 *     name: default
 *     properties:
 *       sourceType: OSS
 *       disabled: 'false'
 *       policyId: ${defaultoqWvHQ.id}
 *       dataSourceId: ${defaultKtt2XY.bucket}
 *       policyBindingDescription: policy binding example (update)
 *       source: prefix-example-update/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * HBR Policy Binding can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/policyBinding:PolicyBinding example <policy_id>:<source_type>:<data_source_id>
 * ```
 * @property advancedOptions Backup Advanced Options. See `advanced_options` below.
 * @property dataSourceId The data source ID.
 * @property disabled Whether the policy is effective for the data source.
 * - true: Pause
 * - false: not paused.
 * @property exclude This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
 * @property include This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
 * @property policyBindingDescription Resource Description.
 * @property policyId The policy ID.
 * @property source When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
 * @property sourceType Data source type, value range:
 * - **UDM_ECS**: indicates the ECS instance backup.
 * - **OSS**: indicates an OSS backup.
 * - **NAS**: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
 * - **ECS_FILE**: indicates that the ECS file is backed up.
 * - **File**: indicates a local File backup.
 * @property speedLimit This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
 */
public data class PolicyBindingArgs(
    public val advancedOptions: Output<PolicyBindingAdvancedOptionsArgs>? = null,
    public val dataSourceId: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
    public val exclude: Output<String>? = null,
    public val include: Output<String>? = null,
    public val policyBindingDescription: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val source: Output<String>? = null,
    public val sourceType: Output<String>? = null,
    public val speedLimit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.PolicyBindingArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.PolicyBindingArgs =
        com.pulumi.alicloud.hbr.PolicyBindingArgs.builder()
            .advancedOptions(advancedOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataSourceId(dataSourceId?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .exclude(exclude?.applyValue({ args0 -> args0 }))
            .include(include?.applyValue({ args0 -> args0 }))
            .policyBindingDescription(policyBindingDescription?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .speedLimit(speedLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyBindingArgs].
 */
@PulumiTagMarker
public class PolicyBindingArgsBuilder internal constructor() {
    private var advancedOptions: Output<PolicyBindingAdvancedOptionsArgs>? = null

    private var dataSourceId: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    private var exclude: Output<String>? = null

    private var include: Output<String>? = null

    private var policyBindingDescription: Output<String>? = null

    private var policyId: Output<String>? = null

    private var source: Output<String>? = null

    private var sourceType: Output<String>? = null

    private var speedLimit: Output<String>? = null

    /**
     * @param value Backup Advanced Options. See `advanced_options` below.
     */
    @JvmName("acpljoowwxowqqsu")
    public suspend fun advancedOptions(`value`: Output<PolicyBindingAdvancedOptionsArgs>) {
        this.advancedOptions = value
    }

    /**
     * @param value The data source ID.
     */
    @JvmName("yihrdyhitjloyhhl")
    public suspend fun dataSourceId(`value`: Output<String>) {
        this.dataSourceId = value
    }

    /**
     * @param value Whether the policy is effective for the data source.
     * - true: Pause
     * - false: not paused.
     */
    @JvmName("fmdhpuwbglvsqhgo")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
     */
    @JvmName("oliejtqvynpdyvga")
    public suspend fun exclude(`value`: Output<String>) {
        this.exclude = value
    }

    /**
     * @param value This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
     */
    @JvmName("maudivvaodhvqiuo")
    public suspend fun include(`value`: Output<String>) {
        this.include = value
    }

    /**
     * @param value Resource Description.
     */
    @JvmName("aqmakgqmsfijcoru")
    public suspend fun policyBindingDescription(`value`: Output<String>) {
        this.policyBindingDescription = value
    }

    /**
     * @param value The policy ID.
     */
    @JvmName("siafrmrkmhnpqqoi")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
     */
    @JvmName("ldcvfpgtaimatlpw")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Data source type, value range:
     * - **UDM_ECS**: indicates the ECS instance backup.
     * - **OSS**: indicates an OSS backup.
     * - **NAS**: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
     * - **ECS_FILE**: indicates that the ECS file is backed up.
     * - **File**: indicates a local File backup.
     */
    @JvmName("ucdvmgprimllttlc")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
     */
    @JvmName("faiebouxibacwido")
    public suspend fun speedLimit(`value`: Output<String>) {
        this.speedLimit = value
    }

    /**
     * @param value Backup Advanced Options. See `advanced_options` below.
     */
    @JvmName("mvfnxfhhaatsimny")
    public suspend fun advancedOptions(`value`: PolicyBindingAdvancedOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedOptions = mapped
    }

    /**
     * @param argument Backup Advanced Options. See `advanced_options` below.
     */
    @JvmName("vmvsulomgxmtflfu")
    public suspend fun advancedOptions(argument: suspend PolicyBindingAdvancedOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyBindingAdvancedOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.advancedOptions = mapped
    }

    /**
     * @param value The data source ID.
     */
    @JvmName("wftdnjqeeafwcoys")
    public suspend fun dataSourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceId = mapped
    }

    /**
     * @param value Whether the policy is effective for the data source.
     * - true: Pause
     * - false: not paused.
     */
    @JvmName("sgrjwsfdxixfrvcr")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
     */
    @JvmName("tjyqydedarwvvnxw")
    public suspend fun exclude(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclude = mapped
    }

    /**
     * @param value This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
     */
    @JvmName("qbpcwlvdkjairrfw")
    public suspend fun include(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.include = mapped
    }

    /**
     * @param value Resource Description.
     */
    @JvmName("assxpqjetmraxppf")
    public suspend fun policyBindingDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyBindingDescription = mapped
    }

    /**
     * @param value The policy ID.
     */
    @JvmName("jkayouptxbxqjpue")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
     */
    @JvmName("dophuaxaqsqilmtm")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Data source type, value range:
     * - **UDM_ECS**: indicates the ECS instance backup.
     * - **OSS**: indicates an OSS backup.
     * - **NAS**: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
     * - **ECS_FILE**: indicates that the ECS file is backed up.
     * - **File**: indicates a local File backup.
     */
    @JvmName("fifgcqxithvoucbq")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
     */
    @JvmName("qisneuynntotvrbu")
    public suspend fun speedLimit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.speedLimit = mapped
    }

    internal fun build(): PolicyBindingArgs = PolicyBindingArgs(
        advancedOptions = advancedOptions,
        dataSourceId = dataSourceId,
        disabled = disabled,
        exclude = exclude,
        include = include,
        policyBindingDescription = policyBindingDescription,
        policyId = policyId,
        source = source,
        sourceType = sourceType,
        speedLimit = speedLimit,
    )
}
