@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.ReplicationVaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Hybrid Backup Recovery (HBR) Replication Vault resource.
 * For information about Hybrid Backup Recovery (HBR) Replication Vault and how to use it, see [What is Replication Vault](https://www.alibabacloud.com/help/en/doc-detail/345603.html).
 * > **NOTE:** Available in v1.152.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const sourceRegion = config.get("sourceRegion") || "cn-hangzhou";
 * const default = alicloud.hbr.getReplicationVaultRegions({});
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultVault = new alicloud.hbr.Vault("default", {vaultName: `terraform-example-${defaultInteger.result}`});
 * const defaultReplicationVault = new alicloud.hbr.ReplicationVault("default", {
 *     replicationSourceRegionId: sourceRegion,
 *     replicationSourceVaultId: defaultVault.id,
 *     vaultName: "terraform-example",
 *     vaultStorageClass: "STANDARD",
 *     description: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * source_region = config.get("sourceRegion")
 * if source_region is None:
 *     source_region = "cn-hangzhou"
 * default = alicloud.hbr.get_replication_vault_regions()
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_vault = alicloud.hbr.Vault("default", vault_name=f"terraform-example-{default_integer['result']}")
 * default_replication_vault = alicloud.hbr.ReplicationVault("default",
 *     replication_source_region_id=source_region,
 *     replication_source_vault_id=default_vault.id,
 *     vault_name="terraform-example",
 *     vault_storage_class="STANDARD",
 *     description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var sourceRegion = config.Get("sourceRegion") ?? "cn-hangzhou";
 *     var @default = AliCloud.Hbr.GetReplicationVaultRegions.Invoke();
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultVault = new AliCloud.Hbr.Vault("default", new()
 *     {
 *         VaultName = $"terraform-example-{defaultInteger.Result}",
 *     });
 *     var defaultReplicationVault = new AliCloud.Hbr.ReplicationVault("default", new()
 *     {
 *         ReplicationSourceRegionId = sourceRegion,
 *         ReplicationSourceVaultId = defaultVault.Id,
 *         VaultName = "terraform-example",
 *         VaultStorageClass = "STANDARD",
 *         Description = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		sourceRegion := "cn-hangzhou"
 * 		if param := cfg.Get("sourceRegion"); param != "" {
 * 			sourceRegion = param
 * 		}
 * 		_, err := hbr.GetReplicationVaultRegions(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVault, err := hbr.NewVault(ctx, "default", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewReplicationVault(ctx, "default", &hbr.ReplicationVaultArgs{
 * 			ReplicationSourceRegionId: pulumi.String(sourceRegion),
 * 			ReplicationSourceVaultId:  defaultVault.ID(),
 * 			VaultName:                 pulumi.String("terraform-example"),
 * 			VaultStorageClass:         pulumi.String("STANDARD"),
 * 			Description:               pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.hbr.HbrFunctions;
 * import com.pulumi.alicloud.hbr.inputs.GetReplicationVaultRegionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import com.pulumi.alicloud.hbr.ReplicationVault;
 * import com.pulumi.alicloud.hbr.ReplicationVaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var sourceRegion = config.get("sourceRegion").orElse("cn-hangzhou");
 *         final var default = HbrFunctions.getReplicationVaultRegions();
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultVault = new Vault("defaultVault", VaultArgs.builder()
 *             .vaultName(String.format("terraform-example-%s", defaultInteger.result()))
 *             .build());
 *         var defaultReplicationVault = new ReplicationVault("defaultReplicationVault", ReplicationVaultArgs.builder()
 *             .replicationSourceRegionId(sourceRegion)
 *             .replicationSourceVaultId(defaultVault.id())
 *             .vaultName("terraform-example")
 *             .vaultStorageClass("STANDARD")
 *             .description("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   sourceRegion:
 *     type: string
 *     default: cn-hangzhou
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultVault:
 *     type: alicloud:hbr:Vault
 *     name: default
 *     properties:
 *       vaultName: terraform-example-${defaultInteger.result}
 *   defaultReplicationVault:
 *     type: alicloud:hbr:ReplicationVault
 *     name: default
 *     properties:
 *       replicationSourceRegionId: ${sourceRegion}
 *       replicationSourceVaultId: ${defaultVault.id}
 *       vaultName: terraform-example
 *       vaultStorageClass: STANDARD
 *       description: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:hbr:getReplicationVaultRegions
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Hybrid Backup Recovery (HBR) Replication Vault can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/replicationVault:ReplicationVault example <id>
 * ```
 * @property description The description of the backup vault. The description must be 0 to 255 characters in length.
 * @property replicationSourceRegionId The ID of the region where the source vault resides.
 * @property replicationSourceVaultId The ID of the source vault.
 * @property vaultName The name of the backup vault. The name must be 1 to 64 characters in length.
 * @property vaultStorageClass The storage type of the backup vault. Valid values: `STANDARD`.
 */
public data class ReplicationVaultArgs(
    public val description: Output<String>? = null,
    public val replicationSourceRegionId: Output<String>? = null,
    public val replicationSourceVaultId: Output<String>? = null,
    public val vaultName: Output<String>? = null,
    public val vaultStorageClass: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.ReplicationVaultArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.ReplicationVaultArgs =
        com.pulumi.alicloud.hbr.ReplicationVaultArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .replicationSourceRegionId(replicationSourceRegionId?.applyValue({ args0 -> args0 }))
            .replicationSourceVaultId(replicationSourceVaultId?.applyValue({ args0 -> args0 }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 }))
            .vaultStorageClass(vaultStorageClass?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationVaultArgs].
 */
@PulumiTagMarker
public class ReplicationVaultArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var replicationSourceRegionId: Output<String>? = null

    private var replicationSourceVaultId: Output<String>? = null

    private var vaultName: Output<String>? = null

    private var vaultStorageClass: Output<String>? = null

    /**
     * @param value The description of the backup vault. The description must be 0 to 255 characters in length.
     */
    @JvmName("uekxxhleredgulio")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the region where the source vault resides.
     */
    @JvmName("arlouuyxyjiykgqj")
    public suspend fun replicationSourceRegionId(`value`: Output<String>) {
        this.replicationSourceRegionId = value
    }

    /**
     * @param value The ID of the source vault.
     */
    @JvmName("eeqnaxwhpyddrwhh")
    public suspend fun replicationSourceVaultId(`value`: Output<String>) {
        this.replicationSourceVaultId = value
    }

    /**
     * @param value The name of the backup vault. The name must be 1 to 64 characters in length.
     */
    @JvmName("wxjuvuqubbeydmku")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value The storage type of the backup vault. Valid values: `STANDARD`.
     */
    @JvmName("vruvcrahjqdbsdab")
    public suspend fun vaultStorageClass(`value`: Output<String>) {
        this.vaultStorageClass = value
    }

    /**
     * @param value The description of the backup vault. The description must be 0 to 255 characters in length.
     */
    @JvmName("kjdgeeiugwdbriei")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the region where the source vault resides.
     */
    @JvmName("vnnvjjhokkxortcs")
    public suspend fun replicationSourceRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSourceRegionId = mapped
    }

    /**
     * @param value The ID of the source vault.
     */
    @JvmName("wcsskiaihrumfxgf")
    public suspend fun replicationSourceVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSourceVaultId = mapped
    }

    /**
     * @param value The name of the backup vault. The name must be 1 to 64 characters in length.
     */
    @JvmName("tjjxjgoxgwnyevxu")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    /**
     * @param value The storage type of the backup vault. Valid values: `STANDARD`.
     */
    @JvmName("mqhebeibcwyuwfxr")
    public suspend fun vaultStorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultStorageClass = mapped
    }

    internal fun build(): ReplicationVaultArgs = ReplicationVaultArgs(
        description = description,
        replicationSourceRegionId = replicationSourceRegionId,
        replicationSourceVaultId = replicationSourceVaultId,
        vaultName = vaultName,
        vaultStorageClass = vaultStorageClass,
    )
}
